/*
 * NewJPanel.java
 *
 * Created on 2007/11/11, 21:19
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.SwingConstants;

/**
 *　カルテエディタパネル　MEMO:画面
 * @author  kazm
 */
public class KartePanelSingle extends PrintablePanel implements IKartePanel {

    private static final Color TIMESTAMP_FORE = Color.BLUE;
    private static final Color TIMESTAMP_HOSPITAL = Color.RED;
    private static final int TIMESTAMP_FONT_SIZE = 14;
    private static final Font TIMESTAMP_FONT = new Font("Dialog", Font.PLAIN, TIMESTAMP_FONT_SIZE);
    private boolean isFocused;
    private PrintKarte printTask;

    /** 
     * Creates new form NewJPanel
     * @param isHospital
     */
    public KartePanelSingle(boolean isHospital) {
        initComponents();
        timeStampLabel.setHorizontalAlignment(SwingConstants.CENTER);
        if (isHospital) {
            timeStampLabel.setForeground(TIMESTAMP_HOSPITAL);
        } else {
            timeStampLabel.setForeground(TIMESTAMP_FORE);
        }
        timeStampLabel.setFont(TIMESTAMP_FONT);

        FocusListener fd = new FocusListener() {

            @Override
            public void focusGained(FocusEvent e) {
                isFocused = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                isFocused = false;
            }
        };

        soaTextPane.addFocusListener(fd);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        timeStampLabel = new javax.swing.JLabel();
        soaTextPane = new javax.swing.JTextPane();

        jPanel2.setMaximumSize(new java.awt.Dimension(55, 26));

        timeStampLabel.setText("jLabel1");
        jPanel2.add(timeStampLabel);

        soaTextPane.setFont(new java.awt.Font("MS UI Gothic", 0, 16));
        soaTextPane.setMargin(new java.awt.Insets(10, 10, 10, 10));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 684, Short.MAX_VALUE)
            .add(soaTextPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 684, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(soaTextPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 628, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextPane soaTextPane;
    private javax.swing.JLabel timeStampLabel;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @return
     */
    @Override
    public JTextPane getSoaTextPane() {
        return soaTextPane;
    }

    /**
     *
     * @return
     */
    @Override
    public JTextPane getPTextPane() {
        return null;
    }

    /**
     *
     * @return
     */
    @Override
    public JLabel getTimeStampLabel() {
        return timeStampLabel;
    }

    /**
     *
     * @return
     */
    public boolean isFocused() {
        return isFocused;
    }

    /**
     *
     * @return
     */
    public PrintKarte getPrintTask() {
        return printTask;
    }
}
