/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import open.dolphin.infomodel.SimpleDate;

public class CalendarTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
    private String[] columnNames = COLUMN_NAMES;
    private Object[][] data;
    private Collection<SimpleDate> markDates;
    private int year;
    private int month;
    private int startDay;
    private int firstCell;
    private int lastCell;
    private int numCols = this.columnNames.length;
    private int numRows;
    private int numDaysOfMonth;
    private GregorianCalendar startDate;

    public CalendarTableModel(int year, int month) {
        this.year = year;
        this.month = month;
        GregorianCalendar gc = new GregorianCalendar(year, month, 1);
        this.firstCell = gc.get(7);
        --this.firstCell;
        this.numDaysOfMonth = gc.getActualMaximum(5);
        gc.add(5, this.numDaysOfMonth - 1);
        this.numRows = gc.get(4);
        this.lastCell = gc.get(7);
        --this.lastCell;
        this.lastCell += (this.numRows - 1) * this.numCols;
        gc.add(5, 1 - this.numDaysOfMonth);
        gc.add(5, -this.firstCell);
        this.startDate = (GregorianCalendar)gc.clone();
        this.startDay = gc.get(5);
        this.data = new Object[this.numRows][this.numCols];
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public Object getValueAt(int row, int col) {
        int cellNumber = row * this.numCols + col;
        Object ret = null;
        if (cellNumber < this.firstCell) {
            ret = String.valueOf(this.startDay + cellNumber);
        } else if (cellNumber > this.lastCell) {
            ret = String.valueOf(cellNumber - this.lastCell);
        } else {
            ret = this.data[row][col];
            if (ret == null) {
                return String.valueOf(1 + cellNumber - this.firstCell);
            }
        }
        return ret;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        int cellNumber = row * this.numCols + col;
        if (cellNumber < this.firstCell || cellNumber > this.lastCell) {
            return;
        }
        this.data[row][col] = value;
    }

    public void setMarkDates(Collection<SimpleDate> c) {
        this.markDates = c;
        this.clear();
        if (this.markDates != null) {
            Iterator<SimpleDate> iter = this.markDates.iterator();
            SimpleDate date = null;
            while (iter.hasNext()) {
                date = iter.next();
                if (this.year != date.getYear() || this.month != date.getMonth()) continue;
                int day = date.getDay();
                int cellNumber = this.firstCell + (day - 1);
                int row = cellNumber / this.numCols;
                int col = cellNumber % this.numCols;
                this.setValueAt(date, row, col);
            }
        }
        this.fireTableDataChanged();
    }

    public Collection<SimpleDate> getMarkDates() {
        return this.markDates;
    }

    public void clear() {
        this.data = new Object[this.numRows][this.numCols];
    }

    public boolean isOutOfMonth(int row, int col) {
        int cellNumber = row * this.numCols + col;
        return cellNumber < this.firstCell || cellNumber > this.lastCell;
    }

    public SimpleDate getFirstDate() {
        return new SimpleDate(this.year, this.month, 1);
    }

    public SimpleDate getLastDate() {
        return new SimpleDate(this.year, this.month, this.numDaysOfMonth);
    }

    public SimpleDate getDate(int row, int col) {
        int cellNumber = row * this.numCols + col;
        GregorianCalendar gc = (GregorianCalendar)this.startDate.clone();
        gc.add(5, cellNumber);
        int y = gc.get(1);
        int m = gc.get(2);
        int d = gc.get(5);
        return new SimpleDate(y, m, d);
    }
}

