/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import open.dolphin.client.IComponentHolder;
import open.dolphin.client.KartePane;
import open.dolphin.client.SchemaHolder;
import open.dolphin.client.SchemaList;
import open.dolphin.client.SchemaListTransferable;
import open.dolphin.infomodel.SchemaModel;

public class SchemaHolderTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -1293765478832142035L;

    @Override
    protected Transferable createTransferable(JComponent c) {
        SchemaHolder source = (SchemaHolder)c;
        KartePane context = source.getKartePane();
        context.setDrragedStamp(new IComponentHolder[]{source});
        context.setDraggedCount(1);
        SchemaModel schema = source.getSchema();
        SchemaList list = new SchemaList();
        list.schemaList = new SchemaModel[]{schema};
        SchemaListTransferable tr = new SchemaListTransferable(list);
        return tr;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        SchemaHolder test = (SchemaHolder)c;
        KartePane context = test.getKartePane();
        if (action == 2 && context.getDrragedStamp() != null && context.getDraggedCount() == context.getDroppedCount()) {
            context.removeSchema(test);
        }
        context.setDrragedStamp(null);
        context.setDraggedCount(0);
        context.setDroppedCount(0);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return false;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        KartePane kartePane;
        SchemaHolder sh = (SchemaHolder)comp;
        Transferable tr = this.createTransferable(comp);
        clip.setContents(tr, null);
        if (action == 2 && (kartePane = sh.getKartePane()).getTextPane().isEditable()) {
            kartePane.removeSchema(sh);
        }
    }
}

