/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import open.dolphin.client.Dolphin;
import open.dolphin.client.IMainComponent;
import open.dolphin.client.IMainWindow;
import open.dolphin.client.ObjectListTable;
import open.dolphin.client.SeparatorPanel;
import open.dolphin.client.labotestimporter.LaboTestFileTransferHandler;
import open.dolphin.helper.IMainCommandAccepter;
import open.dolphin.infomodel.LaboImportSummary;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.infomodel.PatientVisitModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.table.ObjectReflectTableModel;
import open.dolphin.utils.FileOpenDialog;

public class LaboTestImporter
extends JPanel
implements IMainComponent,
PropertyChangeListener,
IMainCommandAccepter {
    private String name;
    private String icon;
    private IMainWindow context;
    private static final String NAME = "\u30e9\u30dc\u30ec\u30b7\u30fc\u30d0";
    private LaboImportSummary selectedLabo;
    private int number = 100000;
    private ObjectListTable laboListTable;
    private JProgressBar usp;
    private JLabel countLabel;
    private JLabel dateLabel;

    public LaboTestImporter() {
        this.initComponents();
        this.name = NAME;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    public void start() {
        this.initCustomComponents();
        this.connect();
        this.enter();
    }

    @Override
    public void enter() {
        this.controlMenu();
    }

    @Override
    public void stop() {
    }

    public LaboImportSummary getSelectedLabo() {
        return this.selectedLabo;
    }

    @Override
    public boolean dispatchMainCommand(IMainCommandAccepter.MainCommand command) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public IMainWindow getContext() {
        return this.context;
    }

    @Override
    public void setContext(IMainWindow context) {
        this.context = context;
    }

    @Override
    public Callable<Boolean> getStartingTask() {
        return null;
    }

    @Override
    public Callable<Boolean> getStoppingTask() {
        return null;
    }

    @Override
    public void setMenu(Dolphin.MenuMediator midiator) {
    }

    public void setSelectedLabo(LaboImportSummary selectedLabo) {
        this.selectedLabo = selectedLabo;
        this.controlMenu();
    }

    private boolean openKarte() {
        final Preferences pref = Preferences.userNodeForPackage(this.getClass());
        boolean showReceiptMessage = pref.getBoolean("showReceiptMessage", true);
        showReceiptMessage = true;
        if (showReceiptMessage) {
            JLabel msg1 = new JLabel("\u53d7\u4ed8\u30ea\u30b9\u30c8\u304b\u3089\u30aa\u30fc\u30d7\u30f3\u3057\u306a\u3044\u3068\u8a3a\u7642\u30c7\u30fc\u30bf\u3092\u30ec\u30bb\u30b3\u30f3\u306b");
            JLabel msg2 = new JLabel("\u9001\u4fe1\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002\u7d9a\u3051\u307e\u3059\u304b?");
            final JCheckBox cb = new JCheckBox("\u4eca\u5f8c\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3057\u306a\u3044");
            cb.setFont(new Font("Dialog", 0, 10));
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    pref.putBoolean("showReceiptMessage", !cb.isSelected());
                }
            });
            JPanel p1 = new JPanel(new FlowLayout(0, 0, 3));
            p1.add(msg1);
            JPanel p2 = new JPanel(new FlowLayout(0, 0, 3));
            p2.add(msg2);
            JPanel p3 = new JPanel(new FlowLayout(0, 0, 3));
            p3.add(cb);
            JPanel box = new JPanel();
            box.setLayout(new BoxLayout(box, 1));
            box.add(p1);
            box.add(p2);
            box.add(p3);
            box.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 11));
            int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), new Object[]{box}, GlobalConstants.getFrameTitle(this.getName()), 0, 3, GlobalConstants.getImageIcon("about_32.gif"));
            if (option != 0) {
                return true;
            }
        }
        PatientModel patient = this.selectedLabo.getPatient();
        PatientVisitModel pvt = new PatientVisitModel();
        pvt.setNumber(this.number);
        ++this.number;
        pvt.setPatient(patient);
        StringBuilder sb = new StringBuilder();
        sb.append(GlobalVariables.getUserModel().getDepartmentModel().getDepartmentDesc());
        sb.append(",");
        sb.append(GlobalVariables.getUserModel().getDepartmentModel().getDepartment());
        pvt.setDepartment(sb.toString());
        this.getContext().openKarte(pvt, "");
        return true;
    }

    public ObjectListTable getLaboListTable() {
        return this.laboListTable;
    }

    public JProgressBar getProgressBar() {
        return this.usp;
    }

    public void updateCount() {
        int count = ((ObjectReflectTableModel)this.laboListTable.getModel()).getObjectCount();
        String text = "\u767b\u9332\u4ef6\u6570:";
        text = text + String.valueOf(count);
        this.countLabel.setText(text);
    }

    private void controlMenu() {
        PatientModel pvt = this.getSelectedLabo() != null ? this.getSelectedLabo().getPatient() : null;
        boolean enabled = this.canOpen(pvt);
        this.getContext().enabledAction("openKarte", enabled);
    }

    private boolean canOpen(PatientModel patient) {
        if (patient == null) {
            return false;
        }
        return !this.isKarteOpened(patient);
    }

    private boolean isKarteOpened(PatientModel patient) {
        return this.context.isKarteOpened(patient.getId());
    }

    private void initCustomComponents() {
        JButton iconButton = new JButton(GlobalConstants.getImageIcon("impt_24.gif"));
        JLabel instLabel = new JLabel("\u691c\u67fb\u7d50\u679c\u30d5\u30a1\u30a4\u30eb(MML\u5f62\u5f0f)\u3092\u4e0b\u306e\u30c6\u30fc\u30d6\u30eb\u306b Drag & Drop \u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        instLabel.setFont(new Font("Dialog", 0, 10));
        final JPanel importPanel = new JPanel(new FlowLayout(0));
        importPanel.add(iconButton);
        importPanel.add(instLabel);
        iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaboTestImporter.this.iconButtonClicked(importPanel);
            }
        });
        String[] columnNames = new String[]{"\u60a3\u8005\u6c0f\u540d", "\u6027\u5225", "\u30c6\u30b9\u30c8/\u691c\u4f53\u540d", "\u691c\u4f53\u63a1\u53d6\u65e5", "\u5831\u544a\u65e5", "\u30b9\u30c6\u30fc\u30bf\u30b9", "\u30e9\u30dc\u540d"};
        int startNumRows = 30;
        String[] methodNames = new String[]{"getPatientName", "getPatientGender", "getSetName", "getSampleTime", "getReportTime", "getReportStatus", "getLaboratoryCenter", ""};
        Class[] classes = GlobalConstants.getClassArray("labotestImport.classNames");
        int[] columnWidth = GlobalConstants.getIntArray("labotestImport.columnWidth");
        int rowHeight = 18;
        this.laboListTable = new ObjectListTable(columnNames, startNumRows, methodNames, classes);
        this.laboListTable.setSelectionMode(0);
        this.laboListTable.setColumnWidth(columnWidth);
        this.laboListTable.setRowHeight(rowHeight);
        JScrollPane scroller = this.laboListTable.getScroller();
        this.laboListTable.setTransferHandler(new LaboTestFileTransferHandler(this));
        this.usp = new JProgressBar();
        Font font = new Font("Dialog", 0, 10);
        this.countLabel = new JLabel("");
        this.dateLabel = new JLabel("");
        this.countLabel.setFont(font);
        this.dateLabel.setFont(font);
        this.countLabel.setHorizontalAlignment(0);
        this.dateLabel.setHorizontalAlignment(0);
        JPanel statusP = new JPanel(new FlowLayout(2, 5, 0));
        statusP.add(this.usp);
        statusP.add(this.countLabel);
        statusP.add(new SeparatorPanel());
        statusP.add(this.dateLabel);
        this.updateCount();
        String formatStr = "yyyy-MM-dd (EE)";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        this.dateLabel.setText(sdf.format(new Date()));
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)importPanel, "North");
        this.add((Component)scroller, "Center");
        this.add((Component)statusP, "South");
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
    }

    private void connect() {
        this.laboListTable.addPropertyChangeListener("doubleClickedObject", this);
        this.laboListTable.addMouseListener(new ContextListener());
        PropertyChangeListener pls = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("selectedObjects")) {
                    Object[] obj = (Object[])e.getNewValue();
                    LaboImportSummary value = obj != null && obj.length > 0 ? (LaboImportSummary)obj[0] : null;
                    LaboTestImporter.this.setSelectedLabo(value);
                }
            }
        };
        this.laboListTable.addPropertyChangeListener("selectedObjects", pls);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        LaboImportSummary value;
        String prop = e.getPropertyName();
        if (prop.equals("doubleClickedObject") && (value = (LaboImportSummary)e.getNewValue()) != null) {
            this.setSelectedLabo(value);
            if (this.canOpen(value.getPatient())) {
                this.openKarte();
            }
        }
    }

    private void iconButtonClicked(Component parent) {
        FileOpenDialog chooser = new FileOpenDialog(parent, "", 0, "");
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("\u30b9\u30bf\u30f3\u30d7\u30d5\u30a1\u30a4\u30eb", "xml", "txt");
        chooser.addChoosableFileFilter(filter);
        int result = chooser.open();
        if (result == 0) {
            File[] files = chooser.getSelectedFiles();
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.addAll(Arrays.asList(files));
            LaboTestFileTransferHandler handler = new LaboTestFileTransferHandler(this);
            handler.addFiles(fileList);
        }
    }

    class ContextListener
    extends MouseAdapter {
        ContextListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mabeShowPopup(e);
        }

        public void mabeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu contextMenu = new JPopupMenu();
                int row = LaboTestImporter.this.laboListTable.rowAtPoint(e.getPoint());
                Object obj = ((ObjectReflectTableModel)LaboTestImporter.this.laboListTable.getModel()).getObject(row);
                int selected = LaboTestImporter.this.laboListTable.getSelectedRow();
                if (row == selected && obj != null) {
                    String pop1 = "\u30ab\u30eb\u30c6\u3092\u958b\u304f";
                    contextMenu.add(new JMenuItem(new AbstractAction(pop1){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LaboTestImporter.this.openKarte();
                        }
                    }));
                }
                contextMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

