/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.delegater;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import open.dolphin.delegater.DelegaterErrorHandler;
import open.dolphin.dto.PatientSearchSpec;
import open.dolphin.infomodel.HealthInsuranceModel;
import open.dolphin.infomodel.PVTHealthInsuranceModel;
import open.dolphin.infomodel.PatientModel;
import open.dolphin.service.IPatientService;

public abstract class PatientDelegater
extends DelegaterErrorHandler {
    protected abstract IPatientService getService() throws NamingException;

    public PatientModel getPatient(String qId) {
        try {
            PatientModel ret = this.getService().getPatient(qId);
            this.decodeHealthInsurance(ret);
            return ret;
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return null;
        }
    }

    public List<PatientModel> getPatients(PatientSearchSpec spec) {
        try {
            List<PatientModel> patients = this.getService().getPatients(spec);
            if (patients != null) {
                for (PatientModel patient : patients) {
                    this.decodeHealthInsurance(patient);
                }
                return patients;
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
        return null;
    }

    public long putPatient(PatientModel patientValue) {
        try {
            return this.getService().addPatient(patientValue);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return 0L;
        }
    }

    public int updatePatient(PatientModel patient) {
        try {
            return this.getService().update(patient);
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
            return -1;
        }
    }

    private void decodeHealthInsurance(PatientModel patient) {
        try {
            Set<HealthInsuranceModel> insurances = patient.getHealthInsurances();
            if (insurances != null) {
                for (HealthInsuranceModel model : insurances) {
                    PVTHealthInsuranceModel hModel = model.toInfoModel();
                    patient.addPvtHealthInsurance(hModel);
                }
                insurances.clear();
                patient.setHealthInsurances(null);
            }
        }
        catch (Exception e) {
            this.dispatchError(this.getClass(), e, "");
        }
    }
}

