/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import open.dolphin.client.AbstractStampTreeBuilder;
import open.dolphin.client.TreeInfo;
import open.dolphin.client.editor.stamp.StampTree;
import open.dolphin.client.editor.stamp.StampTreeModel;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.infomodel.ModuleInfoBean;

public class ASpStampTreeBuilder
extends AbstractStampTreeBuilder {
    private StampTreeNode rootNode;
    private StampTreeNode node;
    private ModuleInfoBean info;
    private LinkedList<StampTreeNode> nodes;
    private List<StampTree> products;

    @Override
    public List<StampTree> getProduct() {
        return this.products;
    }

    @Override
    public void buildStart() {
        this.products = new ArrayList<StampTree>();
    }

    @Override
    public void buildRoot(String name, String entity) {
        this.nodes = new LinkedList();
        TreeInfo treeInfo = new TreeInfo();
        treeInfo.setName(name);
        treeInfo.setEntity(entity);
        this.rootNode = new StampTreeNode(treeInfo);
        this.nodes.addFirst(this.rootNode);
    }

    @Override
    public void buildNode(String name) {
        this.node = new StampTreeNode(name);
        this.getCurrentNode().add(this.node);
        this.nodes.addFirst(this.node);
    }

    @Override
    public void buildStampInfo(String name, String role, String entity, String editable, String memo, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(",").append(role).append(",").append(entity).append(",");
        sb.append(editable).append(",").append(memo).append(",").append(id);
        if (name.equals("\u30a8\u30c7\u30a3\u30bf\u304b\u3089\u767a\u884c...") && id == null && role.equals("p")) {
            return;
        }
        this.info = new ModuleInfoBean();
        this.info.initialize(null, name, null, entity, role);
        if (editable != null) {
            this.info.setEditable(Boolean.valueOf(editable));
        }
        if (memo != null) {
            this.info.setStampMemo(memo);
        }
        if (id != null) {
            this.info.setStampId(id);
        }
        this.node = new StampTreeNode(this.info);
        this.getCurrentNode().add(this.node);
    }

    @Override
    public void buildNodeEnd() {
        this.nodes.removeFirst();
    }

    @Override
    public void buildRootEnd() {
        StampTree tree = new StampTree(new StampTreeModel(this.rootNode));
        this.products.add(tree);
    }

    @Override
    public void buildEnd() {
    }

    private StampTreeNode getCurrentNode() {
        return this.nodes.getFirst();
    }
}

