/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.RegexConstrainedDocument;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.delegater.remote.RemoteUserDelegater;
import open.dolphin.helper.ComponentMemory;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.FacilityModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalSettings;
import open.dolphin.project.GlobalVariables;
import open.dolphin.security.EncryptUtil;
import open.dolphin.table.ObjectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

public class UserDialog
extends JDialog {
    private static final String TITLE = "\u30e6\u30fc\u30b6\u7ba1\u7406";
    private static final String FACILITY_INFO = "\u65bd\u8a2d\u60c5\u5831";
    private static final String ADD_USER = "\u30e6\u30fc\u30b6\u767b\u9332";
    private static final String LIST_USER = "\u30e6\u30fc\u30b6\u30ea\u30b9\u30c8";
    private static final String FACILITY_SUCCESS_MSG = "\u65bd\u8a2d\u60c5\u5831\u3092\u66f4\u65b0\u3057\u307e\u3057\u305f\u3002";
    private static final String ADD_USER_SUCCESS_MSG = "\u30e6\u30fc\u30b6\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002";
    private static final String DELETE_USER_SUCCESS_MSG = "\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002";
    private static final String DELETE_OK_USER_ = "\u9078\u629e\u3057\u305f\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3057\u307e\u3059";
    private static final String FACILITY_ERROR_MSG = "\u65bd\u8a2d\u60c5\u5831\u3092\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private static final String ADD_USER_ERROR_MSG = "\u30e6\u30fc\u30b6\u3092\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private static final String DELETE_USER_ERROR_MSG = "\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private static final String DELETE_NG_USER_ = "\u9078\u629e\u3057\u305f\u30e6\u30fc\u30b6\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f";
    private static int DEFAULT_WIDTH = 600;
    private static int DEFAULT_HEIGHT = 370;
    private JDialog dialog;
    private ApplicationContext appCtx;
    private Application app;
    private TaskService taskService;
    private TaskMonitor taskMonitor;

    public UserDialog() {
        this.setName(TITLE);
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
        this.taskService = this.appCtx.getTaskService();
        this.taskMonitor = this.appCtx.getTaskMonitor();
    }

    public void start() {
        String title = GlobalConstants.getFrameTitle(this.getName());
        this.dialog = this;
        this.setTitle(title);
        this.setModal(true);
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        this.setIconImage(icon.getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserDialog.this.stop();
            }
        });
        ComponentMemory cm = new ComponentMemory(this, new Point(0, 0), new Dimension(new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT)), this);
        cm.putCenter();
        AddUserPanel ap = new AddUserPanel();
        FacilityInfoPanel fp = new FacilityInfoPanel();
        UserListPanel mp = new UserListPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(FACILITY_INFO, fp);
        tabbedPane.addTab(ADD_USER, ap);
        tabbedPane.addTab(LIST_USER, mp);
        fp.get();
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
        this.dispose();
    }

    private void constrain(JPanel container, Component cmp, int x, int y, int width, int height, int fill, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        c.gridheight = height;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = new Insets(0, 0, 5, 7);
        ((GridBagLayout)container.getLayout()).setConstraints(cmp, c);
        container.add(cmp);
    }

    protected class AddUserPanel
    extends JPanel {
        private JTextField uid;
        private JPasswordField userPassword1;
        private JPasswordField userPassword2;
        private JTextField sn;
        private JTextField givenName;
        private LicenseModel[] licenses;
        private JComboBox licenseCombo;
        private DepartmentModel[] depts;
        private JComboBox deptCombo;
        private JTextField emailField;
        private JButton okButton;
        private JButton cancelButton;
        private boolean ok;
        private int[] userIdLength = GlobalConstants.getIntArray("addUser.userId.length");
        private int[] passwordLength = GlobalConstants.getIntArray("addUser.password.length");
        private String idPassPattern = "[A-Za-z0-9_+\\-.#$&@]*";
        private String usersRole = "user";

        public AddUserPanel() {
            DocumentListener dl = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AddUserPanel.this.checkButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    AddUserPanel.this.checkButton();
                }
            };
            this.uid = new JTextField();
            this.uid.setColumns(10);
            this.uid.getDocument().addDocumentListener(dl);
            this.uid.setDocument(new RegexConstrainedDocument(this.idPassPattern));
            this.uid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.userPassword1.requestFocus();
                }
            });
            this.uid.addFocusListener(AutoRomanListener.getInstance());
            this.userPassword1 = new JPasswordField();
            this.userPassword1.setColumns(10);
            this.userPassword1.getDocument().addDocumentListener(dl);
            this.userPassword1.setDocument(new RegexConstrainedDocument(this.idPassPattern));
            this.userPassword1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.userPassword2.requestFocus();
                }
            });
            this.userPassword1.addFocusListener(AutoRomanListener.getInstance());
            this.userPassword2 = new JPasswordField();
            this.userPassword2.setColumns(10);
            this.userPassword2.getDocument().addDocumentListener(dl);
            this.userPassword2.setDocument(new RegexConstrainedDocument(this.idPassPattern));
            this.userPassword2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.sn.requestFocus();
                }
            });
            this.userPassword2.addFocusListener(AutoRomanListener.getInstance());
            this.sn = new JTextField();
            this.sn.setColumns(10);
            this.sn.getDocument().addDocumentListener(dl);
            this.sn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.givenName.requestFocus();
                }
            });
            this.sn.addFocusListener(AutoKanjiListener.getInstance());
            this.givenName = new JTextField();
            this.givenName.setColumns(10);
            this.givenName.getDocument().addDocumentListener(dl);
            this.givenName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.emailField.requestFocus();
                }
            });
            this.givenName.addFocusListener(AutoKanjiListener.getInstance());
            this.emailField = new JTextField();
            this.emailField.setColumns(15);
            this.emailField.getDocument().addDocumentListener(dl);
            this.emailField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.uid.requestFocus();
                }
            });
            this.emailField.addFocusListener(AutoRomanListener.getInstance());
            this.licenses = GlobalConstants.getLicenseModel();
            this.licenseCombo = new JComboBox<LicenseModel>(this.licenses);
            this.depts = GlobalConstants.getDepartmentModel();
            this.deptCombo = new JComboBox<DepartmentModel>(this.depts);
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddUserPanel.this.addUserEntry();
                }
            };
            this.okButton = new JButton("\u8ffd\u52a0");
            this.okButton.addActionListener(al);
            this.okButton.setEnabled(false);
            this.cancelButton = new JButton("\u9589\u3058\u308b");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDialog.this.stop();
                }
            });
            JPanel content = new JPanel(new GridBagLayout());
            int x = 0;
            int y = 0;
            JLabel label = new JLabel("\u30e6\u30fc\u30b6ID:", 4);
            UserDialog.this.constrain(content, label, x, y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.uid, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.userPassword1, x + 1, y, 1, 1, 0, 17);
            label = new JLabel("\u78ba\u8a8d:", 4);
            UserDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.userPassword2, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u59d3:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.sn, x + 1, y, 1, 1, 0, 17);
            label = new JLabel("\u540d:", 4);
            UserDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.givenName, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u533b\u7642\u8cc7\u683c:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.licenseCombo, x + 1, y, 1, 1, 0, 17);
            label = new JLabel("\u8a3a\u7642\u79d1:", 4);
            UserDialog.this.constrain(content, label, x + 2, y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.deptCombo, x + 3, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u96fb\u5b50\u30e1\u30fc\u30eb:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.emailField, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(" ", 4);
            UserDialog.this.constrain(content, label, x, ++y, 4, 1, 1, 13);
            x = 0;
            label = new JLabel("\u30e6\u30fc\u30b6ID - \u534a\u89d2\u82f1\u6570\u8a18\u3067" + this.userIdLength[0] + "\u6587\u5b57\u4ee5\u4e0a" + this.userIdLength[1] + "\u6587\u5b57\u4ee5\u5185");
            UserDialog.this.constrain(content, label, x, ++y, 4, 1, 2, 13);
            x = 0;
            label = new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9 - \u534a\u89d2\u82f1\u6570\u8a18\u3067" + this.passwordLength[0] + "\u6587\u5b57\u4ee5\u4e0a" + this.passwordLength[1] + "\u6587\u5b57\u4ee5\u5185");
            UserDialog.this.constrain(content, label, x, ++y, 4, 1, 2, 13);
            JPanel btnPanel = null;
            if (GlobalConstants.isMac()) {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.cancelButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.okButton);
            } else {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.okButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.cancelButton);
            }
            this.setLayout(new BorderLayout(0, 17));
            this.add((Component)content, "Center");
            this.add((Component)btnPanel, "South");
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        }

        private void addUserEntry() {
            if (!this.userIdOk()) {
                return;
            }
            if (!this.passwordOk()) {
                return;
            }
            String userId = this.uid.getText().trim();
            String pass = new String(this.userPassword1.getPassword());
            UserModel loginUser = GlobalVariables.getUserModel();
            String facilityId = loginUser.getFacility().getFacilityId();
            String hashPass = EncryptUtil.createPasswordHash(pass);
            pass = null;
            final UserModel user = new UserModel();
            user.initialize(facilityId, this.uid.getText(), this.sn.getText(), this.givenName.getText(), hashPass);
            user.setFacility(GlobalVariables.getUserModel().getFacility());
            int index = this.licenseCombo.getSelectedIndex();
            user.setLicenseModel(this.licenses[index]);
            index = this.deptCombo.getSelectedIndex();
            user.setDepartmentModel(this.depts[index]);
            user.setMemberType(GlobalVariables.getUserModel().getMemberType());
            if (GlobalVariables.getUserModel().getMemberType().equals("ASP_TESTER")) {
                user.setRegisteredDate(GlobalVariables.getUserModel().getRegisteredDate());
            } else {
                user.setRegisteredDate(new Date());
            }
            user.setEmail(this.emailField.getText().trim());
            RoleModel rm = new RoleModel();
            rm.setRole(this.usersRole);
            user.addRole(rm);
            rm.setUser(user);
            rm.setUserId(user.getUserId());
            final RemoteUserDelegater udl = new RemoteUserDelegater();
            int maxEstimation = 60000;
            int delay = 200;
            String addMsg = "\u767b\u9332\u3057\u3066\u3044\u307e\u3059...";
            Task<Boolean, Void> task = new Task<Boolean, Void>(UserDialog.this.app){

                protected Boolean doInBackground() throws Exception {
                    int cnt = udl.putUser(user);
                    return cnt > 0 ? new Boolean(true) : new Boolean(false);
                }

                protected void succeeded(Boolean results) {
                    if (results.booleanValue()) {
                        JOptionPane.showMessageDialog(UserDialog.this.dialog, UserDialog.ADD_USER_SUCCESS_MSG, GlobalConstants.getFrameTitle(AddUserPanel.this.getName()), 1);
                    } else {
                        JOptionPane.showMessageDialog(UserDialog.this.dialog, UserDialog.ADD_USER_ERROR_MSG, GlobalConstants.getFrameTitle(AddUserPanel.this.getName()), 2);
                    }
                }

                protected void cancelled() {
                }

                protected void failed(Throwable cause) {
                }

                protected void interrupted(InterruptedException e) {
                }
            };
            Object message = null;
            TaskTimerMonitor w = new TaskTimerMonitor((Task)task, UserDialog.this.taskMonitor, UserDialog.this.dialog, message, addMsg, delay, maxEstimation);
            UserDialog.this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
            UserDialog.this.taskService.execute((Task)task);
        }

        private boolean userIdOk() {
            String userId = this.uid.getText().trim();
            if (userId.equals("")) {
                return false;
            }
            int len = userId.length();
            return len >= this.userIdLength[0] && len <= this.userIdLength[1];
        }

        private boolean passwordOk() {
            String passwd1 = new String(this.userPassword1.getPassword());
            String passwd2 = new String(this.userPassword2.getPassword());
            if (passwd1.equals("") || passwd2.equals("")) {
                return false;
            }
            if (passwd1.length() < this.passwordLength[0] || passwd1.length() > this.passwordLength[1]) {
                return false;
            }
            if (passwd2.length() < this.passwordLength[0] || passwd2.length() > this.passwordLength[1]) {
                return false;
            }
            return passwd1.equals(passwd2);
        }

        private void checkButton() {
            boolean newOk;
            boolean userOk = this.userIdOk();
            boolean passwordOk = this.passwordOk();
            boolean snOk = !this.sn.getText().trim().equals("");
            boolean givenOk = !this.givenName.getText().trim().equals("");
            boolean emailOk = !this.emailField.getText().trim().equals("");
            boolean bl = newOk = userOk && passwordOk && snOk && givenOk && emailOk;
            if (this.ok != newOk) {
                this.ok = newOk;
                this.okButton.setEnabled(this.ok);
            }
        }
    }

    protected class UserListPanel
    extends JPanel {
        private ObjectTableModel tableModel;
        private JTable table;
        private JButton getButton;
        private JButton deleteButton;
        private JButton cancelButton;

        public UserListPanel() {
            String[] columns = new String[]{"\u30e6\u30fc\u30b6ID", "\u59d3", "\u540d", "\u533b\u7642\u8cc7\u683c", "\u8a3a\u7642\u79d1"};
            this.tableModel = new ObjectTableModel(columns, 7){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    UserModel entry = (UserModel)this.getObject(row);
                    if (entry == null) {
                        return null;
                    }
                    String ret = null;
                    switch (col) {
                        case 0: {
                            ret = entry.idAsLocal();
                            break;
                        }
                        case 1: {
                            ret = entry.getSirName();
                            break;
                        }
                        case 2: {
                            ret = entry.getGivenName();
                            break;
                        }
                        case 3: {
                            ret = entry.getLicenseModel().getLicenseDesc();
                            break;
                        }
                        case 4: {
                            ret = entry.getDepartmentModel().getDepartmentDesc();
                        }
                    }
                    return ret;
                }
            };
            this.table = new JTable(this.tableModel);
            this.table.setSelectionMode(0);
            this.table.setRowSelectionAllowed(true);
            this.table.setToolTipText(UserDialog.DELETE_OK_USER_);
            ListSelectionModel m = this.table.getSelectionModel();
            m.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int index = UserListPanel.this.table.getSelectedRow();
                        UserModel entry = (UserModel)UserListPanel.this.tableModel.getObject(index);
                        if (entry == null) {
                            return;
                        }
                        UserListPanel.this.controleDelete(entry);
                    }
                }
            });
            JScrollPane scroller = new JScrollPane(this.table, 20, 31);
            scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
            this.getButton = new JButton(UserDialog.LIST_USER);
            this.getButton.setEnabled(true);
            this.getButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserListPanel.this.getUsers();
                }
            });
            this.deleteButton = new JButton("\u524a\u9664");
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserListPanel.this.deleteUser();
                }
            });
            this.deleteButton.setToolTipText(UserDialog.DELETE_OK_USER_);
            this.cancelButton = new JButton("\u9589\u3058\u308b");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDialog.this.stop();
                }
            });
            JPanel btnPanel = null;
            if (GlobalConstants.isMac()) {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.deleteButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.cancelButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.getButton);
            } else {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.getButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.deleteButton);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.cancelButton);
            }
            this.setLayout(new BorderLayout(0, 17));
            this.add((Component)scroller, "Center");
            this.add((Component)btnPanel, "South");
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        }

        private void controleDelete(UserModel user) {
            boolean isMe = user.getId() == GlobalVariables.getUserModel().getId();
            this.deleteButton.setEnabled(!isMe);
        }

        private void getUsers() {
            final RemoteUserDelegater udl = new RemoteUserDelegater();
            int maxEstimation = 60000;
            int delay = 200;
            String note = "\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...";
            Task<List, Void> task = new Task<List, Void>(UserDialog.this.app){

                protected List doInBackground() throws Exception {
                    List<UserModel> result = udl.getAllUser();
                    return result;
                }

                protected void succeeded(List results) {
                    if (udl.isError()) {
                        JOptionPane.showMessageDialog(UserDialog.this.dialog, "\u65bd\u8a2d\u5185\u5168\u30e6\u30fc\u30b6\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f.", GlobalConstants.getFrameTitle(UserListPanel.this.getName()), 2);
                    } else {
                        UserListPanel.this.tableModel.setObjectList(results);
                    }
                }

                protected void cancelled() {
                }

                protected void failed(Throwable cause) {
                }

                protected void interrupted(InterruptedException e) {
                }
            };
            Object message = null;
            TaskTimerMonitor w = new TaskTimerMonitor((Task)task, UserDialog.this.taskMonitor, UserDialog.this.dialog, message, note, delay, maxEstimation);
            UserDialog.this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
            UserDialog.this.taskService.execute((Task)task);
        }

        private void deleteUser() {
            int row = this.table.getSelectedRow();
            UserModel entry = (UserModel)this.tableModel.getObject(row);
            if (entry == null) {
                return;
            }
            boolean deleteDoc = true;
            if (entry.getLicenseModel().getLicense().equals("doctor")) {
                deleteDoc = false;
            }
            final RemoteUserDelegater udl = new RemoteUserDelegater();
            int maxEstimation = 60000;
            int delay = 200;
            String note = "\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
            final String deleteId = entry.getUserId();
            Task<List, Void> task = new Task<List, Void>(UserDialog.this.app){

                protected List doInBackground() throws Exception {
                    List<UserModel> result = null;
                    if (udl.removeUser(deleteId) > 0) {
                        result = udl.getAllUser();
                    }
                    return result;
                }

                protected void succeeded(List results) {
                    if (udl.isError()) {
                        LogWriter.warn(UserDialog.class, udl.getErrorMessage());
                        JOptionPane.showMessageDialog(UserDialog.this.dialog, UserDialog.DELETE_USER_ERROR_MSG, GlobalConstants.getFrameTitle(UserListPanel.this.getName()), 2);
                    } else {
                        UserListPanel.this.tableModel.setObjectList(results);
                        JOptionPane.showMessageDialog(UserDialog.this.dialog, UserDialog.DELETE_USER_SUCCESS_MSG, GlobalConstants.getFrameTitle(UserListPanel.this.getName()), 1);
                    }
                }

                protected void cancelled() {
                }

                protected void failed(Throwable cause) {
                }

                protected void interrupted(InterruptedException e) {
                }
            };
            Object message = null;
            TaskTimerMonitor w = new TaskTimerMonitor((Task)task, UserDialog.this.taskMonitor, UserDialog.this.dialog, message, note, delay, maxEstimation);
            UserDialog.this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
            UserDialog.this.taskService.execute((Task)task);
        }
    }

    protected class FacilityInfoPanel
    extends JPanel {
        private JTextField facilityName;
        private JTextField zipField1;
        private JTextField zipField2;
        private JTextField addressField;
        private JTextField areaField;
        private JTextField cityField;
        private JTextField numberField;
        private JTextField urlField;
        private JButton updateBtn;
        private JButton clearBtn;
        private JButton closeBtn;
        private boolean hasInitialized;

        public FacilityInfoPanel() {
            DocumentListener dl = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FacilityInfoPanel.this.checkButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FacilityInfoPanel.this.checkButton();
                }
            };
            this.facilityName = new JTextField();
            this.facilityName.setColumns(30);
            this.facilityName.getDocument().addDocumentListener(dl);
            this.zipField1 = new JTextField();
            this.zipField1.setColumns(3);
            this.zipField1.getDocument().addDocumentListener(dl);
            this.zipField2 = new JTextField();
            this.zipField2.setColumns(3);
            this.zipField2.getDocument().addDocumentListener(dl);
            this.addressField = new JTextField();
            this.addressField.setColumns(30);
            this.addressField.getDocument().addDocumentListener(dl);
            this.areaField = new JTextField();
            this.areaField.setColumns(3);
            this.areaField.getDocument().addDocumentListener(dl);
            this.cityField = new JTextField();
            this.cityField.setColumns(3);
            this.cityField.getDocument().addDocumentListener(dl);
            this.numberField = new JTextField();
            this.numberField.setColumns(3);
            this.numberField.getDocument().addDocumentListener(dl);
            this.urlField = new JTextField();
            this.urlField.setColumns(30);
            this.urlField.getDocument().addDocumentListener(dl);
            this.facilityName.addFocusListener(AutoKanjiListener.getInstance());
            this.zipField1.addFocusListener(AutoRomanListener.getInstance());
            this.zipField2.addFocusListener(AutoRomanListener.getInstance());
            this.addressField.addFocusListener(AutoKanjiListener.getInstance());
            this.areaField.addFocusListener(AutoRomanListener.getInstance());
            this.cityField.addFocusListener(AutoRomanListener.getInstance());
            this.numberField.addFocusListener(AutoRomanListener.getInstance());
            this.urlField.addFocusListener(AutoRomanListener.getInstance());
            this.updateBtn = new JButton("\u66f4\u65b0");
            this.updateBtn.setEnabled(false);
            this.updateBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FacilityInfoPanel.this.update();
                }
            });
            this.clearBtn = new JButton("\u623b\u3059");
            this.clearBtn.setEnabled(false);
            this.clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FacilityInfoPanel.this.get();
                }
            });
            this.closeBtn = new JButton("\u9589\u3058\u308b");
            this.closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDialog.this.stop();
                }
            });
            JPanel content = new JPanel(new GridBagLayout());
            int x = 0;
            int y = 0;
            JLabel label = new JLabel("\u533b\u7642\u6a5f\u95a2\u540d:", 4);
            UserDialog.this.constrain(content, label, x, y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.facilityName, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u90f5\u4fbf\u756a\u53f7:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(0, 0, 0));
            p.add(this.zipField1);
            p.add(new JLabel(" - "));
            p.add(this.zipField2);
            UserDialog.this.constrain(content, p, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u4f4f  \u6240:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.addressField, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("\u96fb\u8a71\u756a\u53f7:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            JPanel telephonePanel = new JPanel();
            telephonePanel.setLayout(new FlowLayout(0, 0, 0));
            telephonePanel.add(this.areaField);
            telephonePanel.add(new JLabel(" - "));
            telephonePanel.add(this.cityField);
            telephonePanel.add(new JLabel(" - "));
            telephonePanel.add(this.numberField);
            UserDialog.this.constrain(content, telephonePanel, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel("URL:", 4);
            UserDialog.this.constrain(content, label, x, ++y, 1, 1, 0, 13);
            UserDialog.this.constrain(content, this.urlField, x + 1, y, 1, 1, 0, 17);
            x = 0;
            label = new JLabel(" ", 4);
            UserDialog.this.constrain(content, label, x, ++y, 2, 1, 1, 13);
            JPanel btnPanel = null;
            if (GlobalConstants.isMac()) {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.clearBtn);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.closeBtn);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.updateBtn);
            } else {
                btnPanel = new JPanel();
                btnPanel.setLayout(new BoxLayout(btnPanel, 0));
                btnPanel.add(Box.createHorizontalGlue());
                btnPanel.add(this.updateBtn);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.clearBtn);
                btnPanel.add(Box.createHorizontalStrut(5));
                btnPanel.add(this.closeBtn);
            }
            this.setLayout(new BorderLayout(0, 11));
            this.add((Component)content, "Center");
            this.add((Component)btnPanel, "South");
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        }

        public void get() {
            StringTokenizer st;
            String val;
            UserModel user = GlobalVariables.getUserModel();
            FacilityModel facility = user.getFacility();
            if (facility.getFacilityName() != null) {
                this.facilityName.setText(facility.getFacilityName());
            }
            if (facility.getZipCode() != null) {
                val = facility.getZipCode();
                try {
                    st = new StringTokenizer(val, "-");
                    if (st.hasMoreTokens()) {
                        this.zipField1.setText(st.nextToken());
                        this.zipField2.setText(st.nextToken());
                    }
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
            if (facility.getAddress() != null) {
                this.addressField.setText(facility.getAddress());
            }
            if (facility.getTelephone() != null) {
                val = facility.getTelephone();
                try {
                    st = new StringTokenizer(val, "-");
                    if (st.hasMoreTokens()) {
                        this.areaField.setText(st.nextToken());
                        this.cityField.setText(st.nextToken());
                        this.numberField.setText(st.nextToken());
                    }
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
            if (facility.getUrl() != null) {
                this.urlField.setText(facility.getUrl());
            }
            this.hasInitialized = true;
        }

        private void checkButton() {
            if (this.hasInitialized) {
                boolean numberEmpty;
                boolean nameEmpty = this.facilityName.getText().trim().equals("");
                boolean zip1Empty = this.zipField1.getText().trim().equals("");
                boolean zip2Empty = this.zipField2.getText().trim().equals("");
                boolean addressEmpty = this.addressField.getText().trim().equals("");
                boolean areaEmpty = this.areaField.getText().trim().equals("");
                boolean cityEmpty = this.cityField.getText().trim().equals("");
                boolean bl = numberEmpty = this.numberField.getText().trim().equals("");
                if (nameEmpty && zip1Empty && zip2Empty && addressEmpty && areaEmpty && cityEmpty && numberEmpty) {
                    if (this.clearBtn.isEnabled()) {
                        this.clearBtn.setEnabled(false);
                    }
                } else if (!this.clearBtn.isEnabled()) {
                    this.clearBtn.setEnabled(true);
                }
                if (nameEmpty) {
                    if (this.updateBtn.isEnabled()) {
                        this.updateBtn.setEnabled(false);
                    }
                    return;
                }
                if (!this.updateBtn.isEnabled()) {
                    this.updateBtn.setEnabled(true);
                }
            }
        }

        private void update() {
            UserModel user = GlobalVariables.getUserModel();
            FacilityModel facility = user.getFacility();
            String val = this.facilityName.getText().trim();
            if (!val.equals("")) {
                facility.setFacilityName(val);
            }
            val = this.zipField1.getText().trim();
            String val2 = this.zipField2.getText().trim();
            if (!val.equals("") && !val2.equals("")) {
                facility.setZipCode(val + "-" + val2);
            }
            if (!(val = this.addressField.getText().trim()).equals("")) {
                facility.setAddress(val);
            }
            val = this.areaField.getText().trim();
            val2 = this.cityField.getText().trim();
            String val3 = this.numberField.getText().trim();
            if (!(val.equals("") || val2.equals("") || val3.equals(""))) {
                facility.setTelephone(val + "-" + val2 + "-" + val3);
            }
            if (!(val = this.urlField.getText().trim()).equals("")) {
                facility.setUrl(val);
            }
            RemoteUserDelegater udl = new RemoteUserDelegater();
            try {
                Boolean result;
                int cnt = udl.updateFacility(user);
                Boolean bl = result = cnt > 0 ? new Boolean(true) : new Boolean(false);
                if (result.booleanValue()) {
                    JOptionPane.showMessageDialog(this, UserDialog.FACILITY_SUCCESS_MSG, GlobalConstants.getFrameTitle(this.getName()), 1);
                } else {
                    JOptionPane.showMessageDialog(this, UserDialog.FACILITY_ERROR_MSG, GlobalConstants.getFrameTitle(this.getName()), 2);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

