/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.injectionmedicine;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import open.dolphin.client.MasterRenderer;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.order.AbstractMasterPanel;
import open.dolphin.table.ObjectTableModel;

public class InjectionMedicineMasterPanel
extends AbstractMasterPanel {
    private static final long serialVersionUID = -2421788488403402829L;
    private static final String[] medicineColumns = new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u30ab \u30ca", "\u5358\u4f4d", "\u70b9\u6570\u8b58\u5225", "\u70b9\u6570/\u91d1\u984d", "\u85ac\u4fa1\u57fa\u6e96", "\u958b\u59cb\u5e74\u6708\u65e5", "\u7d42\u4e86\u5e74\u6708\u65e5"};
    private static final String[] costFlags = new String[]{"\u5ec3", "\u91d1", "\u90fd", "", "", "", "", "\u6e1b", "\u4e0d"};
    private static final String[] sortColumnNames = new String[]{"srycd", "name", "kananame", "taniname", "tensikibetu", "ten", "yakkakjncd", "yukostymd", "yukoedymd"};
    private JPanel key;
    private JScrollPane scroller;
    private JTable table;
    private JPanel top;

    public InjectionMedicineMasterPanel(String master) {
        super(master);
        this.setSearchClass("40");
    }

    @Override
    protected void initialize() {
        this.initComponents();
        this.tableModel = new ObjectTableModel(medicineColumns, 20){

            public Class getColumnClass(int col) {
                return MedicineEntry.class;
            }
        };
        this.table.setModel(this.tableModel);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InjectionMedicineMasterPanel.this.doSort(e);
            }
        });
        TableColumn column = null;
        int[] width = new int[]{50, 200, 200, 40, 30, 50, 50};
        int len = width.length;
        for (int i = 0; i < len; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(width[i]);
        }
        MedicineMasterRenderer mr = new MedicineMasterRenderer();
        mr.setBeforStartColor(masterColors[0]);
        mr.setInUseColor(masterColors[1]);
        mr.setAfterEndColor(masterColors[2]);
        mr.setCostFlag(costFlags);
        this.table.setDefaultRenderer(MedicineEntry.class, mr);
        this.key.setLayout(new FlowLayout(0, 7, 5));
        this.key.add(this.findLabel);
        this.key.add(new JLabel(masterTabNames[2] + ":"));
        this.key.add(this.keywordField);
        this.key.add(this.isForwordCheckBox);
        this.key.setBorder(BorderFactory.createTitledBorder("\u30ad\u30fc\u30ef\u30fc\u30c9\u691c\u7d22"));
        this.top.setLayout(new BoxLayout(this.top, 0));
        this.top.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)this.top, "North");
        this.add((Component)this.scroller, "Center");
    }

    private void doSort(MouseEvent e) {
        int viewColumn = this.table.getTableHeader().columnAtPoint(e.getPoint());
        int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
        this.setSortBy(sortColumnNames[modelColumn]);
        String _key = this.keywordField.getText().trim();
        this.search(_key, !this.isForwordCheckBox.isSelected());
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.top = new JPanel();
        this.key = new JPanel();
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InjectionMedicineMasterPanel.this.tableMouseClicked(evt);
            }
        });
        this.scroller.setViewportView(this.table);
        this.top.setName("top");
        this.key.setName("key");
        GroupLayout keyLayout = new GroupLayout(this.key);
        this.key.setLayout(keyLayout);
        keyLayout.setHorizontalGroup(keyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 495, Short.MAX_VALUE));
        keyLayout.setVerticalGroup(keyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 29, Short.MAX_VALUE));
        GroupLayout topLayout = new GroupLayout(this.top);
        this.top.setLayout(topLayout);
        topLayout.setHorizontalGroup(topLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topLayout.createSequentialGroup().addContainerGap().addComponent(this.key, -1, -1, Short.MAX_VALUE).addContainerGap()));
        topLayout.setVerticalGroup(topLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topLayout.createSequentialGroup().addContainerGap().addComponent(this.key, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.top, -1, -1, Short.MAX_VALUE).addComponent(this.scroller, -1, 519, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.top, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroller, -1, 144, Short.MAX_VALUE)));
    }

    private void tableMouseClicked(MouseEvent evt) {
        int row;
        MedicineEntry o;
        if (evt.getClickCount() == 2 && (o = (MedicineEntry)this.tableModel.getObject(row = this.table.getSelectedRow())) != null && o.isInUse()) {
            MasterItem mItem = new MasterItem(2, o);
            mItem.setUnit(o.getUnit());
            this.setSelectedItem(mItem);
        }
    }

    protected final class MedicineMasterRenderer
    extends MasterRenderer {
        private static final long serialVersionUID = 8567079934909643686L;
        private final int CODE_COLUMN = 0;
        private final int NAME_COLUMN = 1;
        private final int KANA_COLUMN = 2;
        private final int UNIT_COLUMN = 3;
        private final int COST_FLAG_COLUMN = 4;
        private final int COST_COLUMN = 5;
        private final int JNCD_COLUMN = 6;
        private final int START_COLUMN = 7;
        private final int END_COLUMN = 8;
        private String[] costFlags;

        public String[] getCostFlag() {
            return this.costFlags;
        }

        public void setCostFlag(String[] val) {
            this.costFlags = val;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            JLabel label = (JLabel)c;
            if (value != null && value instanceof MedicineEntry) {
                MedicineEntry entry = (MedicineEntry)value;
                String startDate = entry.getStartDate();
                String endDate = entry.getEndDate();
                this.setColor(label, startDate, endDate);
                switch (col) {
                    case 0: {
                        label.setText(entry.getCode());
                        break;
                    }
                    case 1: {
                        label.setText(entry.getName());
                        break;
                    }
                    case 2: {
                        label.setText(entry.getKana());
                        break;
                    }
                    case 3: {
                        label.setText(entry.getUnit());
                        break;
                    }
                    case 4: {
                        try {
                            int index = Integer.parseInt(entry.getCostFlag());
                            label.setText(this.costFlags[index]);
                        }
                        catch (Exception e) {
                            label.setText("");
                        }
                        break;
                    }
                    case 5: {
                        label.setText(entry.getCost());
                        break;
                    }
                    case 6: {
                        label.setText(entry.getJNCD());
                        break;
                    }
                    case 7: {
                        if (startDate.startsWith("0")) {
                            label.setText("");
                            break;
                        }
                        label.setText(startDate);
                        break;
                    }
                    case 8: {
                        if (endDate.startsWith("9")) {
                            label.setText("");
                            break;
                        }
                        label.setText(endDate);
                    }
                }
            } else {
                label.setBackground(Color.white);
                label.setText(value == null ? "" : value.toString());
            }
            return c;
        }
    }
}

