/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.component;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import open.dolphin.component.DnDTabbedPane;
import open.dolphin.component.GhostGlassPane;

public class TabTransferHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(DnDTabbedPane.class, "application/x-java-jvm-local-objectref", "DnDTabbedPane");
    private GhostGlassPane glassPane;

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new DataHandler((Object)c, this.localObjectFlavor.getMimeType());
    }

    private Component getTarget(TransferHandler.TransferSupport support) {
        return support.getComponent();
    }

    private Component getSource(TransferHandler.TransferSupport support) {
        Component result = null;
        try {
            result = (Component)support.getTransferable().getTransferData(this.localObjectFlavor);
        }
        catch (UnsupportedFlavorException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean isDropable = false;
        Component targetObject = this.getTarget(support);
        Component sourceObject = this.getSource(support);
        DnDTabbedPane target = null;
        DnDTabbedPane source = null;
        if (targetObject instanceof DnDTabbedPane) {
            target = (DnDTabbedPane)targetObject;
        }
        if (sourceObject instanceof DnDTabbedPane) {
            source = (DnDTabbedPane)sourceObject;
        }
        if (source == null) {
            return false;
        }
        if (source.getRootPane() != target.getRootPane()) {
            return false;
        }
        if (!support.isDrop() || !support.isDataFlavorSupported(this.localObjectFlavor)) {
            return false;
        }
        support.setDropAction(2);
        TransferHandler.DropLocation tdl = support.getDropLocation();
        Point pt = tdl.getDropPoint();
        target.autoScrollTest(pt);
        DnDTabbedPane.DropLocation dl = target.dropLocationForPoint(pt);
        int tabindex = dl.getIndex();
        if (target == source) {
            isDropable = target.getTabAreaBounds().contains(pt) && tabindex >= 0 && tabindex != target.dragTabIndex && tabindex != target.dragTabIndex + 1;
        } else {
            int srcIdx = source.dragTabIndex;
            isDropable = target.getTabAreaBounds().contains(pt) && tabindex >= 0;
        }
        Component c = target.getRootPane().getGlassPane();
        if (c instanceof GhostGlassPane) {
            GhostGlassPane gp = (GhostGlassPane)c;
            gp.setCursor(isDropable ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        }
        if (isDropable) {
            support.setShowDropLocation(true);
            dl.setDropable(true);
            target.setDropLocation(dl, null, true);
            return true;
        }
        support.setShowDropLocation(false);
        dl.setDropable(false);
        target.setDropLocation(dl, null, false);
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        DnDTabbedPane src = (DnDTabbedPane)c;
        if (this.glassPane == null) {
            this.glassPane = new GhostGlassPane(src);
        }
        Rectangle rect = src.getBoundsAt(src.dragTabIndex);
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics g = image.getGraphics();
        c.paint(g);
        if (rect.x < 0) {
            rect.translate(-rect.x, 0);
        }
        if (rect.y < 0) {
            rect.translate(0, -rect.y);
        }
        if (rect.x + rect.width > image.getWidth()) {
            rect.width = image.getWidth() - rect.x;
        }
        if (rect.y + rect.height > image.getHeight()) {
            rect.height = image.getHeight() - rect.y;
        }
        BufferedImage img = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
        this.glassPane.setImage(img);
        c.getRootPane().setGlassPane(this.glassPane);
        this.glassPane.setVisible(true);
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        DnDTabbedPane target = (DnDTabbedPane)this.getTarget(support);
        DnDTabbedPane source = (DnDTabbedPane)this.getSource(support);
        DnDTabbedPane.DropLocation dl = target.getDropLocation();
        int index = dl.getIndex();
        if (target == source) {
            source.convertTab(source.dragTabIndex, index);
        } else {
            source.exportTab(source.dragTabIndex, target, index);
        }
        return true;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        DnDTabbedPane src = (DnDTabbedPane)c;
        c.getRootPane().getGlassPane().setVisible(false);
        src.setDropLocation(null, null, false);
    }
}

