/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.log;

import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class LogWriter {
    public static void config(String path, String level) {
        Properties property = new Properties();
        property.setProperty("log4j.rootCategory", level + ",dolpinAppender");
        property.setProperty("log4j.appender.dolpinAppender", "org.apache.log4j.RollingFileAppender");
        property.setProperty("log4j.appender.dolpinAppender.File", path);
        property.setProperty("log4j.appender.dolpinAppender.MaxFileSize", "1MB");
        property.setProperty("log4j.appender.dolpinAppender.MaxBackupIndex", "20");
        property.setProperty("log4j.appender.dolpinAppender.layout", "org.apache.log4j.PatternLayout");
        property.setProperty("log4j.appender.dolpinAppender.layout.ConversionPattern", "%-4r [%t] %-5p %c - %m%n");
        PropertyConfigurator.configure((Properties)property);
    }

    public static void debug(Class clazz, String text) {
        Logger logger = Logger.getLogger((Class)clazz);
        logger.log((Priority)Level.DEBUG, (Object)text);
    }

    public static void error(Class clazz, String text) {
        Logger.getLogger((Class)clazz).log((Priority)Level.ERROR, (Object)text);
    }

    public static void error(Class clazz, String text, Throwable e) {
        e.printStackTrace();
        Logger.getLogger((Class)clazz).log((Priority)Level.ERROR, (Object)text, e);
    }

    public static void error(Class clazz, Throwable e) {
        e.printStackTrace();
        Logger.getLogger((Class)clazz).log((Priority)Level.ERROR, (Object)"exception ", e);
    }

    public static void fatal(Class clazz, String text) {
        Logger.getLogger((Class)clazz).log((Priority)Level.FATAL, (Object)text);
    }

    public static void fatal(Class clazz, String text, Throwable e) {
        e.printStackTrace();
        Logger.getLogger((Class)clazz).log((Priority)Level.FATAL, (Object)text, e);
    }

    public static void fatal(Class clazz, Throwable e) {
        e.printStackTrace();
        Logger.getLogger((Class)clazz).log((Priority)Level.FATAL, (Object)"exception ", e);
    }

    public static void info(Class clazz, String text) {
        Logger.getLogger((Class)clazz).log((Priority)Level.INFO, (Object)text);
    }

    public static void warn(Class clazz, String text) {
        Logger.getLogger((Class)clazz).log((Priority)Level.WARN, (Object)text);
    }

    public static void debug(String name, String text) {
        Logger.getLogger((String)name).log((Priority)Level.DEBUG, (Object)text);
    }

    public static void error(String name, String text) {
        Logger.getLogger((String)name).log((Priority)Level.ERROR, (Object)text);
    }

    public static void error(String name, String text, Throwable e) {
        Logger.getLogger((String)name).log((Priority)Level.ERROR, (Object)text, e);
    }

    public static void fatal(String name, String text) {
        Logger.getLogger((String)name).log((Priority)Level.FATAL, (Object)text);
    }

    public static void fatal(String name, String text, Throwable e) {
        Logger.getLogger((String)name).log((Priority)Level.FATAL, (Object)text, e);
    }

    public static void info(String name, String text) {
        Logger.getLogger((String)name).log((Priority)Level.INFO, (Object)text);
    }

    public static void warn(String name, String text) {
        Logger.getLogger((String)name).log((Priority)Level.WARN, (Object)text);
    }
}

