/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.util.ArrayList;
import java.util.StringTokenizer;

public final class StringTool {
    private static final char[] komoji = new char[]{'\u3041', '\u3043', '\u3045', '\u3047', '\u3049', '\u3063', '\u3083', '\u3085', '\u3087', '\u308e', '\u30a1', '\u30a3', '\u30a5', '\u30a7', '\u30a9', '\u30c3', '\u30e3', '\u30e5', '\u30e7', '\u30ee'};
    private static final Character[] HIRAGANA = new Character[]{new Character('\u3042'), new Character('\u3093')};
    private static final Character[] KATAKANA = new Character[]{new Character('\u30a2'), new Character('\u30f3')};
    private static final Character[] ZENKAKU_UPPER = new Character[]{new Character('\uff21'), new Character('\uff3a')};
    private static final Character[] ZENKAKU_LOWER = new Character[]{new Character('\uff41'), new Character('\uff5a')};
    private static final Character[] HANKAKU_UPPER = new Character[]{new Character('A'), new Character('Z')};
    private static final Character[] HANKAKU_LOWER = new Character[]{new Character('a'), new Character('z')};

    public static Object[] tokenToArray(String line, String delim) {
        StringTokenizer st = new StringTokenizer(line, delim, true);
        ArrayList<String> list = new ArrayList<String>(10);
        int state = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case 0: {
                    if (token.equals(",")) {
                        token = null;
                    } else {
                        state = 1;
                    }
                    list.add(token);
                    break;
                }
                case 1: {
                    state = 0;
                }
            }
        }
        return list.toArray();
    }

    public static String trimSpace(String text) {
        int end;
        int start;
        char[] chars = text.toCharArray();
        for (start = 0; start < chars.length && (chars[start] == ' ' || chars[start] == '\u3000'); ++start) {
        }
        if (start == chars.length) {
            return null;
        }
        for (end = chars.length - 1; end > start && (chars[end] == ' ' || chars[end] == '\u3000'); --end) {
        }
        return text.substring(start, end + 1);
    }

    public static boolean startsWithKatakana(String s) {
        return StringTool.isKatakana(s.charAt(0));
    }

    public static boolean startsWithHiragana(String s) {
        return StringTool.isHiragana(s.charAt(0));
    }

    public static boolean isKatakana(char c) {
        Character test = new Character(c);
        return test.compareTo(KATAKANA[0]) >= 0 && test.compareTo(KATAKANA[1]) <= 0;
    }

    public static boolean isHiragana(char c) {
        Character test = new Character(c);
        return test.compareTo(HIRAGANA[0]) >= 0 && test.compareTo(HIRAGANA[1]) <= 0;
    }

    private static char toKatakana(char c) {
        return StringTool.isHiragana(c) ? (char)(c + 96) : c;
    }

    public static String hiraganaToKatakana(String s) {
        int len = s.length();
        char[] src = new char[len];
        s.getChars(0, s.length(), src, 0);
        char[] dst = new char[len];
        for (int i = 0; i < len; ++i) {
            dst[i] = StringTool.toKatakana(src[i]);
        }
        return new String(dst);
    }

    public static boolean isAllDigit(String str) {
        boolean ret = true;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean isAllKana(String str) {
        boolean ret = true;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (StringTool.isKatakana(c) || StringTool.isHiragana(c)) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static String toZenkaku(String s) {
        if (s != null) {
            for (int i = 0; i < komoji.length; ++i) {
                s = s.replace(komoji[i], '.');
            }
        }
        return s;
    }

    public static String toKatakana(String text, boolean b) {
        if (b) {
            text = StringTool.toZenkaku(text);
        }
        return StringTool.hiraganaToKatakana(text);
    }

    public static boolean isZenkakuUpper(char c) {
        Character test = new Character(c);
        return test.compareTo(ZENKAKU_UPPER[0]) >= 0 && test.compareTo(ZENKAKU_UPPER[1]) <= 0;
    }

    public static boolean isZenkakuLower(char c) {
        Character test = new Character(c);
        return test.compareTo(ZENKAKU_LOWER[0]) >= 0 && test.compareTo(ZENKAKU_LOWER[1]) <= 0;
    }

    public static boolean isHankakuUpper(char c) {
        Character test = new Character(c);
        return test.compareTo(HANKAKU_UPPER[0]) >= 0 && test.compareTo(HANKAKU_UPPER[1]) <= 0;
    }

    public static boolean isHankakuLower(char c) {
        Character test = new Character(c);
        return test.compareTo(HANKAKU_LOWER[0]) >= 0 && test.compareTo(HANKAKU_LOWER[1]) <= 0;
    }

    public static String toZenkakuUpperLower(String s) {
        int len = s.length();
        char[] src = new char[len];
        s.getChars(0, s.length(), src, 0);
        StringBuilder sb = new StringBuilder();
        for (char c : src) {
            if (StringTool.isHankakuUpper(c) || StringTool.isHankakuLower(c)) {
                sb.append((char)(c + 65248));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isEmptyString(String s) {
        if (s != null) {
            return s.length() == 0;
        }
        return true;
    }

    public static String zenkakuNumToHankaku(String s) {
        char[] cs = s.toCharArray();
        block8: for (int i = 0; i < cs.length; ++i) {
            if (cs[i] >= '\uff10' && cs[i] <= '\uff19') {
                cs[i] = (char)(cs[i] - 65296 + 48);
                continue;
            }
            switch (cs[i]) {
                case '\u3000': {
                    cs[i] = 32;
                    continue block8;
                }
                case '\uff4d': {
                    cs[i] = 109;
                    continue block8;
                }
                case '\uff47': {
                    cs[i] = 103;
                    continue block8;
                }
                case '\uff0e': {
                    cs[i] = 46;
                    continue block8;
                }
                case '\uff0b': {
                    cs[i] = 43;
                    continue block8;
                }
                case '\u30fc': {
                    cs[i] = 45;
                }
            }
        }
        return String.valueOf(cs);
    }
}

