/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.auditlog;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.dcm4che.auditlog.AuditLogger;
import org.dcm4che.auditlog.InstancesAction;
import org.dcm4che.auditlog.MediaDescription;
import org.dcm4che.auditlog.Patient;
import org.dcm4che.auditlog.RemoteNode;
import org.dcm4che.auditlog.User;
import org.dcm4che.data.Dataset;
import org.dcm4che.util.HostNameUtils;
import org.dcm4che.util.SyslogWriter;
import org.dcm4cheri.auditlog.IHEYr4;

class AuditLoggerImpl
implements AuditLogger {
    private final Logger log;
    private final SyslogWriter writer = new SyslogWriter();
    private boolean actorStartStop = true;
    private boolean instancesStored = true;
    private boolean beginStoringInstances = true;
    private boolean instancesSent = true;
    private boolean dicomQuery = true;
    private boolean securityAlert = true;
    private boolean userAuthenticated = true;
    private boolean actorConfig = true;
    private boolean logExport = true;
    private boolean logStudyDeleted = true;
    private boolean logPatientRecord = true;
    private boolean logProcedureRecord = true;
    private boolean strictIHEYr4 = false;

    AuditLoggerImpl(Logger log) {
        this.log = log;
    }

    public void setSyslogHost(String syslogHost) throws UnknownHostException {
        this.writer.setSyslogHost(syslogHost);
    }

    public String getSyslogHost() {
        return this.writer.getSyslogHost();
    }

    public void setSyslogPort(int syslogPort) {
        this.writer.setSyslogPort(syslogPort);
    }

    public int getSyslogPort() {
        return this.writer.getSyslogPort();
    }

    public String getFacility() {
        return this.writer.getFacilityAsString();
    }

    public void setFacility(String facility) {
        this.writer.setFacility(facility);
    }

    public boolean isLogActorStartStop() {
        return this.actorStartStop;
    }

    public void setLogActorStartStop(boolean actorStartStop) {
        this.actorStartStop = actorStartStop;
    }

    public boolean isLogInstancesStored() {
        return this.instancesStored;
    }

    public void setLogInstancesStored(boolean instancesStored) {
        this.instancesStored = instancesStored;
    }

    public boolean isLogBeginStoringInstances() {
        return this.beginStoringInstances;
    }

    public void setLogBeginStoringInstances(boolean beginStoringInstances) {
        this.beginStoringInstances = beginStoringInstances;
    }

    public boolean isLogInstancesSent() {
        return this.instancesSent;
    }

    public void setLogInstancesSent(boolean instancesSent) {
        this.instancesSent = instancesSent;
    }

    public boolean isLogDicomQuery() {
        return this.dicomQuery;
    }

    public void setLogDicomQuery(boolean dicomQuery) {
        this.dicomQuery = dicomQuery;
    }

    public boolean isLogSecurityAlert() {
        return this.securityAlert;
    }

    public void setLogSecurityAlert(boolean securityAlert) {
        this.securityAlert = securityAlert;
    }

    public boolean isLogUserAuthenticated() {
        return this.userAuthenticated;
    }

    public void setLogUserAuthenticated(boolean userAuthenticated) {
        this.userAuthenticated = userAuthenticated;
    }

    public boolean isLogActorConfig() {
        return this.actorConfig;
    }

    public void setLogActorConfig(boolean actorConfig) {
        this.actorConfig = actorConfig;
    }

    public boolean isLogExport() {
        return this.logExport;
    }

    public void setLogExport(boolean logExport) {
        this.logExport = logExport;
    }

    public final boolean isLogPatientRecord() {
        return this.logPatientRecord;
    }

    public final void setLogPatientRecord(boolean logPatientRecord) {
        this.logPatientRecord = logPatientRecord;
    }

    public final boolean isLogProcedureRecord() {
        return this.logProcedureRecord;
    }

    public final void setLogProcedureRecord(boolean logProcedureRecord) {
        this.logProcedureRecord = logProcedureRecord;
    }

    public final boolean isLogStudyDeleted() {
        return this.logStudyDeleted;
    }

    public final void setLogStudyDeleted(boolean logStudyDeleted) {
        this.logStudyDeleted = logStudyDeleted;
    }

    public final boolean isStrictIHEYr4() {
        return this.strictIHEYr4;
    }

    public final void setStrictIHEYr4(boolean strictIHEYr4) {
        this.strictIHEYr4 = strictIHEYr4;
    }

    public void logActorStartStop(String actorName, String action, User user) {
        if (!this.actorStartStop) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newActorStartStop(actorName, action, user, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logInstancesStored(RemoteNode rnode, InstancesAction instanceActionDescription) {
        if (!this.instancesStored) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newInstancesStored(rnode, instanceActionDescription, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logBeginStoringInstances(RemoteNode rnode, InstancesAction instanceActionDescription) {
        if (!this.beginStoringInstances) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newBeginStoringInstances(rnode, instanceActionDescription, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logInstancesSent(RemoteNode rnode, InstancesAction instanceActionDescription) {
        if (!this.instancesSent) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newInstancesSent(rnode, instanceActionDescription, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logDicomQuery(Dataset keys, RemoteNode requestor, String cuid) {
        if (!this.dicomQuery) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newDicomQuery(keys, requestor, cuid, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logSecurityAlert(String alertType, User user, String description) {
        if (!this.securityAlert) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newSecurityAlert(alertType, user, description, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logUserAuthenticated(String localUserName, String action) {
        if (!this.userAuthenticated) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newUserAuthenticated(localUserName, action, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logActorConfig(String description, User user, String configType) {
        if (!this.actorConfig) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newActorConfig(description, user, configType, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logExport(MediaDescription media, User user) {
        if (!this.logExport) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newExport(media, user, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logPatientRecord(String action, Patient patient, User user, String desc) {
        if (!this.logPatientRecord) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newPatientRecord(action, patient, user, this.strictIHEYr4 ? null : desc, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logProcedureRecord(String action, Patient patient, String placerOrderNumber, String fillerOrderNumber, String suid, String accessionNumber, User user, String desc) {
        if (!this.logProcedureRecord) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newProcedureRecord(action, placerOrderNumber, fillerOrderNumber, suid, accessionNumber, patient, user, this.strictIHEYr4 ? null : desc, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }

    public void logStudyDeleted(InstancesAction action, String desc) {
        if (!this.logStudyDeleted) {
            return;
        }
        try {
            long millis = System.currentTimeMillis();
            this.writer.write(6, IHEYr4.newStudyDeleted(action, this.strictIHEYr4 ? null : desc, HostNameUtils.getLocalHostName(), millis).toString(), millis);
        }
        catch (IOException e) {
            this.log.error("Could not write to syslog:", e);
        }
    }
}

