/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.dcm4cheri.hl7.HL7Fields;

class HL7FieldsImpl
implements HL7Fields {
    protected final byte[] data;
    protected final int off;
    protected final int len;
    protected final byte[] delim;
    protected HL7Fields[] subFields = null;
    static final HL7Fields NULL = new HL7Fields(){

        public String toString() {
            return "";
        }

        public String get(int index) {
            return "";
        }

        public int size() {
            return 0;
        }

        public String get(int[] index) {
            return "";
        }

        public int size(int index) {
            return 0;
        }

        public int size(int[] index) {
            return 0;
        }

        public void writeTo(ByteArrayOutputStream out) {
        }

        public void writeTo(int index, ByteArrayOutputStream out) {
        }
    };

    static HL7Fields newInstance(byte[] data, int off, int len, byte[] delim) {
        return len == 0 ? NULL : new HL7FieldsImpl(data, off, len, delim);
    }

    public HL7FieldsImpl(byte[] data, int off, int len, byte[] delim) {
        if (data.length < off + len) {
            throw new IllegalArgumentException("data.length[" + data.length + "] < off[" + off + "] + len [" + len + "]");
        }
        if (delim.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.data = data;
        this.off = off;
        this.len = len;
        this.delim = delim;
    }

    public int size() {
        this.initSubFields();
        return this.subFields.length;
    }

    public int size(int index) {
        if (this.delim.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.initSubFields();
        return index < this.subFields.length ? this.subFields[index].size() : 0;
    }

    public int size(int[] index) {
        if (index.length > this.delim.length) {
            throw new IllegalArgumentException("index.length[" + index.length + "] > delim.length[" + this.delim.length + "]");
        }
        switch (index.length) {
            case 0: {
                return this.size();
            }
            case 1: {
                return this.size(index[0]);
            }
        }
        this.initSubFields();
        if (index[0] >= this.subFields.length) {
            return 0;
        }
        int[] index_1 = new int[index.length - 1];
        System.arraycopy(index, 1, index_1, 0, index_1.length);
        return this.subFields[index[0]].size(index_1);
    }

    public void writeTo(ByteArrayOutputStream out) {
        out.write(this.data, this.off, this.len);
    }

    public void writeTo(int index, ByteArrayOutputStream out) {
        this.initSubFields();
        if (index < this.subFields.length) {
            this.subFields[index].writeTo(out);
        }
    }

    public String toString() {
        try {
            return new String(this.data, this.off, this.len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.data, this.off, this.len);
        }
    }

    public String get(int index) {
        if (this.delim.length == 0) {
            throw new IllegalArgumentException("delim.length == 0");
        }
        this.initSubFields();
        return index < this.subFields.length ? ((Object)this.subFields[index]).toString() : "";
    }

    public String get(int[] index) {
        if (index.length > this.delim.length) {
            throw new IllegalArgumentException("index.length[" + index.length + "] > delim.length[" + this.delim.length + "]");
        }
        switch (index.length) {
            case 0: {
                return this.toString();
            }
            case 1: {
                return this.get(index[0]);
            }
        }
        this.initSubFields();
        if (index[0] >= this.subFields.length) {
            return "";
        }
        int[] index_1 = new int[index.length - 1];
        System.arraycopy(index, 1, index_1, 0, index_1.length);
        return this.subFields[index[0]].get(index_1);
    }

    private void initSubFields() {
        if (this.subFields != null) {
            return;
        }
        int index = 0;
        int n = this.off + this.len;
        for (int i = this.off; i < n; ++i) {
            if (this.data[i] != this.delim[0]) continue;
            ++index;
        }
        this.subFields = new HL7Fields[index + 1];
        byte[] delim_1 = new byte[this.delim.length - 1];
        System.arraycopy(this.delim, 1, delim_1, 0, delim_1.length);
        index = 0;
        int left = this.off;
        int n2 = this.off + this.len;
        for (int i = this.off; i < n2; ++i) {
            if (this.data[i] != this.delim[0]) continue;
            this.subFields[index++] = HL7FieldsImpl.newInstance(this.data, left, i - left, delim_1);
            left = i + 1;
        }
        this.subFields[index] = HL7FieldsImpl.newInstance(this.data, left, this.off + this.len - left, delim_1);
    }
}

