/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dcm4che.hl7.HL7Segment;
import org.dcm4cheri.hl7.HL7FieldsImpl;

public class HL7SegmentImpl
extends HL7FieldsImpl
implements HL7Segment {
    private static final int MIN_LEN = 4;
    private static final byte[] DELIM = new byte[]{124, 126, 94, 38};
    private final String id;
    static final ResourceBundle DICT = ResourceBundle.getBundle("org/dcm4cheri/hl7/HL7Dictionary");

    static String getName(String key, String defVal) {
        try {
            return DICT.getString(key);
        }
        catch (MissingResourceException e) {
            return defVal;
        }
    }

    HL7SegmentImpl(byte[] data, int off, int len) {
        super(data, off, len, DELIM);
        if (len < 4 || data[off + 3] != 124) {
            throw new IllegalArgumentException(this.toString());
        }
        this.id = super.get(0);
    }

    public String id() {
        return this.id;
    }

    public String get(int seq, int rep) {
        return super.get(new int[]{seq, rep - 1});
    }

    public String get(int seq, int rep, int comp) {
        return super.get(new int[]{seq, rep - 1, comp - 1});
    }

    public String get(int seq, int rep, int comp, int sub) {
        return super.get(new int[]{seq, rep - 1, comp - 1, sub - 1});
    }

    public int size(int seq, int rep) {
        return super.size(new int[]{seq, rep - 1});
    }

    public int size(int seq, int rep, int comp) {
        return super.size(new int[]{seq, rep - 1, comp - 1});
    }

    StringBuffer toVerboseStringBuffer(StringBuffer sb) {
        sb.append(this.id).append(" - ").append(HL7SegmentImpl.getName(this.id, ""));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            String key = this.id + '.' + i;
            sb.append("\n\t").append(key).append(": ").append(this.get(i)).append("\t\t//").append(HL7SegmentImpl.getName(key, "????"));
        }
        return sb;
    }

    public String toVerboseString() {
        return this.toVerboseStringBuffer(new StringBuffer()).toString();
    }
}

