/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class DcmHandlerAdapter
implements DcmHandler {
    private static final Attributes EMPTY_ATTR = new AttributesImpl();
    private final ContentHandler handler;
    private final TagDictionary dict;
    private boolean explicitVR;
    private ByteOrder byteOrder;
    private static final int UNDEF = 0;
    private static final int COMMAND = 1;
    private static final int FILEMETAINFO = 2;
    private static final int DATASET = 3;
    private static final int DCMFILE = 4;
    private int docType = 0;
    private int vr;

    public DcmHandlerAdapter(ContentHandler handler, TagDictionary dict) {
        this.handler = handler;
        this.dict = dict;
    }

    public void startCommand() throws IOException {
        this.start(1, "command", EMPTY_ATTR);
    }

    public void endCommand() throws IOException {
        this.end(1, "command");
    }

    public void startFileMetaInfo(byte[] preamble) throws IOException {
        AttributesImpl attrs = new AttributesImpl();
        if (preamble != null) {
            attrs.addAttribute("", "preamble", "preamble", "", StringUtils.promptBytes(preamble, 0, preamble.length));
        }
        this.start(2, "filemetainfo", attrs);
    }

    public void endFileMetaInfo() throws IOException {
        this.end(2, "filemetainfo");
    }

    public void startDataset() throws IOException {
        this.start(3, "dataset", EMPTY_ATTR);
    }

    public void endDataset() throws IOException {
        this.end(3, "dataset");
    }

    public void startDcmFile() throws IOException {
        this.start(4, "dicomfile", EMPTY_ATTR);
    }

    public void endDcmFile() throws IOException {
        this.end(4, "dicomfile");
    }

    private void start(int docType, String xmltag, Attributes attrs) throws IOException {
        try {
            if (this.docType == 0) {
                this.docType = docType;
                this.handler.startDocument();
            }
            this.handler.startElement("", xmltag, xmltag, attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in start " + xmltag).initCause(se);
        }
    }

    private void end(int docType, String xmltag) throws IOException {
        try {
            this.handler.endElement("", xmltag, xmltag);
            if (this.docType == docType) {
                this.handler.endDocument();
                docType = 0;
            }
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in end " + xmltag).initCause(se);
        }
    }

    public void setDcmDecodeParam(DcmDecodeParam param) {
        this.byteOrder = param.byteOrder;
        this.explicitVR = param.explicitVR;
    }

    public void startElement(int tag, int vr, long pos) throws IOException {
        this.vr = vr;
        try {
            TagDictionary.Entry entry;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "tag", "tag", "", Tags.toHexString(tag, 8));
            attrs.addAttribute("", "vr", "vr", "", VRs.toString(vr));
            attrs.addAttribute("", "pos", "pos", "", "" + pos);
            if (this.dict != null && (entry = this.dict.lookup(tag)) != null) {
                attrs.addAttribute("", "name", "name", "", entry.name);
            }
            this.handler.startElement("", "elm", "elm", attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startElement").initCause(se);
        }
    }

    public void startSequence(int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "len", "len", "", "" + length);
            this.handler.startElement("", "seq", "seq", attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startElement").initCause(se);
        }
    }

    public void fragment(int id, long pos, byte[] data, int start, int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", "", "" + id);
            attrs.addAttribute("", "pos", "pos", "", "" + pos);
            attrs.addAttribute("", "len", "len", "", "" + length);
            attrs.addAttribute("", "data", "data", "", StringUtils.promptValue(this.vr, ByteBuffer.wrap(data, start, length).order(this.byteOrder)));
            this.handler.startElement("", "frag", "frag", attrs);
            this.handler.endElement("", "frag", "frag");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in fragment").initCause(se);
        }
    }

    public int vm(byte[] data, int start, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        switch (this.vr) {
            case 19540: 
            case 20290: 
            case 20311: 
            case 21332: 
            case 21838: 
            case 21844: {
                return 1;
            }
            case 21331: 
            case 21843: {
                return length >> 1;
            }
            case 16724: 
            case 17996: 
            case 21324: 
            case 21836: {
                return length >> 2;
            }
            case 17988: {
                return length >> 3;
            }
        }
        int count = 1;
        int i = 0;
        int j = start;
        while (i < length) {
            if (data[j] == 92) {
                ++count;
            }
            ++i;
            ++j;
        }
        return count;
    }

    public void value(byte[] data, int start, int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "vm", "vm", "", "" + this.vm(data, start, length));
            attrs.addAttribute("", "len", "len", "", "" + length);
            attrs.addAttribute("", "data", "data", "", StringUtils.promptValue(this.vr, ByteBuffer.wrap(data, start, length).order(this.byteOrder)));
            this.handler.startElement("", "val", "val", attrs);
            this.handler.endElement("", "val", "val");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in value").initCause(se);
        }
    }

    public void endElement() throws IOException {
        try {
            this.handler.endElement("", "elm", "elm");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in endElement").initCause(se);
        }
    }

    public void endSequence(int length) throws IOException {
        try {
            this.handler.endElement("", "seq", "seq");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in endSequence").initCause(se);
        }
    }

    public void startItem(int id, long pos, int length) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "id", "id", "", "" + id);
            attrs.addAttribute("", "pos", "pos", "", "" + pos);
            attrs.addAttribute("", "len", "len", "", "" + length);
            this.handler.startElement("", "item", "item", attrs);
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in startItem").initCause(se);
        }
    }

    public void endItem(int len) throws IOException {
        try {
            this.handler.endElement("", "item", "item");
        }
        catch (SAXException se) {
            throw (IOException)new IOException("Exception in endItem").initCause(se);
        }
    }
}

