/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

abstract class SCoordContentImpl
extends NamedContentImpl
implements SCoordContent {
    protected final float[] graphicData;

    SCoordContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
        super(owner, obsDateTime, template, name);
        this.graphicData = (float[])graphicData.clone();
    }

    public String toString() {
        StringBuffer sb = this.prompt().append(this.getGraphicType()).append(":[");
        if (this.graphicData.length > 8) {
            sb.append("N=").append(this.graphicData.length);
        } else {
            sb.append(this.graphicData[0]);
            for (int i = 1; i < this.graphicData.length; ++i) {
                sb.append(',').append(this.graphicData[i]);
            }
        }
        return sb.append("]").toString();
    }

    public Content.ValueType getValueType() {
        return Content.ValueType.SCOORD;
    }

    public float[] getGraphicData() {
        return (float[])this.graphicData.clone();
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putCS(7340067, this.getGraphicType());
        ds.putFL(0x700022, this.graphicData);
    }

    static class Ellipse
    extends SCoordContentImpl
    implements SCoordContent.Ellipse {
        Ellipse(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
            super(owner, obsDateTime, template, name, graphicData);
            if (graphicData.length != 8) {
                throw new IllegalArgumentException("float[" + graphicData.length + "]");
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Ellipse(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "ELLIPSE";
        }
    }

    static class Circle
    extends SCoordContentImpl
    implements SCoordContent.Circle {
        Circle(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
            super(owner, obsDateTime, template, name, graphicData);
            if (graphicData.length != 4) {
                throw new IllegalArgumentException("float[" + graphicData.length + "]");
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Circle(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "CIRCLE";
        }
    }

    static class Polyline
    extends SCoordContentImpl
    implements SCoordContent.Polyline {
        Polyline(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
            super(owner, obsDateTime, template, name, graphicData);
            if ((graphicData.length & 1) != 0) {
                throw new IllegalArgumentException("float[" + graphicData.length + "]");
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Polyline(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "POLYLINE";
        }
    }

    static class MultiPoint
    extends SCoordContentImpl
    implements SCoordContent.MultiPoint {
        MultiPoint(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
            super(owner, obsDateTime, template, name, graphicData);
            if ((graphicData.length & 1) != 0) {
                throw new IllegalArgumentException("float[" + graphicData.length + "]");
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new MultiPoint(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "MULTIPOINT";
        }
    }

    static class Point
    extends SCoordContentImpl
    implements SCoordContent.Point {
        Point(KeyObject owner, Date obsDateTime, Template template, Code name, float[] graphicData) {
            super(owner, obsDateTime, template, name, graphicData);
            if (graphicData.length != 2) {
                throw new IllegalArgumentException("float[" + graphicData.length + "]");
            }
        }

        Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
            return new Point(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.graphicData);
        }

        public String getGraphicType() {
            return "POINT";
        }
    }
}

