/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.RoleSelection;
import org.dcm4cheri.net.AAbortImpl;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class RoleSelectionImpl
implements RoleSelection {
    private final String asuid;
    private final boolean scu;
    private final boolean scp;

    RoleSelectionImpl(String asuid, boolean scu, boolean scp) {
        this.asuid = asuid;
        this.scu = scu;
        this.scp = scp;
    }

    RoleSelectionImpl(DataInputStream din, int len) throws IOException, PDUException {
        int uidLen = din.readUnsignedShort();
        if (uidLen + 4 != len) {
            throw new PDUException("SCP/SCU role selection sub-item length: " + len + " mismatch UID-length:" + uidLen, new AAbortImpl(2, 6));
        }
        this.asuid = AAssociateRQACImpl.readASCII(din, uidLen);
        this.scu = din.readBoolean();
        this.scp = din.readBoolean();
    }

    public final String getSOPClassUID() {
        return this.asuid;
    }

    public final boolean scu() {
        return this.scu;
    }

    public final boolean scp() {
        return this.scp;
    }

    final int length() {
        return 4 + this.asuid.length();
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(84);
        dout.write(0);
        dout.writeShort(this.length());
        dout.writeShort(this.asuid.length());
        dout.writeBytes(this.asuid);
        dout.writeBoolean(this.scu);
        dout.writeBoolean(this.scp);
    }

    public String toString() {
        return "RoleSelection[sop=" + AAssociateRQACImpl.DICT.lookup(this.asuid) + ", scu=" + this.scu + ", scp=" + this.scp + "]";
    }
}

