/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DocumentBridgeImpl.java
 *
 * Created on 2010/03/09, 11:45:37
 */
package open.dolphin.client;

import open.dolphin.project.GlobalConstants;
import open.dolphin.client.karte.DocumentHistoryPanel;
import java.awt.BorderLayout;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import open.dolphin.project.GlobalSettings;
import open.dolphin.infomodel.DocInfoModel;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.project.GlobalVariables;

/**
 * 　MEMO:画面　リスナー
 * @author
 */
public class DocumentBridgeImpl extends JPanel implements PropertyChangeListener, IChartDocument {

    /**
     *
     */
    public static final String TITLE = "参 照";
    // 文書表示クラスのインターフェイス
    private IDocumentViewer curViwer;
    //元々はAbstractChartDocumentから継承
    private static final String[] CHART_MENUS = {
        GUIConst.ACTION_OPEN_KARTE, GUIConst.ACTION_SAVE, GUIConst.ACTION_DIRECTION, GUIConst.ACTION_DELETE, GUIConst.ACTION_PRINT, GUIConst.ACTION_MODIFY_KARTE,
        GUIConst.ACTION_ASCENDING, GUIConst.ACTION_DESCENDING, GUIConst.ACTION_SHOW_MODIFIED, GUIConst.ACTION_SHOW_UNSEND, GUIConst.ACTION_SHOW_SEND, GUIConst.ACTION_SHOW_NEWEST,
        GUIConst.ACTION_INSERT_TEXT, GUIConst.ACTION_INSERT_SCHEMA, GUIConst.ACTION_INSERT_STAMP, GUIConst.ACTION_SELECT_INSURANCE,
        GUIConst.ACTION_CUT, GUIConst.ACTION_COPY, GUIConst.ACTION_PASTE, GUIConst.ACTION_UNDO, GUIConst.ACTION_REDO
    };
    private IChart parent;
    private String title;
    private boolean dirty;

    /**
     * Creates new form DocumentBridgeImpl
     * @param parent
     */
    public DocumentBridgeImpl(IChart parent) {
        this.title = TITLE;
        this.parent = parent;
        initComponents();
    }

    /**
     *
     * @return
     */
    @Override
    public TYPE getType() {
        return TYPE.DocumentBridgeImpl;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scroller = new javax.swing.JScrollPane();

        scroller.setName("scroller"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane scroller;
    // End of variables declaration//GEN-END:variables

    /**
     *
     */
    @Override
    public void start() {
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        setLayout(new BorderLayout());
        add(scroller, BorderLayout.CENTER);
        scroller.getVerticalScrollBar().setUnitIncrement(GlobalSettings.karteScrollUnitIncrement());
        // 文書履歴のプロパティ通知をリッスンする
        DocumentHistoryPanel historyPanel = parent.getDocumentHistory();
        historyPanel.addPropertyChangeListener(DocumentHistoryPanel.DOCUMENT_TYPE, this);
        historyPanel.addPropertyChangeListener(DocumentHistoryPanel.HITORY_UPDATED, this);
        historyPanel.addPropertyChangeListener(DocumentHistoryPanel.SELECTED_HISTORIES, this);
        curViwer = new KarteDocumentViewer(parent);
        curViwer.start();
        enter();
    }

    /**
     *
     */
    @Override
    public void stop() {
        if (curViwer != null) {
            curViwer.stop();
        }
    }

    /**
     * 
     */
    @Override
    public void enter() {
        if (curViwer != null) {
            // これによりメニューは viwer で制御される
            curViwer.enter();
        } else {
            parent.getStatusPanel().setMessage("");
            parent.getChartMediator().setAccepter(this);
            disableMenus();

            parent.enabledAction(GUIConst.ACTION_NEW_KARTE, true);
            parent.enabledAction(GUIConst.ACTION_NEW_DOCUMENT, true);
            parent.enabledAction(GUIConst.ACTION_ADD_USER, GlobalVariables.isAdmin());
        }
    }

    /**
     * Bridge 機能を提供する。選択された文書のタイプに応じてビューへブリッジする。
     * @param docs 表示する文書の DocInfo 配列
     */
    private void showDocuments(DocInfoModel[] docs) {
        if (docs == null || docs.length == 0) {
            return;
        }
        if (curViwer != null) {
            curViwer.showDocuments(docs, scroller);
            ((ChartWindow) parent).showDocument(this);
        }
    }

    /**
     * ドキュメントの表示
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ChartMediator med = parent.getChartMediator();
        med.setCurKarteComposit(null);
        String prop = evt.getPropertyName();
        if (prop.equals(DocumentHistoryPanel.DOCUMENT_TYPE)) {
            String docType = (String) evt.getNewValue();
            if (docType.equals(IInfoModel.DOCTYPE_LETTER)) {
                curViwer = new LetterViewer(parent);
            } else if (docType.equals(IInfoModel.DOCTYPE_LETTER_REPLY)) {
                curViwer = new LetterReplyViewer(parent);
            } else {
                curViwer = new KarteDocumentViewer(parent);
            }
            curViwer.start();
            return;
        }

        if (prop.equals(DocumentHistoryPanel.HITORY_UPDATED)) {
            // 文書履歴の抽出期間が変更された場合
            if (curViwer != null) {
                curViwer.historyPeriodChanged();
            }
            this.scroller.setViewportView(null);
            return;
        }

        if (prop.equals(DocumentHistoryPanel.SELECTED_HISTORIES)) {

            if (evt.getOldValue() != null) //ヒストリの初期化イベントをAvoid。
            {
                // 文書履歴の選択が変更された場合
                DocInfoModel[] selectedHistoroes = (DocInfoModel[]) evt.getNewValue();
                this.showDocuments(selectedHistoroes);
            }
            return;
        }
    }

    /**
     *
     * @return
     */
    public KarteDocumentViewer getCurrentViewer() {
        return (KarteDocumentViewer) curViwer;
    }

    /**
     *
     * @return
     */
    public IKarteViewer getBaseKarte() {
        if (curViwer != null && curViwer instanceof KarteDocumentViewer) {
            return ((KarteDocumentViewer) curViwer).getBaseKarte();
        }
        return null;
    }

    /**
     *
     * @return　レイアウト保存すべきか
     */
    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    /**
     *　元々はAbstractChartDocumentから継承
     * @return　タイトル
     */
    @Override
    public String getTitle() {
        return title;
    }

    /**
     *
     * @return
     */
    @Override
    public IChart getParentContext() {
        return parent;
    }

    /**
     *　MEMO:何もしない
     * @return　準備完了？
     */
    @Override
    public boolean prepare() {
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isDirty() {
        return dirty;
    }

    /**
     *
     * @param dirty
     */
    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /**
     *
     * @return
     */
    public boolean isReadOnly() {
        return parent.isReadOnly();
    }

    /**
     * 
     */
    public void disableMenus() {
        // このウインドウに関連する全てのメニューをdisableにする
        ChartMediator mediator = parent.getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    /**
     * 共通の警告表示を行う。
     * @param title
     * @param message
     */
    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), JOptionPane.WARNING_MESSAGE);
    }

    /**
     *　MEMO:何もしない
     * @param command
     * @return
     */
    @Override
    public boolean dispatchChartCommand(ChartCommand command) {
        return false;
    }

    /**
     *　MEMO:何もしない
     * @return
     */
    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    /**
     *　MEMO:何もしない
     * @param o
     * @return
     */
    @Override
    public boolean update(Object o) {
        return true;
    }
}
