/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SettingDialog.java
 *
 * Created on 2010/11/20, 16:33:00
 */
package open.dolphin.client.settings;

import java.awt.Component;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.client.settings.IAbstractSettingPanel.State;

import open.dolphin.helper.PlugInMenuSupport;
import open.dolphin.plugin.PluginWrapper;
import open.dolphin.utils.Adapter;

/**
*　設定画面　MEMO:画面　リスナー
 * @author
 */
public class SettingDialog extends javax.swing.JDialog implements PropertyChangeListener {

    private boolean loginState;
    //   private static final String SETTING_PROP = "SETTING_PROP";
    private PlugInMenuSupport plugins;
    private List<IAbstractSettingPanel> panels;

    /** Creates new form SettingDialog
     * @param parent 
     * @param plugins
     * @param modal
     */
    public SettingDialog(java.awt.Frame parent, boolean modal, PlugInMenuSupport plugins) {
        super(parent, modal);
        initComponents();
        this.plugins = plugins;
        panels = new ArrayList<IAbstractSettingPanel>();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("設定");
        setResizable(false);

        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        jPanel1.setName("jPanel1"); // NOI18N

        okButton.setText("OK");
        okButton.setName("okButton"); // NOI18N
        okButton.setRequestFocusEnabled(false);
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("jButton1");
        cancelButton.setName("cancelButton"); // NOI18N
        cancelButton.setRequestFocusEnabled(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(255, Short.MAX_VALUE)
                .addComponent(okButton)
                .addGap(64, 64, 64)
                .addComponent(cancelButton)
                .addGap(220, 220, 220))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cancelButton))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 725, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 626, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        // TODO add your handling code here:

        for (IAbstractSettingPanel panel : panels) {
            panel.save();
        }

    }//GEN-LAST:event_okButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JButton okButton;
    // End of variables declaration//GEN-END:variables

    /**
     *
     * @param prop
     * @param l
     */
    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    /**
     *
     * @param prop
     * @param l
     */
    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
    }

    /**
     *
     * @return
     */
    public boolean getLoginState() {
        return loginState;
    }

    /**
     *
     * @param b
     */
    public void setLoginState(boolean b) {
        loginState = b;
    }

    /**
     * 設定画面を開始する。
     */
    public void start() {
        addPanel(new HostSettingPanel());
        addPanel(new ClaimSettingPanel());
        addPanel(new AreaNetWorkSettingPanel());
        addPanel(new SendMmlSettingPanel());
        addPanel(new KarteSettingPanel());
        addPanel(new CodeHelperSettingPanel());
        addPanel(new BrowserSettingPanel());
        addPanel(new PluginsSettingPanel());
        addPanel(new DirectionSettingPanel());

        for (open.dolphin.plugin.IPlugin plugin : plugins.values()) {
            PluginWrapper pluginWrapper = new PluginWrapper(plugin);
            IAbstractSettingPanel panel = pluginWrapper.configure();
            if (panel != null) {
                addPanel(panel);
            }
        }

        CallBackEnable();
    }

    /**
     *
     * @param panel
     */
    private void addPanel(IAbstractSettingPanel panel) {
        panel.start();
        panels.add(panel);
        jTabbedPane1.add(panel.getTitle(), (Component) panel);
    }

    /**
     * コンポーネントへの初期値の設定を無視するため、CallBackのお設定のみ別フェーズ
     */
    private void CallBackEnable() {

        for (IAbstractSettingPanel panel : panels) {
            panel.onChenge(new Adapter<Boolean, Boolean>() {

                @Override
                public Boolean onResult(Boolean input) throws Exception {
                    return true;
                }
            });
        }
    }

    /**
     *  MEMO: unused?
     */
    private void CallBackDisable() {

        for (IAbstractSettingPanel panel : panels) {
            panel.onChenge(new Adapter<Boolean, Boolean>() {

                @Override
                public Boolean onResult(Boolean input) throws Exception {
                    return true;
                }
            });
        }
    }

    /**
     * SettingPanel の state が変化した場合に通知を受け、
     * 全てのカードをスキャンして OK ボタンをコントロールする。
     * @param e
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean enabled = true;
        for (IAbstractSettingPanel panel : panels) {
            if (panel.getState() == State.INVALID_STATE) {
                enabled = false;
                break;
            }
        }
        okButton.setEnabled(enabled);
    }
}
