/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.imageioimpl.plugins.rle;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class RLEImageReader
extends ImageReader {
    private int[] header = new int[16];
    private byte[] buf = new byte[8192];
    private long headerPos;
    private long bufOff;
    private int bufPos;
    private int bufLen;
    private ImageInputStream iis;

    public RLEImageReader(ImageReaderSpi originator) {
        super(originator);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (ImageInputStream)input;
    }

    public int getHeight(int imageIndex) throws IOException {
        return 1;
    }

    public int getWidth(int imageIndex) throws IOException {
        return 1;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("Input not set");
        }
        BufferedImage bi = RLEImageReader.getDestination(param);
        this.readRLEHeader();
        int nSegs = this.header[0];
        this.checkDestination(nSegs, bi);
        WritableRaster raster = bi.getRaster();
        DataBuffer db = raster.getDataBuffer();
        if (db instanceof DataBufferByte) {
            DataBufferByte dbb = (DataBufferByte)db;
            byte[][] bankData = dbb.getBankData();
            ComponentSampleModel sm = (ComponentSampleModel)bi.getSampleModel();
            int[] bankIndices = sm.getBankIndices();
            int[] bandOffsets = sm.getBandOffsets();
            int pixelStride = sm.getPixelStride();
            for (int i = 0; i < nSegs; ++i) {
                this.seekSegment(i + 1);
                this.unrle(bankData[bankIndices[i]], bandOffsets[i], pixelStride);
            }
        } else {
            short[] ss = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
            this.unrle(ss);
            this.seekSegment(2);
            this.unrle(ss);
        }
        this.seekInputToEndOfRLEData();
        return bi;
    }

    private static BufferedImage getDestination(ImageReadParam param) {
        BufferedImage bi;
        if (param == null || (bi = param.getDestination()) == null) {
            throw new IllegalArgumentException("RLE Image Reader needs set ImageReadParam.destination");
        }
        SampleModel sm = bi.getSampleModel();
        if (!(sm instanceof ComponentSampleModel)) {
            throw new IllegalArgumentException("Unsupported Destination Sample Model: " + sm);
        }
        return bi;
    }

    private void readRLEHeader() throws IOException {
        this.headerPos = this.iis.getStreamPosition();
        this.fillBuffer();
        if (this.bufLen < 64) {
            throw new EOFException();
        }
        int i = 0;
        while (i < 16) {
            this.header[i] = this.buf[this.bufPos] & 0xFF | (this.buf[this.bufPos + 1] & 0xFF) << 8 | (this.buf[this.bufPos + 2] & 0xFF) << 16 | (this.buf[this.bufPos + 3] & 0xFF) << 24;
            ++i;
            this.bufPos += 4;
        }
    }

    private void seekSegment(int seg) throws IOException {
        long segPos = this.headerPos + (long)this.header[seg];
        if (segPos < this.bufOff) {
            this.iis.seek(segPos);
            this.fillBuffer();
        } else {
            while (segPos - this.bufOff >= (long)this.bufLen) {
                this.fillBuffer();
            }
            this.bufPos = (int)(segPos - this.bufOff);
        }
    }

    private void seekInputToEndOfRLEData() throws IOException {
        this.iis.seek(this.bufOff + (long)this.bufPos);
    }

    private byte nextByte() throws IOException {
        if (this.bufPos == this.bufLen) {
            this.fillBuffer();
        }
        return this.buf[this.bufPos++];
    }

    private void nextBytes(byte[] bs, int off, int len) throws IOException {
        int read;
        for (int pos = 0; pos < len; pos += read) {
            if (this.bufPos == this.bufLen) {
                this.fillBuffer();
            }
            read = Math.min(len - pos, this.bufLen - this.bufPos);
            System.arraycopy(this.buf, this.bufPos, bs, off + pos, read);
            this.bufPos += read;
        }
    }

    private void fillBuffer() throws IOException {
        this.bufOff = this.iis.getStreamPosition();
        this.bufPos = 0;
        this.bufLen = this.iis.read(this.buf);
        if (this.bufLen <= 0) {
            throw new EOFException();
        }
    }

    private void checkDestination(int nSegs, BufferedImage bi) throws IIOException {
        WritableRaster raster = bi.getRaster();
        int nBands = raster.getNumBands();
        int dataType = raster.getTransferType();
        if (nSegs == 1 || nSegs == 3) {
            if (nBands == nSegs && dataType == 0) {
                return;
            }
        } else if (nSegs == 2) {
            if (nBands == 1 && (dataType == 1 || dataType == 2)) {
                return;
            }
        } else {
            throw new IIOException("Unsupported Number of RLE Segments: " + ((long)nSegs & 0xFFFFFFFFL));
        }
        throw new IIOException("Number of RLE Segments: " + nSegs + " incompatible with Destination[bands=" + nBands + ", data=" + raster.getDataBuffer() + "]");
    }

    private void unrle(byte[] bs, int off, int pixelStride) throws IOException {
        if (pixelStride == 1) {
            this.unrle(bs);
            return;
        }
        int pos = off;
        while (pos < bs.length) {
            int i;
            int l;
            byte b = this.nextByte();
            if (b >= 0) {
                l = b + 1;
                i = 0;
                while (i < l) {
                    bs[pos] = this.nextByte();
                    ++i;
                    pos += pixelStride;
                }
                continue;
            }
            if (b == -128) continue;
            l = -b + 1;
            b = this.nextByte();
            i = 0;
            while (i < l) {
                bs[pos] = b;
                ++i;
                pos += pixelStride;
            }
        }
    }

    private void unrle(byte[] bs) throws IOException {
        int pos = 0;
        while (pos < bs.length) {
            int l;
            byte b = this.nextByte();
            if (b >= 0) {
                l = b + 1;
                this.nextBytes(bs, pos, l);
                pos += l;
                continue;
            }
            if (b == -128) continue;
            l = -b + 1;
            b = this.nextByte();
            Arrays.fill(bs, pos, pos + l, b);
            pos += l;
        }
    }

    private void unrle(short[] ss) throws IOException {
        int pos = 0;
        while (pos < ss.length) {
            int i;
            int l;
            byte b = this.nextByte();
            if (b >= 0) {
                l = b + 1;
                for (i = 0; i < l; ++i) {
                    int n = pos;
                    ss[n] = (short)(ss[n] << 8);
                    int n2 = pos++;
                    ss[n2] = (short)(ss[n2] | this.nextByte() & 0xFF);
                }
                continue;
            }
            if (b == -128) continue;
            l = -b + 1;
            int v = this.nextByte() & 0xFF;
            for (i = 0; i < l; ++i) {
                int n = pos;
                ss[n] = (short)(ss[n] << 8);
                int n3 = pos++;
                ss[n3] = (short)(ss[n3] | v);
            }
        }
    }
}

