/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.client;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.dcm4che.client.AssociationRequestor;
import org.dcm4che.client.PrintSCUDataSource;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.AssociationFactory;
import org.dcm4che.net.DcmServiceBase;
import org.dcm4che.net.DcmServiceException;
import org.dcm4che.net.Dimse;
import org.dcm4che.util.UIDGenerator;

public class PrintSCU {
    static final AssociationFactory assocFact = AssociationFactory.getInstance();
    static final DcmObjectFactory dcmFact = DcmObjectFactory.getInstance();
    static final String[] TS_NO_EXPLICIT_VR = new String[]{"1.2.840.10008.1.2"};
    static final String[] TS_EXPLICIT_VR = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    static final UIDGenerator UID_GEN = UIDGenerator.getInstance();
    private final AssociationRequestor requestor;
    private final PropertyChangeListener closeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PrintSCU.this.requestor.removePropertyChangeListener("Connected", this);
            PrintSCU.this.curFilmSessionIUID = null;
            PrintSCU.this.curFilmBoxIUID = null;
            PrintSCU.this.curPLUT_IUID = null;
            PrintSCU.this.curFilmBox = null;
            PrintSCU.this.curPrinterInfo = null;
            PrintSCU.this.printerInfoTimestamp = 0L;
        }
    };
    public static final String NORMAL = "NORMAL";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    private static final String[] EVENT_TYPE_TO_STATUS = new String[]{"NORMAL", "WARNING", "ERROR"};
    private final DcmServiceBase printerSOP = new DcmServiceBase(){

        protected Dataset doNEventReport(ActiveAssociation assoc, Dimse rq, Command rspCmd) throws IOException, DcmServiceException {
            Command cmd = rq.getCommand();
            Dataset ds = rq.getDataset();
            int eventTypeID = cmd.getInt(4098, 0);
            this.checkNEventReport(eventTypeID, ds);
            if (PrintSCU.this.curPrinterInfo == null) {
                PrintSCU.this.curPrinterInfo = dcmFact.newDataset();
            }
            PrintSCU.this.curPrinterInfo.putCS(0x21100010, EVENT_TYPE_TO_STATUS[eventTypeID - 1]);
            PrintSCU.this.curPrinterInfo.putCS(0x21100020, eventTypeID == 1 ? PrintSCU.NORMAL : ds.getString(0x21100020));
            PrintSCU.this.printerInfoTimestamp = System.currentTimeMillis();
            return null;
        }

        private void checkNEventReport(int eventTypeID, Dataset ds) throws DcmServiceException {
            switch (eventTypeID) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    if (ds == null) {
                        throw new DcmServiceException(277, "Missing Event Information in N-EVENT-REPORT-RQ");
                    }
                    String statusInfo = ds.getString(0x21100020);
                    if (statusInfo != null) break;
                    throw new DcmServiceException(277, "Missing Printer Status Info in N-EVENT-REPORT-RQ");
                }
                default: {
                    throw new DcmServiceException(275, "Invalid Event Type ID: " + eventTypeID);
                }
            }
        }
    };
    private boolean negotiateColorPrint = true;
    private boolean negotiateGrayscalePrint = true;
    private boolean negotiatePLUT = true;
    private boolean negotiateAnnotation = true;
    private String[] tsuids = TS_EXPLICIT_VR;
    private boolean createRQwithIUID = false;
    private boolean autoRefPLUT = true;
    private int[] infoAttrList = null;
    private int maxPrinterInfoStale = 5000;
    private long printerInfoTimestamp = 0L;
    private int pcidColorPrint = 0;
    private int pcidGrayscalePrint = 0;
    private int pcidPLUT = 0;
    private int pcidAnnotation = 0;
    private int pcidPrint = 0;
    private String curFilmSessionIUID;
    private String curFilmBoxIUID;
    private String curPLUT_IUID;
    private Dataset curFilmBox;
    private Dataset curPrinterInfo;
    private byte[] buffer = new byte[4096];
    private static int[] NO_ERROR_STATI = new int[]{0, 278, 46597, 45056};

    public PrintSCU(AssociationRequestor requestor) {
        this.requestor = requestor;
        this.requestor.bindService("1.2.840.10008.5.1.1.16", this.printerSOP);
        this.updatePresContexts();
    }

    private void updatePresContexts() {
        this.updateGrayscalePrintPresContext();
        this.updateColorPrintPresContext();
        this.updatePLUTPresContext();
        this.updateAnnotationPresContext();
    }

    private void updateGrayscalePrintPresContext() {
        if (this.negotiateGrayscalePrint) {
            if (this.pcidGrayscalePrint == 0) {
                this.pcidGrayscalePrint = this.requestor.addPresContext("1.2.840.10008.5.1.1.9", this.tsuids);
            }
        } else if (this.pcidGrayscalePrint != 0) {
            this.requestor.removePresContext(this.pcidGrayscalePrint);
            this.pcidGrayscalePrint = 0;
        }
    }

    private void updateColorPrintPresContext() {
        if (this.negotiateColorPrint) {
            if (this.pcidColorPrint == 0) {
                this.pcidColorPrint = this.requestor.addPresContext("1.2.840.10008.5.1.1.18", this.tsuids);
            }
        } else if (this.pcidColorPrint != 0) {
            this.requestor.removePresContext(this.pcidColorPrint);
            this.pcidColorPrint = 0;
        }
    }

    private void updatePLUTPresContext() {
        if (this.negotiatePLUT) {
            if (this.pcidPLUT == 0) {
                this.pcidPLUT = this.requestor.addPresContext("1.2.840.10008.5.1.1.23", this.tsuids);
            }
        } else if (this.pcidPLUT != 0) {
            this.requestor.removePresContext(this.pcidPLUT);
            this.pcidPLUT = 0;
        }
    }

    private void updateAnnotationPresContext() {
        if (this.negotiateAnnotation) {
            if (this.pcidAnnotation == 0) {
                this.pcidAnnotation = this.requestor.addPresContext("1.2.840.10008.5.1.1.15", this.tsuids);
            }
        } else if (this.pcidAnnotation != 0) {
            this.requestor.removePresContext(this.pcidAnnotation);
            this.pcidAnnotation = 0;
        }
    }

    public boolean isNegotiateGrayscalePrint() {
        return this.negotiateGrayscalePrint;
    }

    public void setNegotiateGrayscalePrint(boolean negotiateGrayscalePrint) {
        this.negotiateGrayscalePrint = negotiateGrayscalePrint;
        this.updateGrayscalePrintPresContext();
    }

    public boolean isNegotiateColorPrint() {
        return this.negotiateColorPrint;
    }

    public void setNegotiateColorPrint(boolean negotiateColorPrint) {
        this.negotiateColorPrint = negotiateColorPrint;
        this.updateColorPrintPresContext();
    }

    public boolean isNegotiatePLUT() {
        return this.negotiatePLUT;
    }

    public void setNegotiatePLUT(boolean negotiatePLUT) {
        this.negotiatePLUT = negotiatePLUT;
        this.updatePLUTPresContext();
    }

    public boolean isNegotiateAnnotation() {
        return this.negotiateAnnotation;
    }

    public void setNegotiateAnnotation(boolean negotiateAnnotation) {
        this.negotiateAnnotation = negotiateAnnotation;
        this.updateAnnotationPresContext();
    }

    public boolean isCreateRQwithIUID() {
        return this.createRQwithIUID;
    }

    public void setCreateRQwithIUID(boolean createRQwithIUID) {
        this.createRQwithIUID = createRQwithIUID;
    }

    public boolean isAutoRefPLUT() {
        return this.autoRefPLUT;
    }

    public void setAutoRefPLUT(boolean autoRefPLUT) {
        this.autoRefPLUT = autoRefPLUT;
    }

    public AssociationRequestor getRequestor() {
        return this.requestor;
    }

    public boolean isNegotiateExplicitVR() {
        return this.tsuids == TS_EXPLICIT_VR;
    }

    public void setNegotiateExplicitVR(boolean negotiateExplicitVR) {
        if (this.isNegotiateExplicitVR() == negotiateExplicitVR) {
            return;
        }
        this.tsuids = negotiateExplicitVR ? TS_EXPLICIT_VR : TS_NO_EXPLICIT_VR;
        this.removePresContexts();
        this.updatePresContexts();
    }

    private void removePresContexts() {
        if (this.pcidColorPrint != 0) {
            this.requestor.removePresContext(this.pcidColorPrint);
            this.pcidColorPrint = 0;
        }
        if (this.pcidGrayscalePrint != 0) {
            this.requestor.removePresContext(this.pcidGrayscalePrint);
            this.pcidGrayscalePrint = 0;
        }
        if (this.pcidPLUT != 0) {
            this.requestor.removePresContext(this.pcidPLUT);
            this.pcidPLUT = 0;
        }
        if (this.pcidAnnotation != 0) {
            this.requestor.removePresContext(this.pcidAnnotation);
            this.pcidAnnotation = 0;
        }
    }

    public boolean isGrayscalePrintEnabled() {
        return this.isEnabled(this.pcidGrayscalePrint);
    }

    private boolean isEnabled(int pcid) {
        return pcid != 0 && this.requestor.isConnected() && this.requestor.getAcceptedTransferSyntaxUID(pcid) != null;
    }

    public boolean isColorPrintEnabled() {
        return this.isEnabled(this.pcidColorPrint);
    }

    public boolean isPLUTEnabled() {
        return this.isEnabled(this.pcidPLUT);
    }

    public boolean isAnnotationEnabled() {
        return this.isEnabled(this.pcidAnnotation);
    }

    private static int[] clone(int[] a) {
        return a != null ? (int[])a.clone() : null;
    }

    public int[] getInfoAttrList() {
        return PrintSCU.clone(this.infoAttrList);
    }

    public void setInfoAttrList(int[] infoAttrList) {
        this.infoAttrList = PrintSCU.clone(infoAttrList);
    }

    public int getMaxPrinterInfoStale() {
        return this.maxPrinterInfoStale;
    }

    public void setMaxPrinterInfoStale(int maxPrinterInfoStale) {
        this.maxPrinterInfoStale = maxPrinterInfoStale;
    }

    public Dataset getPrinterInfo(boolean forceQuery) throws InterruptedException, IOException, DcmServiceException {
        if (forceQuery || this.curPrinterInfo == null || System.currentTimeMillis() - this.printerInfoTimestamp > (long)this.maxPrinterInfoStale) {
            this.queryPrinterInfo();
        }
        return this.curPrinterInfo;
    }

    public String getPrinterStatus() throws InterruptedException, IOException, DcmServiceException {
        return this.getPrinterInfo(false).getString(0x21100010);
    }

    public String getPrinterStatusInfo() throws InterruptedException, IOException, DcmServiceException {
        return this.getPrinterInfo(false).getString(0x21100010);
    }

    private int checkStatus(Command rsp) throws DcmServiceException {
        int status = rsp.getStatus();
        for (int i = 0; i < NO_ERROR_STATI.length; ++i) {
            if (status != NO_ERROR_STATI[i]) continue;
            return status;
        }
        throw new DcmServiceException(status, rsp.getString(2306));
    }

    private int queryPrinterInfo() throws InterruptedException, IOException, DcmServiceException {
        this.checkAssociation();
        int msgid = this.requestor.nextMsgID();
        Command nGetRQ = dcmFact.newCommand();
        nGetRQ.initNGetRQ(msgid, "1.2.840.10008.5.1.1.16", "1.2.840.10008.5.1.1.17", this.infoAttrList);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nGetRQ);
        int status = this.checkStatus(rsp.getCommand());
        this.curPrinterInfo = rsp.getDataset();
        if (this.curPrinterInfo == null) {
            throw new DcmServiceException(-1, "Missing Attribute List in N-GET-RSP");
        }
        this.printerInfoTimestamp = System.currentTimeMillis();
        return status;
    }

    public String createPLUT(Dataset attr) throws InterruptedException, IOException, DcmServiceException {
        this.checkAssociation();
        String iuid = this.createRQwithIUID ? UID_GEN.createUID() : null;
        int msgid = this.requestor.nextMsgID();
        Command nCreateRQ = dcmFact.newCommand();
        nCreateRQ.initNCreateRQ(msgid, "1.2.840.10008.5.1.1.23", iuid);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPLUT, nCreateRQ, attr);
        Command nCreateRSP = rsp.getCommand();
        int status = this.checkStatus(nCreateRSP);
        this.curPLUT_IUID = this.checkIUID(iuid, nCreateRSP);
        return this.curPLUT_IUID;
    }

    public String createPLUT(String shape) throws InterruptedException, IOException, DcmServiceException {
        Dataset plut = dcmFact.newDataset();
        plut.putCS(0x20500020, shape);
        return this.createPLUT(plut);
    }

    public int deletePLUT(String iuid) throws InterruptedException, IOException, DcmServiceException {
        this.checkAssociation();
        int msgid = this.requestor.nextMsgID();
        Command nDeleteRQ = dcmFact.newCommand();
        nDeleteRQ.initNDeleteRQ(msgid, "1.2.840.10008.5.1.1.23", iuid);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPLUT, nDeleteRQ);
        return this.checkStatus(rsp.getCommand());
    }

    public void checkAssociation() {
        if (!this.requestor.isConnected()) {
            throw new IllegalStateException("No Association exists");
        }
    }

    public int setAnnotationBox(int index, String text) throws InterruptedException, IOException, DcmServiceException {
        if (index < 0 || index >= this.countAnnotationBoxes()) {
            throw new IndexOutOfBoundsException("index:" + index + ", count:" + this.countAnnotationBoxes());
        }
        int msgid = this.requestor.nextMsgID();
        Dataset attr = dcmFact.newDataset();
        attr.putUS(540016656, index + 1);
        attr.putLO(0x20300020, text);
        Dataset refAnnBox = this.curFilmBox.getItem(537920800, index);
        Command nSetRQ = dcmFact.newCommand();
        nSetRQ.initNSetRQ(msgid, refAnnBox.getString(528720), refAnnBox.getString(528725));
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidAnnotation, nSetRQ, attr);
        Command nSetRSP = rsp.getCommand();
        return this.checkStatus(nSetRSP);
    }

    private String checkIUID(String iuid, Command nCreateRSP) throws DcmServiceException {
        if (iuid == null && (iuid = nCreateRSP.getAffectedSOPInstanceUID()) == null) {
            throw new DcmServiceException(-1, "Missing Affected SOP Instance UID in N-CREATE-RSP");
        }
        return iuid;
    }

    public int createFilmSession(Dataset attr, boolean color) throws InterruptedException, IOException, DcmServiceException {
        this.pcidPrint = color ? this.pcidColorPrint : this.pcidGrayscalePrint;
        String iuid = this.createRQwithIUID ? UID_GEN.createUID() : null;
        int msgid = this.requestor.nextMsgID();
        Command nCreateRQ = dcmFact.newCommand();
        nCreateRQ.initNCreateRQ(msgid, "1.2.840.10008.5.1.1.1", iuid);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nCreateRQ, attr);
        Command nCreateRSP = rsp.getCommand();
        int status = this.checkStatus(nCreateRSP);
        this.curFilmSessionIUID = this.checkIUID(iuid, nCreateRSP);
        this.requestor.addPropertyChangeListener("Connected", this.closeListener);
        return status;
    }

    private Dataset makeRefSOP(String cuid, String iuid) {
        Dataset refSOP = dcmFact.newDataset();
        refSOP.putUI(528720, cuid);
        refSOP.putUI(528725, iuid);
        return refSOP;
    }

    private void checkSession() {
        if (this.curFilmSessionIUID == null) {
            throw new IllegalStateException("No current Film Session");
        }
    }

    public int deleteFilmSession() throws InterruptedException, IOException, DcmServiceException {
        this.checkSession();
        int msgid = this.requestor.nextMsgID();
        Command nDeleteRQ = dcmFact.newCommand();
        nDeleteRQ.initNDeleteRQ(msgid, "1.2.840.10008.5.1.1.1", this.curFilmSessionIUID);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nDeleteRQ);
        Command nDeleteRSP = rsp.getCommand();
        this.curFilmSessionIUID = null;
        this.curFilmBoxIUID = null;
        this.curFilmBox = null;
        return this.checkStatus(nDeleteRSP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFilmBox(Dataset attr) throws InterruptedException, IOException, DcmServiceException {
        this.checkSession();
        String iuid = this.createRQwithIUID ? UID_GEN.createUID() : null;
        int msgid = this.requestor.nextMsgID();
        Command nCreateRQ = dcmFact.newCommand();
        nCreateRQ.initNCreateRQ(msgid, "1.2.840.10008.5.1.1.2", iuid);
        attr.putSQ(537920768).addItem(this.makeRefSOP("1.2.840.10008.5.1.1.1", this.curFilmSessionIUID));
        if (this.autoRefPLUT && this.curPLUT_IUID != null && attr.vm(0x20500500) == -1) {
            attr.putSQ(0x20500500).addItem(this.makeRefSOP("1.2.840.10008.5.1.1.23", this.curPLUT_IUID));
        }
        Dimse rsp = null;
        try {
            rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nCreateRQ, attr);
        }
        finally {
            attr.remove(537920768);
        }
        Command nCreateRSP = rsp.getCommand();
        int status = this.checkStatus(nCreateRSP);
        this.curFilmBoxIUID = this.checkIUID(iuid, nCreateRSP);
        this.curFilmBox = rsp.getDataset();
        if (this.curFilmBox == null) {
            throw new DcmServiceException(-1, "Missing Attribute List in N-CREATE-RSP");
        }
        return status;
    }

    private void checkFilmBox() {
        if (this.curFilmBox == null) {
            throw new IllegalStateException("No current Film Box");
        }
    }

    public int deleteFilmBox() throws InterruptedException, IOException, DcmServiceException {
        this.checkFilmBox();
        int msgid = this.requestor.nextMsgID();
        Command nDeleteRQ = dcmFact.newCommand();
        nDeleteRQ.initNDeleteRQ(msgid, "1.2.840.10008.5.1.1.2", this.curFilmBoxIUID);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nDeleteRQ);
        Command nDeleteRSP = rsp.getCommand();
        this.curFilmBoxIUID = null;
        this.curFilmBox = null;
        return this.checkStatus(nDeleteRSP);
    }

    public int countImageBoxes() {
        this.checkFilmBox();
        int count = this.curFilmBox.vm(537920784);
        return count == -1 ? 0 : count;
    }

    public int countAnnotationBoxes() {
        this.checkFilmBox();
        int count = this.curFilmBox.vm(537920800);
        return count == -1 ? 0 : count;
    }

    public int setImageBox(int index, File file, File psFile, Dataset attr, boolean burnInOverlays, boolean autoScale) throws InterruptedException, IOException, DcmServiceException {
        if (index < 0 || index >= this.countImageBoxes()) {
            throw new IndexOutOfBoundsException("index:" + index + ", count:" + this.countImageBoxes());
        }
        Dataset imageBox = dcmFact.newDataset();
        if (attr != null) {
            imageBox.putAll(attr);
        }
        imageBox.putUS(0x20200010, index + 1);
        Dataset refImageBox = this.curFilmBox.getItem(537920784, index);
        int msgid = this.requestor.nextMsgID();
        Command nSetRQ = dcmFact.newCommand();
        nSetRQ.initNSetRQ(msgid, refImageBox.getString(528720), refImageBox.getString(528725));
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nSetRQ, new PrintSCUDataSource(this, imageBox, file, psFile, burnInOverlays, autoScale));
        return this.checkStatus(rsp.getCommand());
    }

    boolean isColorPrint() {
        return this.pcidPrint == this.pcidColorPrint;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    public int printFilmBox() throws InterruptedException, IOException, DcmServiceException {
        this.checkFilmBox();
        int msgid = this.requestor.nextMsgID();
        Command nActionRQ = dcmFact.newCommand();
        nActionRQ.initNActionRQ(msgid, "1.2.840.10008.5.1.1.2", this.curFilmBoxIUID, 1);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nActionRQ);
        Command nActionRSP = rsp.getCommand();
        return this.checkStatus(nActionRSP);
    }

    public int printFilmSession() throws InterruptedException, IOException, DcmServiceException {
        this.checkSession();
        int msgid = this.requestor.nextMsgID();
        Command nActionRQ = dcmFact.newCommand();
        nActionRQ.initNActionRQ(msgid, "1.2.840.10008.5.1.1.1", this.curFilmSessionIUID, 1);
        Dimse rsp = this.requestor.invokeAndWaitForRSP(this.pcidPrint, nActionRQ);
        Command nActionRSP = rsp.getCommand();
        return this.checkStatus(nActionRSP);
    }
}

