/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.PersonName;
import org.dcm4che.data.SpecificCharacterSet;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;

class DcmElementImpl
implements DcmElement {
    static final Logger log = Logger.getLogger(DcmElementImpl.class);
    static final TagDictionary DICT = DictionaryFactory.getInstance().getDefaultTagDictionary();
    static final byte[] BYTE0 = new byte[0];
    static final ByteBuffer EMPTY_VALUE = ByteBuffer.wrap(BYTE0).order(ByteOrder.LITTLE_ENDIAN);
    int tag;
    long streamPos = -1L;

    public DcmElementImpl(int tag) {
        this.tag = tag;
    }

    public DcmElement share() {
        return this;
    }

    public final int tag() {
        return this.tag;
    }

    public int vr() {
        return 0;
    }

    public final int vm() {
        return this.vm(null);
    }

    public int vm(SpecificCharacterSet cs) {
        return 0;
    }

    public int countItems() {
        return 0;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        return -1;
    }

    public final DcmElement setStreamPosition(long streamPos) {
        this.streamPos = streamPos;
        return this;
    }

    public final long getStreamPosition() {
        return this.streamPos;
    }

    public int hashCode() {
        return this.tag;
    }

    public String toString() {
        return DcmElementImpl.toString(this.tag, this.vr(), this.vm(null), this.length(), StringUtils.promptValue(this.vr(), this.getByteBuffer(), 64));
    }

    static String toString(int tag, int vr, int vm, int len, String val) {
        return DICT.toString(tag) + "," + VRs.toString(vr) + ",*" + vm + ",#" + len + ",[" + val + "]";
    }

    boolean match(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
        if (key == null) {
            return true;
        }
        if (key.tag() != this.tag || key.vr() != this.vr()) {
            return false;
        }
        if (this.isEmpty() || key.isEmpty()) {
            return ignoreEmpty || this.isEmpty() && key.isEmpty();
        }
        return this.matchValue(key, ignorePNCase, ignoreEmpty, keyCS, dsCS);
    }

    protected boolean matchValue(DcmElement key, boolean ignorePNCase, boolean ignoreEmpty, SpecificCharacterSet keyCS, SpecificCharacterSet dsCS) {
        throw new UnsupportedOperationException("" + this);
    }

    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException("" + this);
    }

    public ByteBuffer getByteBuffer(ByteOrder byteOrder) {
        throw new UnsupportedOperationException("" + this);
    }

    public boolean hasDataFragments() {
        return false;
    }

    public ByteBuffer getDataFragment(int index) {
        throw new UnsupportedOperationException("" + this);
    }

    public ByteBuffer getDataFragment(int index, ByteOrder byteOrder) {
        throw new UnsupportedOperationException("" + this);
    }

    public int getDataFragmentLength(int index) {
        throw new UnsupportedOperationException("" + this);
    }

    public PersonName getPersonName(SpecificCharacterSet cs) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public PersonName getPersonName(int index, SpecificCharacterSet cs) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public PersonName[] getPersonNames(SpecificCharacterSet cs) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public String getString(SpecificCharacterSet cs) throws DcmValueException {
        return this.getString(0, cs);
    }

    public String getString(int index, SpecificCharacterSet cs) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public String[] getStrings(SpecificCharacterSet cs) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public String getBoundedString(int maxLen, SpecificCharacterSet cs) throws DcmValueException {
        return this.getBoundedString(maxLen, 0, cs);
    }

    public String getBoundedString(int maxLen, int index, SpecificCharacterSet cs) throws DcmValueException {
        return this.getString(index, cs);
    }

    public String[] getBoundedStrings(int maxLen, SpecificCharacterSet cs) throws DcmValueException {
        return this.getStrings(cs);
    }

    public int getInt() throws DcmValueException {
        return this.getInt(0);
    }

    public int getInt(int index) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public int[] getInts() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public int getTag() throws DcmValueException {
        return this.getTag(0);
    }

    public int getTag(int index) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public int[] getTags() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public float getFloat() throws DcmValueException {
        return this.getFloat(0);
    }

    public float getFloat(int index) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public float[] getFloats() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public double getDouble() throws DcmValueException {
        return this.getDouble(0);
    }

    public double getDouble(int index) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public double[] getDoubles() {
        throw new UnsupportedOperationException("" + this);
    }

    public Date getDate() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public Date getDate(int index) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public Date[] getDates() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public Date[] getDateRange() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public void addDataFragment(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("" + this);
    }

    public boolean hasItems() {
        return false;
    }

    public Dataset addNewItem() {
        throw new UnsupportedOperationException("" + this);
    }

    public void addItem(Dataset item) {
        throw new UnsupportedOperationException("" + this);
    }

    public Dataset getItem() {
        return this.getItem(0);
    }

    public Dataset getItem(int index) {
        throw new UnsupportedOperationException("" + this);
    }

    static ByteOrder swap(ByteOrder from) {
        return from == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    static void swapWords(ByteBuffer bb) {
        if ((bb.limit() & 1) != 0) {
            throw new IllegalArgumentException("illegal value length: " + bb);
        }
        int n = bb.limit();
        for (int i = 0; i < n; i += 2) {
            byte b = bb.get(i);
            bb.put(i, bb.get(i + 1));
            bb.put(i + 1, b);
        }
        bb.order(DcmElementImpl.swap(bb.order()));
    }

    static void swapInts(ByteBuffer bb) {
        if ((bb.limit() & 3) != 0) {
            throw new IllegalArgumentException("illegal value length " + bb);
        }
        int n = bb.limit();
        for (int i = 0; i < n; i += 4) {
            byte b = bb.get(i);
            bb.put(i, bb.get(i + 3));
            bb.put(i + 3, b);
            b = bb.get(i + 1);
            bb.put(i + 1, bb.get(i + 2));
            bb.put(i + 2, b);
        }
        bb.order(DcmElementImpl.swap(bb.order()));
    }

    static void swapLongs(ByteBuffer bb) {
        if ((bb.limit() & 7) != 0) {
            throw new IllegalArgumentException("illegal value length " + bb);
        }
        int n = bb.limit();
        for (int i = 0; i < n; i += 8) {
            byte b = bb.get(i);
            bb.put(i, bb.get(i + 7));
            bb.put(i + 7, b);
            b = bb.get(i + 1);
            bb.put(i + 1, bb.get(i + 6));
            bb.put(i + 6, b);
            b = bb.get(i + 2);
            bb.put(i + 2, bb.get(i + 5));
            bb.put(i + 5, b);
            b = bb.get(i + 3);
            bb.put(i + 3, bb.get(i + 4));
            bb.put(i + 4, b);
        }
        bb.order(DcmElementImpl.swap(bb.order()));
    }
}

