/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4cheri.dict.TagDictionaryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class TagDictionaryLoader
extends DefaultHandler {
    private final TagDictionaryImpl dict;
    private final SAXParser parser;

    public TagDictionaryLoader(TagDictionaryImpl dict) {
        this.dict = dict;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception ex) {
            throw new ConfigurationError("Could not create SAX Parser", ex);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if ("element".equals(qName)) {
            String str = attr.getValue("tag");
            if (str == null) {
                throw new SAXException("Missing tag attribute");
            }
            char[] tag = str.toCharArray();
            if (tag.length != 11 || tag[0] != '(' || tag[5] != ',' || tag[10] != ')') {
                throw new SAXException("Illegal tag value: " + str);
            }
            try {
                this.dict.add(new TagDictionary.Entry(this.toTag(tag), str.indexOf(120) == -1 ? -1 : this.toMask(tag), attr.getValue("vr"), attr.getValue("vm"), attr.getValue("name")));
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Illegal tag value: " + str, nfe);
            }
        }
    }

    private int toTag(char[] s) {
        StringBuffer sb = new StringBuffer(8);
        sb.append(this.toTag(s[1])).append(this.toTag(s[2])).append(this.toTag(s[3])).append(this.toTag(s[4])).append(this.toTag(s[6])).append(this.toTag(s[7])).append(this.toTag(s[8])).append(this.toTag(s[9]));
        return (int)Long.parseLong(sb.toString(), 16);
    }

    private char toTag(char ch) {
        return ch == 'x' ? (char)'0' : (char)ch;
    }

    private int toMask(char[] s) {
        StringBuffer sb = new StringBuffer(8);
        sb.append(this.toMask(s[1])).append(this.toMask(s[2])).append(this.toMask(s[3])).append(this.toMask(s[4])).append(this.toMask(s[6])).append(this.toMask(s[7])).append(this.toMask(s[8])).append(this.toMask(s[9]));
        return (int)Long.parseLong(sb.toString(), 16);
    }

    private char toMask(char ch) {
        return ch == 'x' ? (char)'0' : 'f';
    }

    public void parse(InputSource xmlSource) throws SAXException, IOException {
        this.parser.parse(xmlSource, (DefaultHandler)this);
    }

    public void parse(File xmlFile) throws SAXException, IOException {
        this.parser.parse(xmlFile, (DefaultHandler)this);
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String msg, Exception x) {
            super(msg, x);
        }
    }
}

