/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.image.ColorModelFactory;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.MonochromeParam;
import org.dcm4cheri.image.PaletteColorParam;

public class ColorModelFactoryImpl
extends ColorModelFactory {
    private static final Logger log = Logger.getLogger(ColorModelFactoryImpl.class);
    private static final WeakHashMap cache = new WeakHashMap();
    private static final byte[] P2D_IDENTITY = new byte[256];

    public ColorModel getColorModel(ColorModelParam param) {
        log.debug("Getting a color model from " + param);
        if (!param.isCacheable()) {
            return param.newColorModel();
        }
        ColorModel cm = (ColorModel)cache.get(param);
        if (cm == null) {
            cm = param.newColorModel();
            cache.put(param, cm);
        }
        return cm;
    }

    public ColorModelParam makeParam(Dataset ds) {
        return this.makeParam(ds, null);
    }

    public ColorModelParam makeParam(Dataset ds, byte[] pv2dll) {
        String pmi = ds.getString(2621444, "MONOCHROME2");
        if ("PALETTE COLOR".equals(pmi)) {
            return new PaletteColorParam(ds);
        }
        boolean mono1 = "MONOCHROME1".equals(pmi);
        if (!mono1 && !"MONOCHROME2".equals(pmi)) {
            throw new UnsupportedOperationException("pmi: " + pmi);
        }
        String pLUTShape = ds.getString(0x20500020);
        return new MonochromeParam(ds, pLUTShape == null ? mono1 : "INVERSE".equals(pLUTShape), pv2dll == null ? P2D_IDENTITY : pv2dll);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ColorModelFactoryImpl.P2D_IDENTITY[i] = (byte)i;
        }
    }
}

