/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import org.dcm4che.net.Association;
import org.dcm4che.net.AssociationListener;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.PDU;

class Multicaster
implements AssociationListener {
    private final AssociationListener a;
    private final AssociationListener b;

    public static AssociationListener add(AssociationListener a, AssociationListener b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Multicaster(a, b);
    }

    public static AssociationListener remove(AssociationListener l, AssociationListener oldl) {
        if (l == oldl || l == null) {
            return null;
        }
        if (l instanceof Multicaster) {
            return ((Multicaster)l).remove(oldl);
        }
        return null;
    }

    private Multicaster(AssociationListener a, AssociationListener b) {
        this.a = a;
        this.b = b;
    }

    public void write(Association src, PDU pdu) {
        this.a.write(src, pdu);
        this.b.write(src, pdu);
    }

    public void write(Association src, Dimse dimse) {
        this.a.write(src, dimse);
        this.b.write(src, dimse);
    }

    public void received(Association src, PDU pdu) {
        this.a.received(src, pdu);
        this.b.received(src, pdu);
    }

    public void received(Association src, Dimse dimse) {
        this.a.received(src, dimse);
        this.b.received(src, dimse);
    }

    public void error(Association src, IOException ioe) {
        this.a.error(src, ioe);
        this.b.error(src, ioe);
    }

    public void closing(Association src) {
        this.a.closing(src);
        this.b.closing(src);
    }

    public void closed(Association src) {
        this.a.closed(src);
        this.b.closed(src);
    }

    private AssociationListener remove(AssociationListener oldl) {
        if (oldl == this.a) {
            return this.b;
        }
        if (oldl == this.b) {
            return this.a;
        }
        AssociationListener a2 = Multicaster.remove(this.a, oldl);
        AssociationListener b2 = Multicaster.remove(this.b, oldl);
        if (a2 == this.a && b2 == this.b) {
            return this;
        }
        return Multicaster.add(a2, b2);
    }
}

