/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.PDUException;
import org.dcm4che.net.UserIdentityAC;
import org.dcm4cheri.net.AAbortImpl;

final class UserIdentityACImpl
implements UserIdentityAC {
    private static final byte[] EMPTY = new byte[0];
    private final byte[] serverResponse;

    UserIdentityACImpl(byte[] serverResponse) {
        this.serverResponse = serverResponse == null ? EMPTY : (byte[])serverResponse.clone();
    }

    public UserIdentityACImpl() {
        this.serverResponse = EMPTY;
    }

    UserIdentityACImpl(DataInputStream din, int len) throws IOException {
        int rsplen = din.readUnsignedShort();
        if (rsplen + 2 != len) {
            throw new PDUException("User Identity selection sub-item length: " + len + " mismatch Server Response length:" + rsplen, new AAbortImpl(2, 6));
        }
        this.serverResponse = new byte[rsplen];
        din.readFully(this.serverResponse);
    }

    void writeTo(DataOutputStream dout) throws IOException {
        dout.write(89);
        dout.write(0);
        dout.writeShort(this.length());
        dout.writeShort(this.serverResponse.length);
        dout.write(this.serverResponse);
    }

    public final byte[] getServerResponse() {
        return (byte[])this.serverResponse.clone();
    }

    public int length() {
        return 2 + this.serverResponse.length;
    }

    public String toString() {
        return "UserIdentity[serverResponse(" + this.serverResponse.length + ")]";
    }
}

