/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Equipment;

final class EquipmentImpl
implements Equipment {
    private String manufacturer;
    private String institutionName;
    private String institutionAddress;
    private String stationName;
    private String departmentName;
    private String modelName;

    public EquipmentImpl(String manufacturer, String modelName, String stationName) {
        this.setManufacturer(manufacturer);
        this.setModelName(modelName);
        this.setStationName(stationName);
    }

    public EquipmentImpl(Equipment other) {
        this(other.getManufacturer(), other.getModelName(), other.getStationName());
        this.institutionName = other.getInstitutionName();
        this.institutionAddress = other.getInstitutionAddress();
        this.departmentName = other.getDepartmentName();
    }

    public EquipmentImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(524400), ds.getString(528528), ds.getString(528400));
        this.institutionName = ds.getString(524416);
        this.institutionAddress = ds.getString(524417);
        this.departmentName = ds.getString(528448);
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer == null ? "" : manufacturer;
    }

    public final String getInstitutionName() {
        return this.institutionName;
    }

    public final void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public final String getInstitutionAddress() {
        return this.institutionAddress;
    }

    public final void setInstitutionAddress(String institutionAddress) {
        this.institutionAddress = institutionAddress;
    }

    public final String getStationName() {
        return this.stationName;
    }

    public final void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public final String getDepartmentName() {
        return this.departmentName;
    }

    public final void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public final String getModelName() {
        return this.modelName;
    }

    public final void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String toString() {
        return "Equipment[manufacturer=" + this.manufacturer + ",station=" + this.stationName + ",model=" + this.modelName + "]";
    }

    public void toDataset(Dataset ds) {
        ds.putLO(524400, this.manufacturer);
        if (this.institutionName != null) {
            ds.putLO(524416, this.institutionName);
        }
        if (this.institutionAddress != null) {
            ds.putST(524417, this.institutionAddress);
        }
        if (this.stationName != null) {
            ds.putSH(528400, this.stationName);
        }
        if (this.departmentName != null) {
            ds.putLO(528448, this.departmentName);
        }
        if (this.modelName != null) {
            ds.putLO(528528, this.modelName);
        }
    }
}

