/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import java.util.NoSuchElementException;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.ContentImpl;

class ReferencedContentImpl
extends ContentImpl
implements ReferencedContent {
    protected Content refContent;
    protected int[] refContentID;

    ReferencedContentImpl(KeyObject owner, Content refContent) {
        super(owner);
        if (refContent.getOwnerDocument() != owner) {
            throw new IllegalArgumentException();
        }
        if (refContent.getParent() == null) {
            throw new IllegalArgumentException();
        }
        if (refContent instanceof ReferencedContent) {
            throw new IllegalArgumentException();
        }
        this.refContent = refContent;
    }

    ReferencedContentImpl(KeyObject owner, int[] refContentID) {
        super(owner);
        this.refContentID = refContentID;
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        if (newOwner != this.owner) {
            throw new IllegalArgumentException("" + newOwner);
        }
        return new ReferencedContentImpl(newOwner, this.getRefContent().getID());
    }

    public String toString() {
        StringBuffer sb = this.prompt().append(this.refContent != null ? "=>" : "->");
        ReferencedContentImpl.appendID(sb, this.refContent != null ? this.refContent.getID() : this.refContentID);
        return sb.toString();
    }

    public void toDataset(Dataset ds) {
        ds.putCS(4235280, this.relation.toString());
        ds.putUL(4250483, this.getRefContent().getID());
    }

    public Content getRefContent() {
        if (this.refContent != null) {
            return this.refContent;
        }
        this.refContent = this.owner.getContent(this.refContentID);
        if (this.refContent == null) {
            throw new NoSuchElementException(ContentImpl.promptID(this.refContentID));
        }
        return this.refContent;
    }

    public Content insertBefore(Content.RelationType rel, Content newnode, Content refnode) {
        throw new UnsupportedOperationException();
    }

    public Content.ValueType getValueType() {
        return this.getRefContent().getValueType();
    }

    public Date getObservationDateTime(boolean inherit) {
        return this.getRefContent().getObservationDateTime(inherit);
    }

    public Code getName() {
        return this.getRefContent().getName();
    }

    public void setName(Code newName) {
        throw new UnsupportedOperationException();
    }

    public Template getTemplate() {
        return this.getRefContent().getTemplate();
    }
}

