/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.sql.Time;
import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TimeContent;
import org.dcm4cheri.srom.NamedContentImpl;

class TimeContentImpl
extends NamedContentImpl
implements TimeContent {
    private long time;

    TimeContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, long time) {
        super(owner, obsDateTime, template, TimeContentImpl.checkNotNull(name));
        this.time = time;
    }

    TimeContentImpl(KeyObject owner, Date obsDateTime, Template template, Code name, Date time) {
        this(owner, obsDateTime, template, name, time.getTime() % 86400000L);
    }

    Content clone(KeyObject newOwner, boolean inheritObsDateTime) {
        return new TimeContentImpl(newOwner, this.getObservationDateTime(inheritObsDateTime), this.template, this.name, this.time);
    }

    public final void setName(Code newName) {
        this.name = TimeContentImpl.checkNotNull(newName);
    }

    public String toString() {
        return this.prompt().append('(').append(this.getTime()).append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TIME;
    }

    public final Date getTime() {
        return new Time(this.time);
    }

    public final void setTime(Date time) {
        this.time = time.getTime() % 86400000L;
    }

    public void toDataset(Dataset ds) {
        super.toDataset(ds);
        ds.putTM(4235554, this.getTime());
    }
}

