/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;

public abstract class AbstractComponentHolder
extends JLabel
implements MouseListener,
MouseMotionListener {
    private MouseEvent firstMouseEvent;

    protected AbstractComponentHolder() {
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(new PopupListner());
        this.setCursor(new Cursor(0));
        ActionMap map = this.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        if (e.getClickCount() == 2) {
            this.edit();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.firstMouseEvent = e;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.firstMouseEvent != null) {
            e.consume();
            int ctrlMask = 128;
            int action = (e.getModifiersEx() & ctrlMask) == ctrlMask ? 1 : 2;
            int dx = Math.abs(e.getX() - this.firstMouseEvent.getX());
            int dy = Math.abs(e.getY() - this.firstMouseEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, this.firstMouseEvent, action);
                this.firstMouseEvent = null;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    protected abstract void edit();

    public abstract void showPopup(MouseEvent var1);

    class PopupListner
    extends MouseAdapter {
        PopupListner() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AbstractComponentHolder.this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AbstractComponentHolder.this.showPopup(e);
        }
    }
}

