/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.AutoRomanListener;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.delegater.remote.RemoteUserDelegater;
import open.dolphin.infomodel.DepartmentModel;
import open.dolphin.infomodel.LicenseModel;
import open.dolphin.infomodel.RoleModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.security.EncryptUtil;
import open.dolphin.utils.StringTool;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;

public class AddUserPanel
extends JPanel {
    private static final String ADD_USER_SUCCESS_MSG = "\u30e6\u30fc\u30b6\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002";
    private static final String ADD_USER_ERROR_MSG = "\u30e6\u30fc\u30b6\u3092\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
    private LicenseModel[] licenses;
    private DepartmentModel[] depts;
    private boolean ok;
    private int[] userIdLength = new int[]{4, 15};
    private int[] passwordLength = new int[]{6, 10};
    private String usersRole;
    private ApplicationContext appCtx;
    private Application app;
    private TaskService taskService;
    private TaskMonitor taskMonitor;
    private JButton cancelButton;
    private JComboBox deptCombo;
    private JTextField emailField;
    private JTextField givenName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JComboBox licenseCombo;
    private JButton okButton;
    private JTextField sn;
    private JTextField uid;
    private JPasswordField userPassword1;
    private JPasswordField userPassword2;

    public AddUserPanel() {
        this.initComponents();
        this.appCtx = GlobalConstants.getApplicationContext();
        this.app = this.appCtx.getApplication();
        this.taskService = this.appCtx.getTaskService();
        this.taskMonitor = this.appCtx.getTaskMonitor();
        this.usersRole = "user";
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddUserPanel.this.checkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddUserPanel.this.checkButton();
            }
        };
        this.uid.getDocument().addDocumentListener(dl);
        this.uid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.userPassword1.requestFocus();
            }
        });
        this.uid.addFocusListener(AutoRomanListener.getInstance());
        this.userPassword1.getDocument().addDocumentListener(dl);
        this.userPassword1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.userPassword2.requestFocus();
            }
        });
        this.userPassword1.addFocusListener(AutoRomanListener.getInstance());
        this.userPassword2.getDocument().addDocumentListener(dl);
        this.userPassword2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.sn.requestFocus();
            }
        });
        this.userPassword2.addFocusListener(AutoRomanListener.getInstance());
        this.sn.getDocument().addDocumentListener(dl);
        this.sn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.givenName.requestFocus();
            }
        });
        this.sn.addFocusListener(AutoKanjiListener.getInstance());
        this.givenName.getDocument().addDocumentListener(dl);
        this.givenName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.emailField.requestFocus();
            }
        });
        this.givenName.addFocusListener(AutoKanjiListener.getInstance());
        this.emailField.getDocument().addDocumentListener(dl);
        this.emailField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.uid.requestFocus();
            }
        });
        this.emailField.addFocusListener(AutoRomanListener.getInstance());
        this.licenses = GlobalConstants.getLicenseModel();
        this.licenseCombo.setModel(new DefaultComboBoxModel<LicenseModel>(this.licenses));
        this.depts = GlobalConstants.getDepartmentModel();
        this.deptCombo.setModel(new DefaultComboBoxModel<DepartmentModel>(this.depts));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.addUserEntry();
            }
        };
        this.okButton.addActionListener(al);
        this.okButton.setEnabled(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserPanel.this.stop();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
    }

    private void initComponents() {
        this.uid = new JTextField();
        this.userPassword1 = new JPasswordField();
        this.userPassword2 = new JPasswordField();
        this.sn = new JTextField();
        this.givenName = new JTextField();
        this.licenseCombo = new JComboBox();
        this.deptCombo = new JComboBox();
        this.emailField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.uid.setName("uid");
        this.userPassword1.setName("userPassword1");
        this.userPassword2.setName("userPassword2");
        this.sn.setName("sn");
        this.givenName.setName("givenName");
        this.licenseCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.licenseCombo.setName("licenseCombo");
        this.deptCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.deptCombo.setName("deptCombo");
        this.emailField.setName("emailField");
        this.okButton.setText("\u8ffd\u52a0");
        this.okButton.setName("okButton");
        this.cancelButton.setText("\u9589\u3058\u308b");
        this.cancelButton.setName("cancelButton");
        this.jLabel1.setText("\u30e6\u30fc\u30b6ID");
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText("\u59d3");
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText("\u78ba\u8a8d");
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText("\u540d");
        this.jLabel5.setName("jLabel5");
        this.jLabel6.setText("\u533b\u7642\u8cc7\u683c");
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText("\u8a3a\u7642\u79d1");
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setText("\u96fb\u5b50\u30e1\u30fc\u30eb");
        this.jLabel8.setName("jLabel8");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel6).addComponent(this.jLabel8)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.userPassword1, -1, 171, Short.MAX_VALUE).addComponent(this.uid).addComponent(this.sn).addComponent(this.emailField).addComponent(this.licenseCombo, 0, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 11, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.givenName, -1, 186, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.userPassword2, -1, 186, Short.MAX_VALUE).addComponent(this.deptCombo, 0, 186, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uid, -2, -1, -2).addComponent(this.jLabel1)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userPassword1, -2, -1, -2).addComponent(this.userPassword2, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.givenName, -2, -1, -2).addComponent(this.sn, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.licenseCombo, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.deptCombo, -2, 19, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.emailField, -2, -1, -2).addComponent(this.jLabel8)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void addUserEntry() {
        if (!StringTool.patternCheck(this.uid.getText().trim(), this.userIdLength[0], this.userIdLength[1], "[A-Za-z0-9_+\\-.#$&@]*")) {
            return;
        }
        if (!this.passwordOk()) {
            return;
        }
        String pass = new String(this.userPassword1.getPassword());
        UserModel loginUser = GlobalVariables.getUserModel();
        String facilityId = loginUser.getFacility().getFacilityId();
        String hashPass = EncryptUtil.createPasswordHash(pass);
        pass = null;
        final UserModel user = new UserModel();
        user.initialize(facilityId, this.uid.getText(), this.sn.getText(), this.givenName.getText(), hashPass);
        user.setFacility(GlobalVariables.getUserModel().getFacility());
        int index = this.licenseCombo.getSelectedIndex();
        user.setLicenseModel(this.licenses[index]);
        index = this.deptCombo.getSelectedIndex();
        user.setDepartmentModel(this.depts[index]);
        user.setMemberType(GlobalVariables.getUserModel().getMemberType());
        if (GlobalVariables.getUserModel().getMemberType().equals("ASP_TESTER")) {
            user.setRegisteredDate(GlobalVariables.getUserModel().getRegisteredDate());
        } else {
            user.setRegisteredDate(new Date());
        }
        user.setEmail(this.emailField.getText().trim());
        RoleModel rm = new RoleModel();
        rm.setRole(this.usersRole);
        user.addRole(rm);
        rm.setUser(user);
        rm.setUserId(user.getUserId());
        final RemoteUserDelegater udl = new RemoteUserDelegater();
        int maxEstimation = 60000;
        int delay = 200;
        String addMsg = "\u767b\u9332\u3057\u3066\u3044\u307e\u3059...";
        Task<Boolean, Void> task = new Task<Boolean, Void>(this.app){

            protected Boolean doInBackground() throws Exception {
                int cnt = udl.putUser(user);
                return cnt > 0;
            }

            protected void succeeded(Boolean results) {
                if (results.booleanValue()) {
                    JOptionPane.showMessageDialog(null, AddUserPanel.ADD_USER_SUCCESS_MSG, GlobalConstants.getFrameTitle(AddUserPanel.this.getName()), 1);
                    AddUserPanel.this.clearFields();
                } else {
                    JOptionPane.showMessageDialog(null, AddUserPanel.ADD_USER_ERROR_MSG, GlobalConstants.getFrameTitle(AddUserPanel.this.getName()), 2);
                }
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        Object message = null;
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, this.taskMonitor, this, message, addMsg, delay, maxEstimation);
        this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        this.taskService.execute((Task)task);
    }

    private boolean passwordOk() {
        String passwd1 = new String(this.userPassword1.getPassword());
        String passwd2 = new String(this.userPassword2.getPassword());
        if (passwd1.equals("") || passwd2.equals("")) {
            return false;
        }
        if (passwd1.length() < this.passwordLength[0] || passwd1.length() > this.passwordLength[1]) {
            return false;
        }
        if (passwd2.length() < this.passwordLength[0] || passwd2.length() > this.passwordLength[1]) {
            return false;
        }
        return passwd1.equals(passwd2);
    }

    private void checkButton() {
        boolean newOk;
        boolean userOk = StringTool.patternCheck(this.uid.getText().trim(), this.userIdLength[0], this.userIdLength[1], "[A-Za-z0-9_+\\-.#$&@]*");
        boolean passwordOk = this.passwordOk();
        boolean snOk = StringTool.patternCheck(this.sn.getText().trim(), 1, 0, "");
        boolean givenOk = StringTool.patternCheck(this.givenName.getText().trim(), 1, 0, "");
        boolean emailOk = StringTool.patternCheck(this.emailField.getText().trim(), 0, 0, ".+@.+");
        boolean bl = newOk = userOk && passwordOk && snOk && givenOk && emailOk;
        if (this.ok != newOk) {
            this.ok = newOk;
            this.okButton.setEnabled(this.ok);
        }
    }

    private void clearFields() {
        this.uid.setText("");
        this.userPassword1.setText("");
        this.userPassword2.setText("");
        this.sn.setText("");
        this.givenName.setText("");
        this.emailField.setText("");
    }

    private void constrain(JPanel container, Component cmp, int x, int y, int width, int height, int fill, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = width;
        c.gridheight = height;
        c.fill = fill;
        c.anchor = anchor;
        c.insets = new Insets(0, 0, 5, 7);
        container.add(cmp);
    }

    public void stop() {
        this.setVisible(false);
    }
}

