/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.util.HashMap;
import open.dolphin.client.IChartDocument;
import open.dolphin.infomodel.GenericAdapter;

public class ChartDocumentMap
extends HashMap<String, IChartDocument> {
    public boolean isExist(IChartDocument.TYPE type) {
        for (IChartDocument document : this.values()) {
            if (document.getType() != type) continue;
            return true;
        }
        return false;
    }

    public IChartDocument getAsType(IChartDocument.TYPE type) {
        for (IChartDocument document : this.values()) {
            if (document.getType() != type) continue;
            return document;
        }
        return null;
    }

    public boolean isDirty() {
        for (IChartDocument component : this.values()) {
            if (component instanceof IChartDocument) {
                if (!component.isDirty()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean enumerate(GenericAdapter<IChartDocument, Object> adapter) throws Exception {
        for (IChartDocument document : this.values()) {
            if (!adapter.onResult(document, null)) continue;
            return true;
        }
        return false;
    }

    public IChartDocument addPanel(IChartDocument panel) {
        panel.start();
        this.put(panel.getTitle(), panel);
        return panel;
    }
}

