/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorFillIcon
implements Icon {
    private int width;
    private int height;
    private Color fillColor;
    private Color shadow;
    private int borderSize;
    private int fillHeight;
    private int fillWidth;
    private static final int BORDER_SIZE = 2;
    private static final int DEFAULT_SIZE = 32;

    public ColorFillIcon(Color fill, int width, int height, int borderSize) {
        this.fillColor = fill;
        this.width = width;
        this.height = height;
        this.borderSize = borderSize;
        this.shadow = Color.black;
        this.fillWidth = width - 2 * borderSize;
        this.fillHeight = height - 2 * borderSize;
    }

    private ColorFillIcon(Color fill, int size) {
        this(fill, size, size, 2);
    }

    private ColorFillIcon(Color fill) {
        this(fill, 32, 32, 2);
    }

    private void setShadow(Color c) {
        this.shadow = c;
    }

    private void setFillColor(Color c) {
        this.fillColor = c;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component comp, Graphics g, int x, int y) {
        Color c = g.getColor();
        if (this.borderSize > 0) {
            g.setColor(this.shadow);
            for (int i = 0; i < this.borderSize; ++i) {
                g.drawRect(x + i, y + i, this.width - 2 * i - 1, this.height - 2 * i - 1);
            }
        }
        g.setColor(this.fillColor);
        g.fillRect(x + this.borderSize, y + this.borderSize, this.fillWidth, this.fillHeight);
        g.setColor(c);
    }
}

