/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.client.AutoKanjiListener;
import open.dolphin.client.SaveParams;
import open.dolphin.project.GlobalConstants;

public class SaveDialog {
    private static final String[] PRINT_COUNT = new String[]{"0", "1", "2", "3", "4", "5"};
    private static final String[] TITLE_LIST = new String[]{"\u7d4c\u904e\u8a18\u9332", "\u51e6\u65b9", "\u51e6\u7f6e", "\u691c\u67fb", "\u753b\u50cf", "\u6307\u5c0e"};
    private static final String TITLE = "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u4fdd\u5b58";
    private static final String SAVE = "\u4fdd\u5b58";
    private static final String TMP_SAVE = "\u4eee\u4fdd\u5b58";
    private static final String TEMPLATE_SAVE = "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u4fdd\u5b58";
    private JCheckBox patientCheck;
    private JCheckBox clinicCheck;
    private JButton okButton;
    private JButton cancelButton;
    private JButton tmpButton;
    private JButton templateButton;
    private JTextField titleField;
    private JComboBox titleCombo;
    private JComboBox printCombo;
    private JLabel departmentLabel;
    private JCheckBox sendClaim;
    private SaveParams value;
    private JDialog dialog;
    private boolean ok;

    public SaveDialog(Window parent, SaveParams params) {
        JPanel contentPanel = this.createComponent();
        Object[] options = new Object[]{this.okButton, this.tmpButton, this.cancelButton};
        JOptionPane jop = new JOptionPane(contentPanel, -1, -1, null, options, this.okButton);
        this.dialog = jop.createDialog(parent, GlobalConstants.getFrameTitle(TITLE));
        this.initializeWith(params);
    }

    public SaveParams open() {
        this.ok = false;
        this.dialog.setVisible(true);
        if (this.ok) {
            return this.getParams();
        }
        return null;
    }

    private void createButtons() {
        this.createOkButton();
        this.createCancelButton();
        this.createTmpButton();
    }

    private void createTemplateButton() {
        this.templateButton = new JButton(TEMPLATE_SAVE);
        this.templateButton.setToolTipText("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3068\u3057\u3066\u4fdd\u5b58\u3057\u307e\u3059");
        this.templateButton.addActionListener(EventHandler.create(ActionListener.class, this, "doTemplate"));
        this.templateButton.setEnabled(false);
    }

    private void createTmpButton() {
        this.tmpButton = new JButton(TMP_SAVE);
        this.tmpButton.setToolTipText("\u8a3a\u7642\u884c\u70ba\u306f\u9001\u4fe1\u3057\u307e\u305b\u3093");
        this.tmpButton.addActionListener(EventHandler.create(ActionListener.class, this, "doTemp"));
        this.tmpButton.setEnabled(false);
    }

    private void createCancelButton() {
        String buttonText = (String)UIManager.get("OptionPane.cancelButtonText");
        this.cancelButton = new JButton(buttonText);
        this.cancelButton.addActionListener(EventHandler.create(ActionListener.class, this, "doCancel"));
    }

    private void createOkButton() {
        this.okButton = new JButton(SAVE);
        this.okButton.setToolTipText("\u8a3a\u7642\u884c\u70ba\u306e\u9001\u4fe1\u306f\u30c1\u30a7\u30c3\u30af\u30dc\u30c3\u30af\u30b9\u306b\u5f93\u3044\u307e\u3059\u3002");
        this.okButton.addActionListener(EventHandler.create(ActionListener.class, this, "doOk"));
        this.okButton.setEnabled(false);
    }

    private JPanel createPrintPanel() {
        JPanel printPanel = new JPanel(new FlowLayout(0));
        this.departmentLabel = new JLabel();
        printPanel.add(new JLabel("\u8a3a\u7642\u79d1:"));
        printPanel.add(this.departmentLabel);
        printPanel.add(Box.createRigidArea(new Dimension(11, 0)));
        this.printCombo = new JComboBox<String>(PRINT_COUNT);
        this.printCombo.setSelectedIndex(1);
        printPanel.add(new JLabel("\u5370\u5237\u90e8\u6570:"));
        printPanel.add(this.printCombo);
        return printPanel;
    }

    private JPanel createSendClaimPanel() {
        JPanel sendClaimPanel = new JPanel(new FlowLayout(0));
        this.sendClaim = new JCheckBox("\u8a3a\u7642\u884c\u70ba\u3092\u9001\u4fe1\u3059\u308b (\u4eee\u4fdd\u5b58\u306e\u5834\u5408\u306f\u9001\u4fe1\u3057\u306a\u3044)");
        sendClaimPanel.add(this.sendClaim);
        return sendClaimPanel;
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel(new FlowLayout(0));
        this.titleCombo = new JComboBox<String>(TITLE_LIST);
        this.titleCombo.setPreferredSize(new Dimension(220, this.titleCombo.getPreferredSize().height));
        this.titleCombo.setMaximumSize(this.titleCombo.getPreferredSize());
        this.titleCombo.setEditable(true);
        titlePanel.add(new JLabel("\u30bf\u30a4\u30c8\u30eb:"));
        titlePanel.add(this.titleCombo);
        this.titleField = (JTextField)this.titleCombo.getEditor().getEditorComponent();
        this.titleField.addFocusListener(AutoKanjiListener.getInstance());
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SaveDialog.this.checkTitle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SaveDialog.this.checkTitle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SaveDialog.this.checkTitle();
            }
        };
        this.titleField.getDocument().addDocumentListener(dl);
        return titlePanel;
    }

    private SaveParams getParams() {
        return this.value;
    }

    private void initializeWith(SaveParams params) {
        this.value = params;
        this.showTitle();
        this.showDepartment();
        this.showPrintCount();
        this.showSendClaim();
        this.showAccessRight();
        this.checkTitle();
    }

    private void showAccessRight() {
        if (this.value.getSendMML()) {
            boolean permit = this.value.isAllowPatientRef();
            this.patientCheck.setSelected(permit);
            permit = this.value.isAllowClinicRef();
            this.clinicCheck.setSelected(permit);
        } else {
            this.patientCheck.setEnabled(false);
            this.clinicCheck.setEnabled(false);
        }
    }

    private void showSendClaim() {
        if (this.value.isDisableSendClaim()) {
            this.sendClaim.setEnabled(false);
        } else {
            this.sendClaim.setSelected(this.value.isSendClaim());
        }
    }

    private void showPrintCount() {
        int count = this.value.getPrintCount();
        if (count != -1) {
            this.printCombo.setSelectedItem(String.valueOf(count));
        } else {
            this.printCombo.setEnabled(false);
        }
    }

    private void showDepartment() {
        String department = this.value.getDepartment();
        if (department != null) {
            String[] depts = department.split("\\s*,\\s*");
            if (depts[0] != null) {
                this.departmentLabel.setText(depts[0]);
            } else {
                this.departmentLabel.setText(department);
            }
        }
    }

    private void showTitle() {
        String title = this.value.getTitle();
        if (title != null && !title.equals("") && !title.equals("\u7d4c\u904e\u8a18\u9332")) {
            this.titleCombo.insertItemAt(title, 0);
        }
        this.titleCombo.setSelectedIndex(0);
    }

    private JPanel createComponent() {
        JPanel content = new JPanel();
        content.setLayout(new GridLayout(0, 1));
        content.add(this.createTitlePanel());
        content.add(this.createPrintPanel());
        this.patientCheck = new JCheckBox("\u60a3\u8005\u306b\u53c2\u7167\u3092\u8a31\u53ef\u3059\u308b");
        this.clinicCheck = new JCheckBox("\u8a3a\u7642\u6b74\u306e\u3042\u308b\u75c5\u9662\u306b\u53c2\u7167\u3092\u8a31\u53ef\u3059\u308b");
        content.add(this.createSendClaimPanel());
        this.createButtons();
        return content;
    }

    public void checkTitle() {
        boolean enabled = !this.titleField.getText().trim().isEmpty();
        this.okButton.setEnabled(enabled);
        this.tmpButton.setEnabled(enabled);
    }

    private void setParams(String defaultTiele, boolean send) {
        String val = (String)this.titleCombo.getSelectedItem();
        if (!val.isEmpty()) {
            this.value.setTitle(val);
        } else {
            this.value.setTitle(defaultTiele);
        }
        this.value.setDepartment(this.departmentLabel.getText());
        int count = Integer.parseInt((String)this.printCombo.getSelectedItem());
        this.value.setPrintCount(count);
        this.value.setSendClaim(send);
        this.value.setAllowPatientRef(false);
        this.value.setAllowClinicRef(false);
    }

    public void doOk() {
        if (this.sendClaim.isSelected()) {
            this.value.setStatus("F");
            this.setParams("\u7d4c\u904e\u8a18\u9332", true);
        } else {
            this.value.setStatus("M");
            this.setParams("\u7d4c\u904e\u8a18\u9332", false);
        }
        this.ok = true;
        this.close();
    }

    public void doTemp() {
        this.value.setStatus("T");
        this.setParams(TMP_SAVE, false);
        this.ok = true;
        this.close();
    }

    public void doTemplate() {
        this.value.setStatus("A");
        this.setParams("\u65b0\u898f\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", false);
        this.ok = true;
        this.close();
    }

    public void doCancel() {
        this.value = null;
        this.ok = false;
        this.close();
    }

    private void close() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }
}

