/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.caremapdocument;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import open.dolphin.client.ChartMediator;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.ColorFillIcon;
import open.dolphin.client.IChart;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.LetterView;
import open.dolphin.client.Period;
import open.dolphin.client.caremapdocument.AppointColors;
import open.dolphin.client.caremapdocument.AppointLabel;
import open.dolphin.client.caremapdocument.AppointTablePanel;
import open.dolphin.client.caremapdocument.ImageHistoryPanel;
import open.dolphin.client.caremapdocument.OrderHistoryPanel;
import open.dolphin.client.caremapdocument.SimpleCalendarPanel;
import open.dolphin.delegater.remote.RemoteAppointmentDelegater;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.dto.ImageSearchSpec;
import open.dolphin.dto.ModuleSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.helper.IChartCommandAccepter;
import open.dolphin.infomodel.AppointmentModel;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;

public class CareMapDocumentPanel
extends JPanel
implements IChartDocument,
IChartCommandAccepter {
    public static final String MARK_EVENT_PROP = "MARK_EVENT_PROP";
    public static final String PERIOD_PROP = "PERIOD_PROP";
    public static final String CALENDAR_PROP = "CALENDAR_PROP";
    public static final String SELECTED_DATE_PROP = "SELECTED_DATE_PROP";
    public static final String SELECTED_APPOINT_DATE_PROP = "SELECTED_DATE_PROP";
    public static final String APPOINT_PROP = "APPOINT_PROP";
    private static final String[] orderCodes = new String[]{"medOrder", "treatmentOrder", "instractionChargeOrder", "testOrder", "physiologyOrder", "radiologyOrder"};
    private static final int IMAGE_WIDTH = 128;
    private static final int IMAGE_HEIGHT = 128;
    public static final String TITLE = "\u6cbb\u7642\u5c65\u6b74";
    private OrderHistoryPanel history;
    private AppointTablePanel appointTable;
    private ImageHistoryPanel imagePanel;
    private String imageEvent = "image";
    private SimpleCalendarPanel c0;
    private SimpleCalendarPanel c1;
    private SimpleCalendarPanel c2;
    private Period selectedPeriod;
    private int origin;
    private PropertyChangeSupport boundSupport;
    private Hashtable<Integer, SimpleCalendarPanel> cPool;
    private String selectedEvent;
    private List allModules;
    private List allAppointments;
    private List allImages;
    private Timer taskTimer;
    private static final String[] CHART_MENUS = new String[]{"openKarte", "save", "direction", "delete", "print", "modifyKarte", "ascending", "descending", "showModified", "showUnsend", "showSend", "showNewest", "insertText", "insertSchema", "insertStamp", "selectInsurance", "cut", "copy", "paste", "undo", "redo"};
    private IChart parent;
    private String title = "\u6cbb\u7642\u5c65\u6b74";
    private boolean dirty;
    private ModuleModel selectedHistoryModel;
    private JPanel appointPanel;
    private JPanel calenderPanel;
    private JPanel controlPanel;
    private JPanel han;
    private JPanel historyPanel;
    private JButton nextBtn;
    private JComboBox orderCombo;
    private JButton prevBtn;
    private JButton updateAppoBtn;

    public CareMapDocumentPanel(IChart parent) {
        this.parent = parent;
        this.boundSupport = new PropertyChangeSupport(this);
        this.initComponents();
    }

    @Override
    public IChartDocument.TYPE getType() {
        return IChartDocument.TYPE.CareMapDocumentPanel;
    }

    private void initComponents() {
        this.updateAppoBtn = new JButton();
        this.historyPanel = new JPanel();
        this.calenderPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.prevBtn = new JButton();
        this.orderCombo = new JComboBox();
        this.nextBtn = new JButton();
        this.han = new JPanel();
        this.appointPanel = new JPanel();
        this.updateAppoBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/save_24.gif")));
        this.updateAppoBtn.setEnabled(false);
        this.updateAppoBtn.setName("updateAppoBtn");
        this.updateAppoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CareMapDocumentPanel.this.updateAppoBtnActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.historyPanel.setBorder(BorderFactory.createTitledBorder("\u5c65 \u6b74"));
        this.historyPanel.setName("historyPanel");
        this.historyPanel.setLayout(new BorderLayout());
        this.calenderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.calenderPanel.setMinimumSize(new Dimension(101, 101));
        this.calenderPanel.setName("calenderPanel");
        this.calenderPanel.setLayout(new BoxLayout(this.calenderPanel, 0));
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controlPanel.setName("controlPanel");
        this.prevBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/back_16.gif")));
        this.prevBtn.setToolTipText("\u524d\u6708");
        this.prevBtn.setName("prevBtn");
        this.prevBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CareMapDocumentPanel.this.prevBtnActionPerformed(evt);
            }
        });
        this.orderCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"\u51e6\u65b9", "\u51e6\u7f6e", "\u6307\u5c0e", "\u30e9\u30dc\u30c6\u30b9\u30c8", "\u751f\u4f53\u691c\u67fb", "\u753b\u50cf\u8a3a\u65ad"}));
        this.orderCombo.setMaximumSize(new Dimension(100, 26));
        this.orderCombo.setName("orderCombo");
        this.orderCombo.setPreferredSize(new Dimension(100, 26));
        this.orderCombo.setRenderer(new ComboBoxRenderer());
        this.orderCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CareMapDocumentPanel.this.orderComboItemStateChanged(evt);
            }
        });
        this.nextBtn.setIcon(new ImageIcon(this.getClass().getResource("/open/dolphin/resources/images/forwd_16.gif")));
        this.nextBtn.setToolTipText("\u6b21\u6708");
        this.nextBtn.setName("nextBtn");
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CareMapDocumentPanel.this.nextBtnActionPerformed(evt);
            }
        });
        this.han.setBorder(BorderFactory.createEtchedBorder());
        this.han.setMaximumSize(new Dimension(10, 10));
        this.han.setName("han");
        this.han.setLayout(new BoxLayout(this.han, 0));
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addComponent(this.prevBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orderCombo, 0, 166, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextBtn)).addComponent(this.han, GroupLayout.Alignment.TRAILING, -1, 278, Short.MAX_VALUE)).addGap(24, 24, 24)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.han, -2, 27, -2).addGap(8, 8, 8).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.orderCombo, -1, 25, Short.MAX_VALUE).addComponent(this.prevBtn, -1, -1, Short.MAX_VALUE).addComponent(this.nextBtn, GroupLayout.Alignment.LEADING, -1, 25, Short.MAX_VALUE)).addContainerGap()));
        this.appointPanel.setBorder(BorderFactory.createEtchedBorder());
        this.appointPanel.setName("appointPanel");
        this.appointPanel.setLayout(new BoxLayout(this.appointPanel, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calenderPanel, -1, 306, Short.MAX_VALUE).addComponent(this.controlPanel, -1, -1, Short.MAX_VALUE).addComponent(this.historyPanel, -1, 306, Short.MAX_VALUE).addComponent(this.appointPanel, -1, 306, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.calenderPanel, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controlPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.historyPanel, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.appointPanel, -1, 127, Short.MAX_VALUE).addContainerGap()));
    }

    private void prevBtnActionPerformed(ActionEvent evt) {
        SimpleCalendarPanel.SimpleCalendarPool pool = SimpleCalendarPanel.SimpleCalendarPool.getInstance();
        --this.origin;
        SimpleCalendarPanel save = this.c0;
        SimpleCalendarPanel test = this.cPool.get(new Integer(this.origin - 1));
        if (test != null) {
            this.c0 = test;
        } else {
            this.c0 = pool.acquireSimpleCalendar(this.origin - 1);
            this.c0.setChartContext(this.getParentContext());
            this.c0.setParent(this);
            this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.history);
            this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.imagePanel);
            this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.appointTable);
            this.c0.addPropertyChangeListener(APPOINT_PROP, this.appointTable);
            this.cPool.put(new Integer(this.origin - 1), this.c0);
        }
        this.c2 = this.c1;
        this.c1 = save;
        this.calenderPanel.removeAll();
        this.calenderPanel.add(this.c0);
        this.calenderPanel.add(this.c1);
        this.calenderPanel.add(this.c2);
        this.calenderPanel.revalidate();
        Period pp = new Period(this);
        pp.setStartDate(this.c0.getFirstDate());
        pp.setEndDate(this.c2.getLastDate());
        this.setSelectedPeriod(pp);
    }

    private void nextBtnActionPerformed(ActionEvent evt) {
        SimpleCalendarPanel.SimpleCalendarPool pool = SimpleCalendarPanel.SimpleCalendarPool.getInstance();
        ++this.origin;
        SimpleCalendarPanel save = this.c2;
        SimpleCalendarPanel test = this.cPool.get(new Integer(this.origin + 1));
        if (test != null) {
            this.c2 = test;
        } else {
            this.c2 = pool.acquireSimpleCalendar(this.origin + 1);
            this.c2.setChartContext(this.getParentContext());
            this.c2.setParent(this);
            this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.history);
            this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.imagePanel);
            this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.appointTable);
            this.c2.addPropertyChangeListener(APPOINT_PROP, this.appointTable);
            this.cPool.put(new Integer(this.origin + 1), this.c2);
        }
        this.c0 = this.c1;
        this.c1 = save;
        this.calenderPanel.removeAll();
        this.calenderPanel.add(this.c0);
        this.calenderPanel.add(this.c1);
        this.calenderPanel.add(this.c2);
        this.calenderPanel.revalidate();
        Period pp = new Period(this);
        pp.setStartDate(this.c0.getFirstDate());
        pp.setEndDate(this.c2.getLastDate());
        this.setSelectedPeriod(pp);
    }

    private void updateAppoBtnActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void orderComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String event = this.getMarkCode();
            if (event.equals(this.imageEvent)) {
                this.historyPanel.removeAll();
                this.historyPanel.add((Component)this.imagePanel, "Center");
                this.historyPanel.revalidate();
                this.repaint();
            } else if (this.selectedEvent.equals(this.imageEvent)) {
                this.historyPanel.removeAll();
                this.historyPanel.add((Component)this.history, "Center");
                this.historyPanel.revalidate();
                this.repaint();
            }
            this.setSelectedEvent(event);
        }
    }

    public void initialize() {
        this.cPool = new Hashtable(12, 0.75f);
        IChart chartCtx = this.getParentContext();
        SimpleCalendarPanel.SimpleCalendarPool pool = SimpleCalendarPanel.SimpleCalendarPool.getInstance();
        this.c0 = pool.acquireSimpleCalendar(this.origin - 1);
        this.c1 = pool.acquireSimpleCalendar(this.origin);
        this.c2 = pool.acquireSimpleCalendar(this.origin + 1);
        this.c0.setChartContext(chartCtx);
        this.c1.setChartContext(chartCtx);
        this.c2.setChartContext(chartCtx);
        this.c0.setParent(this);
        this.c1.setParent(this);
        this.c2.setParent(this);
        this.cPool.put(new Integer(this.origin - 1), this.c0);
        this.cPool.put(new Integer(this.origin), this.c1);
        this.cPool.put(new Integer(this.origin + 1), this.c2);
        this.calenderPanel.add(Box.createHorizontalStrut(11));
        this.calenderPanel.add(this.c0);
        this.calenderPanel.add(Box.createHorizontalStrut(11));
        this.calenderPanel.add(this.c1);
        this.calenderPanel.add(Box.createHorizontalStrut(11));
        this.calenderPanel.add(this.c2);
        this.calenderPanel.add(Box.createHorizontalStrut(11));
        this.appointTable = new AppointTablePanel(this.updateAppoBtn);
        this.appointTable.setParent(this);
        this.appointTable.setBorder(BorderFactory.createTitledBorder("\u4e88\u7d04\u8868"));
        this.appointTable.setPreferredSize(new Dimension(500, 260));
        this.appointPanel.add(this.appointTable);
        this.history = new OrderHistoryPanel(this);
        this.history.setPid(chartCtx.getPatient().getPatientId());
        this.imagePanel = new ImageHistoryPanel();
        this.imagePanel.setMyParent(this);
        this.imagePanel.setPid(chartCtx.getPatient().getPatientId());
        this.han.add(new JLabel("\u4e88\u7d04( "));
        for (int i = 0; i < AppointColors.appointNames.length; ++i) {
            if (i != 0) {
                this.han.add(Box.createHorizontalStrut(7));
            }
            AppointLabel dl = new AppointLabel(AppointColors.appointNames[i], new ColorFillIcon(AppointColors.appointColors[i], 10, 10, 1), 0);
            this.han.add(dl);
        }
        this.han.add(new JLabel(" )"));
        this.han.add(Box.createHorizontalStrut(7));
        Color birthC = GlobalConstants.getColor("color.BIRTHDAY_BACK");
        this.han.add(new JLabel("\u8a95\u751f\u65e5", new ColorFillIcon(birthC, 10, 10, 1), 0));
        this.han.add(Box.createHorizontalStrut(11));
        this.historyPanel.add((Component)this.history, "Center");
        this.addPropertyChangeListener(CALENDAR_PROP, this.appointTable);
        this.c0.addPropertyChangeListener(APPOINT_PROP, this.appointTable);
        this.c1.addPropertyChangeListener(APPOINT_PROP, this.appointTable);
        this.c2.addPropertyChangeListener(APPOINT_PROP, this.appointTable);
        this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.history);
        this.c1.addPropertyChangeListener("SELECTED_DATE_PROP", this.history);
        this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.history);
        this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.imagePanel);
        this.c1.addPropertyChangeListener("SELECTED_DATE_PROP", this.imagePanel);
        this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.imagePanel);
        this.c0.addPropertyChangeListener("SELECTED_DATE_PROP", this.appointTable);
        this.c1.addPropertyChangeListener("SELECTED_DATE_PROP", this.appointTable);
        this.c2.addPropertyChangeListener("SELECTED_DATE_PROP", this.appointTable);
    }

    @Override
    public void start() {
        this.initialize();
        this.enter();
        this.setSelectedEvent(this.getMarkCode());
        Period period = new Period(this);
        period.setStartDate(this.c0.getFirstDate());
        period.setEndDate(this.c2.getLastDate());
        this.setSelectedPeriod(period);
    }

    @Override
    public void stop() {
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        this.boundSupport.removePropertyChangeListener(prop, l);
    }

    public void setAllModules(List newModules) {
        if (newModules != null && !newModules.isEmpty()) {
            this.allModules = newModules;
            this.c0.setModuleList(this.selectedEvent, (List)this.allModules.get(0));
            this.c1.setModuleList(this.selectedEvent, (List)this.allModules.get(1));
            this.c2.setModuleList(this.selectedEvent, (List)this.allModules.get(2));
            this.history.setModuleList(this.allModules);
        }
    }

    public void setAllAppointments(List allAppo) {
        if (allAppo != null && !allAppo.isEmpty()) {
            this.allAppointments = allAppo;
            this.c0.setAppointmentList((List)this.allAppointments.get(0));
            this.c1.setAppointmentList((List)this.allAppointments.get(1));
            this.c2.setAppointmentList((List)this.allAppointments.get(2));
            this.notifyCalendar();
        }
    }

    public void setAllImages(List images) {
        if (images != null && !images.isEmpty()) {
            this.allImages = images;
            this.c0.setImageList(this.selectedEvent, (List)this.allImages.get(0));
            this.c1.setImageList(this.selectedEvent, (List)this.allImages.get(1));
            this.c2.setImageList(this.selectedEvent, (List)this.allImages.get(2));
            this.imagePanel.setImageList(this.allImages);
        }
    }

    public void setSelectedPeriod(Period p) {
        this.selectedPeriod = p;
        if (this.getSelectedEvent().equals(this.imageEvent)) {
            this.getImageList();
        } else {
            this.getModuleList(true);
        }
    }

    private void notifyCalendar() {
        SimpleCalendarPanel[] sc = new SimpleCalendarPanel[]{this.c0, this.c1, this.c2};
        this.boundSupport.firePropertyChange(CALENDAR_PROP, null, sc);
    }

    public String getSelectedEvent() {
        return this.selectedEvent;
    }

    public void setSelectedEvent(String code) {
        this.selectedEvent = code;
        if (this.getSelectedEvent().equals(this.imageEvent)) {
            this.getImageList();
        } else {
            this.getModuleList(false);
        }
    }

    public void setSelectedHistoryModel(ModuleModel model) {
        this.selectedHistoryModel = model;
    }

    public ModuleModel getSelectedHistoryModel() {
        return this.selectedHistoryModel;
    }

    private void getModuleList(final boolean appo) {
        if (this.selectedEvent != null && this.selectedPeriod != null) {
            final ModuleSearchSpec spec = new ModuleSearchSpec();
            spec.setCode(0);
            spec.setKarteId(this.getParentContext().getKarte().getId());
            spec.setEntity(this.selectedEvent);
            spec.setStatus("F");
            Date[] fromDate = new Date[]{ModelUtils.getDateTimeAsObject(this.c0.getFirstDate() + "T00:00:00"), ModelUtils.getDateTimeAsObject(this.c1.getFirstDate() + "T00:00:00"), ModelUtils.getDateTimeAsObject(this.c2.getFirstDate() + "T00:00:00")};
            spec.setFromDate(fromDate);
            Date[] toDate = new Date[]{ModelUtils.getDateTimeAsObject(this.c0.getLastDate() + "T23:59:59"), ModelUtils.getDateTimeAsObject(this.c1.getLastDate() + "T23:59:59"), ModelUtils.getDateTimeAsObject(this.c2.getLastDate() + "T23:59:59")};
            spec.setToDate(toDate);
            final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
            DBTask<List[]> task = new DBTask<List[]>(this.getParentContext()){

                @Override
                public List[] doInBackground() throws Exception {
                    List modules;
                    List[] ret = new List[2];
                    ret[0] = modules = ddl.getModuleList(spec);
                    if (appo) {
                        List appointments;
                        ret[1] = appointments = ddl.getAppoinmentList(spec);
                    }
                    return ret;
                }

                @Override
                public void succeeded(List[] result) {
                    CareMapDocumentPanel.this.setAllModules(result[0]);
                    if (appo) {
                        CareMapDocumentPanel.this.setAllAppointments(result[1]);
                    }
                }
            };
            task.execute();
        }
    }

    private void getImageList() {
        if (this.selectedPeriod != null) {
            final ImageSearchSpec spec = new ImageSearchSpec();
            spec.setCode(1);
            spec.setKarteId(this.getParentContext().getKarte().getId());
            spec.setStatus("F");
            Date[] fromDate = new Date[]{ModelUtils.getDateTimeAsObject(this.c0.getFirstDate() + "T00:00:00"), ModelUtils.getDateTimeAsObject(this.c1.getFirstDate() + "T00:00:00"), ModelUtils.getDateTimeAsObject(this.c2.getFirstDate() + "T00:00:00")};
            spec.setFromDate(fromDate);
            Date[] toDate = new Date[]{ModelUtils.getDateTimeAsObject(this.c0.getLastDate() + "T23:59:59"), ModelUtils.getDateTimeAsObject(this.c1.getLastDate() + "T23:59:59"), ModelUtils.getDateTimeAsObject(this.c2.getLastDate() + "T23:59:59")};
            spec.setToDate(toDate);
            spec.setIconSize(new Dimension(128, 128));
            final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
            DBTask<List> task = new DBTask<List>(this.getParentContext()){

                @Override
                public List doInBackground() throws Exception {
                    return ddl.getImageList(spec);
                }

                @Override
                public void succeeded(List result) {
                    CareMapDocumentPanel.this.setAllImages(result);
                }
            };
            task.execute();
        }
    }

    @Override
    public void setDirty(boolean dirty) {
        if (this.isDirty() != dirty) {
            this.dirty = dirty;
            this.updateAppoBtn.setEnabled(this.isDirty());
        }
    }

    private boolean save() {
        final ArrayList<AppointmentModel> results = new ArrayList<AppointmentModel>();
        Enumeration<SimpleCalendarPanel> e = this.cPool.elements();
        while (e.hasMoreElements()) {
            SimpleCalendarPanel c = e.nextElement();
            if (c.getRelativeMonth() < 0) continue;
            List<AppointmentModel> list = c.getUpdatedAppoints();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                AppointmentModel appo = list.get(i);
                if (appo.getKarte() == null) {
                    appo.setKarte(this.getParentContext().getKarte());
                }
                appo.setCreator(GlobalVariables.getUserModel());
                Date confirmed = new Date();
                appo.setConfirmed(confirmed);
                appo.setRecorded(confirmed);
                if (appo.getStarted() == null) {
                    appo.setStarted(confirmed);
                }
                appo.setStatus("F");
                results.add(list.get(i));
            }
        }
        if (results.isEmpty()) {
            return true;
        }
        final RemoteAppointmentDelegater adl = new RemoteAppointmentDelegater();
        DBTask<Void> task = new DBTask<Void>(this.getParentContext()){

            @Override
            protected Void doInBackground() throws Exception {
                adl.putAppointments(results);
                return null;
            }

            @Override
            public void succeeded(Void result) {
                CareMapDocumentPanel.this.setDirty(false);
            }
        };
        task.execute();
        return true;
    }

    public JComboBox getOrderCombo() {
        return this.orderCombo;
    }

    public String getMarkCode() {
        int index = this.orderCombo.getSelectedIndex();
        return orderCodes[index];
    }

    @Override
    public boolean itLayoutSaved() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public IChart getParentContext() {
        return this.parent;
    }

    @Override
    public void enter() {
        this.getParentContext().getStatusPanel().setMessage("");
        this.getParentContext().getChartMediator().setAccepter(this);
        this.disableMenus();
        this.getParentContext().enabledAction("newKarte", true);
        this.getParentContext().enabledAction("newDocument", true);
        this.getParentContext().enabledAction("addUser", GlobalVariables.isAdmin());
        if (this.getParentContext() instanceof ChartWindow && ((ChartWindow)this.getParentContext()).existLetterPane()) {
            ((ChartWindow)this.getParentContext()).getChartMediator().getAction("letterPaste").setEnabled(true);
        } else {
            ((ChartWindow)this.getParentContext()).getChartMediator().getAction("letterPaste").setEnabled(false);
        }
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private boolean print() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.getParentContext().isReadOnly();
    }

    public void disableMenus() {
        ChartMediator mediator = this.getParentContext().getChartMediator();
        mediator.disableMenus(CHART_MENUS);
    }

    protected void warning(String title, String message) {
        Window parentWindow = SwingUtilities.getWindowAncestor(this);
        JOptionPane.showMessageDialog(parentWindow, message, GlobalConstants.getFrameTitle(title), 2);
    }

    @Override
    public List<JTabbedPane> getTabbedPanels() {
        return null;
    }

    @Override
    public boolean update(Object o) {
        return true;
    }

    @Override
    public boolean dispatchChartCommand(IChartCommandAccepter.ChartCommand command) {
        switch (command) {
            case save: {
                return this.save();
            }
            case print: {
                return this.print();
            }
            case letterPaste: {
                return this.pasteMedicationToLetter();
            }
        }
        return false;
    }

    private boolean pasteMedicationToLetter() {
        LetterView letterView;
        if (this.getParentContext() instanceof ChartWindow && ((ChartWindow)this.getParentContext()).existLetterPane() && (letterView = ((ChartWindow)this.getParentContext()).getLetterPane()) != null) {
            String stampName = this.getSelectedHistoryModel().getModuleInfo().getStampName();
            BundleDolphin bundle = (BundleDolphin)this.getSelectedHistoryModel().getModel();
            StringBuilder message = new StringBuilder();
            message.append(letterView.getMedication().getText());
            if (message.length() != 0) {
                message.append(System.getProperty("line.separator"));
            }
            message.append(bundle.toString().replaceFirst(System.getProperty("line.separator"), "(" + stampName + ")" + System.getProperty("line.separator")));
            letterView.getMedication().setText(message.toString());
            return true;
        }
        return false;
    }

    protected class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 4661822065789099499L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Icon icon = this.getOrderIcon((String)value);
            if (icon != null) {
                this.setIcon(icon);
                this.setText((String)value);
            } else {
                this.setText((String)value);
            }
            return this;
        }

        private Icon getOrderIcon(String name) {
            Icon ret = null;
            return ret;
        }
    }
}

