/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.caremapdocument;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import open.dolphin.client.IChartDocument;
import open.dolphin.client.ImageEntry;
import open.dolphin.delegater.remote.RemoteDocumentDelegater;
import open.dolphin.dto.ImageSearchSpec;
import open.dolphin.helper.DBTask;
import open.dolphin.infomodel.SchemaModel;
import open.dolphin.project.GlobalSettings;

public class ImageHistoryPanel
extends JPanel
implements PropertyChangeListener {
    private String pid;
    private IChartDocument myParent;
    private ImageTableModel tModel;
    private JTable table;
    private int columnCount = 5;
    private int imageWidth = 132;
    private int imageHeight = 132;
    private Timer taskTimer;

    public ImageHistoryPanel() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tModel = new ImageTableModel();
        this.table = new JTable(this.tModel);
        this.table.setSelectionMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i = 0; i < this.columnCount; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.imageWidth);
        }
        this.table.setRowHeight(this.imageHeight + 20);
        ImageRenderer imageRenderer = new ImageRenderer();
        imageRenderer.setHorizontalAlignment(0);
        this.table.setDefaultRenderer(Object.class, imageRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point loc = e.getPoint();
                int row = ImageHistoryPanel.this.table.rowAtPoint(loc);
                int col = ImageHistoryPanel.this.table.columnAtPoint(loc);
                if (row != -1 && col != -1) {
                    ImageHistoryPanel.this.openImage(row, col);
                }
            }
        });
        JScrollPane scroller = new JScrollPane(this.table, 20, 31);
        scroller.getViewport().setBackground(GlobalSettings.getColors(GlobalSettings.Parts.TABLE_BACKGROUND));
        this.add((Component)scroller, "Center");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String val) {
        this.pid = val;
    }

    public void setMyParent(IChartDocument doc) {
        this.myParent = doc;
    }

    public void setImageList(List allImages) {
        if (allImages != null) {
            int size = allImages.size();
            ArrayList list = new ArrayList();
            for (int i = 0; i < size; ++i) {
                List l = (List)allImages.get(i);
                if (l == null) continue;
                for (int j = 0; j < l.size(); ++j) {
                    list.add(l.get(j));
                }
            }
            this.tModel.setImageList(list);
        } else {
            this.tModel.setImageList(allImages);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SELECTED_DATE_PROP")) {
            String date = (String)e.getNewValue();
            this.findDate(date);
        }
    }

    private void findDate(String date) {
        int index = this.tModel.findDate(date);
        if (index != -1) {
            int row = index / this.columnCount;
            int col = index % this.columnCount;
            this.table.setRowSelectionInterval(row, row);
            this.table.setColumnSelectionInterval(col, col);
        }
    }

    private void openImage(int row, int col) {
        ImageEntry entry = (ImageEntry)this.tModel.getValueAt(row, col);
        final ImageSearchSpec spec = new ImageSearchSpec();
        spec.setCode(0);
        spec.setId(entry.getId());
        final RemoteDocumentDelegater ddl = new RemoteDocumentDelegater();
        DBTask<SchemaModel> task = new DBTask<SchemaModel>(this.myParent.getParentContext()){

            @Override
            public SchemaModel doInBackground() throws Exception {
                return ddl.getImage(spec.getId());
            }

            @Override
            public void succeeded(SchemaModel result) {
                ImageHistoryPanel.this.openDialog(result);
            }
        };
        task.execute();
    }

    private void openDialog(SchemaModel schema) {
    }

    protected class ImageRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8136363583689791913L;

        public ImageRenderer() {
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component compo = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            JLabel l = (JLabel)compo;
            if (value != null) {
                ImageEntry entry = (ImageEntry)value;
                l.setIcon(entry.getImageIcon());
                l.setText(entry.getConfirmDate().substring(0, 10));
            } else {
                l.setIcon(null);
            }
            return compo;
        }
    }

    protected class ImageTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2683619747572366737L;
        private List imageList;

        protected ImageTableModel() {
        }

        @Override
        public int getColumnCount() {
            return ImageHistoryPanel.this.columnCount;
        }

        @Override
        public int getRowCount() {
            if (this.imageList == null) {
                return 0;
            }
            int size = this.imageList.size();
            int rowCount = size / ImageHistoryPanel.this.columnCount;
            return size % ImageHistoryPanel.this.columnCount != 0 ? rowCount + 1 : rowCount;
        }

        @Override
        public Object getValueAt(int row, int col) {
            int index = row * ImageHistoryPanel.this.columnCount + col;
            if (!this.isValidIndex(index)) {
                return null;
            }
            ImageEntry s = (ImageEntry)this.imageList.get(index);
            return s;
        }

        public void setImageList(List list) {
            int last;
            if (this.imageList != null) {
                last = this.getRowCount();
                this.imageList.clear();
                this.fireTableRowsDeleted(0, last);
            }
            this.imageList = list;
            last = this.getRowCount();
            this.fireTableRowsInserted(0, last);
        }

        private int findDate(String date) {
            int ret = -1;
            if (this.imageList == null) {
                return ret;
            }
            int size = this.imageList.size();
            for (int i = 0; i < size; ++i) {
                ImageEntry entry = (ImageEntry)this.imageList.get(i);
                if (!entry.getConfirmDate().startsWith(date)) continue;
                ret = i;
                break;
            }
            return ret;
        }

        private boolean isValidIndex(int index) {
            return this.imageList != null && index >= 0 && index < this.imageList.size();
        }
    }
}

