/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import open.dolphin.client.IComponentHolder;
import open.dolphin.client.KartePane;
import open.dolphin.client.LocalStampTreeNodeTransferable;
import open.dolphin.client.OrderList;
import open.dolphin.client.OrderListTransferable;
import open.dolphin.client.editor.stamp.StampHolder;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

public class StampHolderTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -9182879162438446790L;

    @Override
    protected Transferable createTransferable(JComponent c) {
        StampHolder source = (StampHolder)c;
        KartePane context = source.getKartePane();
        context.setDrragedStamp(new IComponentHolder[]{source});
        context.setDraggedCount(1);
        ModuleModel stamp = source.getStamp();
        OrderList list = new OrderList(new ModuleModel[]{stamp});
        OrderListTransferable tr = new OrderListTransferable(list);
        return tr;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    private void replaceStamp(final StampHolder target, final ModuleInfoBean stampInfo) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                RemoteStampDelegater sdl = new RemoteStampDelegater();
                StampModel getStamp = sdl.getStamp(stampInfo.getStampId());
                final ModuleModel stamp = new ModuleModel();
                if (getStamp != null) {
                    stamp.setModel(getStamp.toInfoModel());
                    stamp.setModuleInfo(stampInfo);
                }
                Runnable awt = new Runnable(){

                    @Override
                    public void run() {
                        target.importStamp(stamp);
                    }
                };
                EventQueue.invokeLater(awt);
            }
        };
        Thread t = new Thread(r);
        t.setPriority(5);
        t.start();
    }

    private void confirmReplace(StampHolder target, ModuleInfoBean stampInfo) {
        Window w = SwingUtilities.getWindowAncestor(target);
        String replace = "\u7f6e\u304d\u63db\u3048\u308b";
        String cancel = "\u53d6\u6d88\u3057";
        int option = JOptionPane.showOptionDialog(w, "\u30b9\u30bf\u30f3\u30d7\u3092\u7f6e\u304d\u63db\u3048\u307e\u3059\u304b?", "\u30b9\u30bf\u30f3\u30d7 Drag and Drop", -1, 3, null, new String[]{replace, cancel}, replace);
        if (option == 0) {
            this.replaceStamp(target, stampInfo);
        }
    }

    @Override
    public boolean importData(JComponent c, Transferable tr) {
        if (this.canImport(c, tr.getTransferDataFlavors())) {
            final StampHolder target = (StampHolder)c;
            StampTreeNode droppedNode = null;
            try {
                droppedNode = (StampTreeNode)tr.getTransferData(LocalStampTreeNodeTransferable.localStampTreeNodeFlavor);
            }
            catch (Exception e) {
                LogWriter.error(this.getClass(), e);
                return false;
            }
            if (droppedNode == null || !droppedNode.isLeaf()) {
                return false;
            }
            final ModuleInfoBean stampInfo = droppedNode.getStampInfo();
            String role = stampInfo.getStampRole();
            if (!role.equals("p")) {
                return false;
            }
            if (GlobalVariables.getPreferences().getBoolean("replaceStamp", false)) {
                this.replaceStamp(target, stampInfo);
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        StampHolderTransferHandler.this.confirmReplace(target, stampInfo);
                    }
                };
                EventQueue.invokeLater(r);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable tr, int action) {
        StampHolder test = (StampHolder)c;
        KartePane context = test.getKartePane();
        if (action == 2 && context.getDrragedStamp() != null && context.getDraggedCount() == context.getDroppedCount()) {
            context.removeStamp(test);
        }
        context.setDrragedStamp(null);
        context.setDraggedCount(0);
        context.setDroppedCount(0);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        StampHolder test = (StampHolder)c;
        JTextPane tc = test.getKartePane().getTextPane();
        return tc.isEditable() && this.hasFlavor(flavors);
    }

    protected boolean hasFlavor(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!LocalStampTreeNodeTransferable.localStampTreeNodeFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        KartePane kartePane;
        StampHolder sh = (StampHolder)comp;
        Transferable tr = this.createTransferable(comp);
        clip.setContents(tr, null);
        if (action == 2 && (kartePane = sh.getKartePane()).getTextPane().isEditable()) {
            kartePane.removeStamp(sh);
        }
    }
}

