/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.stamp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import open.dolphin.client.MouseDragDetecter;
import open.dolphin.client.TreeInfo;
import open.dolphin.client.editor.stamp.StampBoxFrame;
import open.dolphin.client.editor.stamp.StampTreeNode;
import open.dolphin.delegater.remote.RemoteStampDelegater;
import open.dolphin.infomodel.BundleDolphin;
import open.dolphin.infomodel.ClaimBundle;
import open.dolphin.infomodel.IInfoModel;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.MedicineEntry;
import open.dolphin.infomodel.ModuleInfoBean;
import open.dolphin.infomodel.ModuleModel;
import open.dolphin.infomodel.RegisteredDiagnosisModel;
import open.dolphin.infomodel.StampModel;
import open.dolphin.infomodel.TextStampModel;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalConstants;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.CombinedStringParser;
import open.dolphin.utils.GUIDGenerator;

public class StampTree
extends JTree
implements TreeModelListener {
    public static final String SELECTED_NODE_PROP = "selectedNodeProp";
    private static final long serialVersionUID = -4651151848166376384L;
    private static final int TOOLTIP_LENGTH = 35;
    private static final ImageIcon ASP_ICON = GlobalConstants.getImageIcon("move2_16.gif");
    private static final ImageIcon LOCAL_ICON = GlobalConstants.getImageIcon("move2_16.gif");
    private static final String NEW_FOLDER_NAME = "\u65b0\u898f\u30d5\u30a9\u30eb\u30c0";
    private static final String STAMP_SAVE_TASK_NAME = "\u30b9\u30bf\u30f3\u30d7\u4fdd\u5b58";
    private boolean asp;
    private boolean userTree;
    private StampBoxFrame stampBox;

    public StampTree(TreeModel model) {
        super(model);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.addMouseMotionListener(new MouseDragDetecter());
        final RemoteStampDelegater delegater = new RemoteStampDelegater();
        final TreeCellRenderer oldRenderer = this.getCellRenderer();
        TreeCellRenderer r = new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component cellRenderer = oldRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (leaf && cellRenderer instanceof JLabel) {
                    JLabel label = (JLabel)cellRenderer;
                    Object moduleInfo = ((StampTreeNode)value).getUserObject();
                    if (moduleInfo instanceof ModuleInfoBean) {
                        if (StampTree.this.isAsp()) {
                            label.setIcon(ASP_ICON);
                        } else {
                            label.setIcon(LOCAL_ICON);
                        }
                        label.setToolTipText(((ModuleInfoBean)moduleInfo).getStampMemo());
                        CombinedStringParser combinedName = new CombinedStringParser(((ModuleInfoBean)moduleInfo).getStampName());
                        label.setText(combinedName.toPlainString());
                        ArrayList<MedicineEntry> updates = new ArrayList<MedicineEntry>();
                        GregorianCalendar gc = new GregorianCalendar();
                        ModuleInfoBean infoBean = (ModuleInfoBean)moduleInfo;
                        if (infoBean.getStampId() != null && !infoBean.getStampRole().equals("orcaSet")) {
                            StampModel stampModel = delegater.getStamp(infoBean.getStampId());
                            if (stampModel != null) {
                                IInfoModel stamp;
                                if (stampModel.getStampBytes().length != 0 && (stamp = stampModel.toInfoModel()) instanceof BundleDolphin) {
                                    ClaimBundle.Enabled enabled = ((BundleDolphin)stamp).getStampEnabled(updates, gc);
                                    label.setForeground(StampTree.this.getStampColor(enabled));
                                }
                            } else {
                                label.setForeground(StampTree.this.getStampColor(ClaimBundle.Enabled.DELETED));
                            }
                        }
                    }
                }
                return cellRenderer;
            }
        };
        this.setCellRenderer(r);
        model.addTreeModelListener(this);
        this.enableToolTips(true);
    }

    private Color getStampColor(ClaimBundle.Enabled enabled) {
        Color result;
        switch (enabled) {
            case NORMAL: {
                result = Color.black;
                break;
            }
            case OUT_OF_DATE: {
                result = Color.gray;
                break;
            }
            case UPDATE_AVAILABLE: {
                result = Color.red;
                break;
            }
            case DELETED: {
                result = Color.magenta;
                break;
            }
            default: {
                result = Color.black;
            }
        }
        return result;
    }

    public TreeInfo getTreeInfo() {
        StampTreeNode node = (StampTreeNode)this.getModel().getRoot();
        TreeInfo info = (TreeInfo)node.getUserObject();
        return info;
    }

    public String getEntity() {
        return this.getTreeInfo().getEntity();
    }

    public String getTreeName() {
        return this.getTreeInfo().getName();
    }

    private boolean isUserTree() {
        return this.userTree;
    }

    public void setUserTree(boolean userTree) {
        this.userTree = userTree;
    }

    private boolean isAsp() {
        return this.asp;
    }

    public void setAsp(boolean asp) {
        this.asp = asp;
    }

    private void enableToolTips(boolean state2) {
        ToolTipManager mgr = ToolTipManager.sharedInstance();
        if (state2) {
            mgr.registerComponent(this);
        } else {
            mgr.unregisterComponent(this);
        }
    }

    public void setStampBox(StampBoxFrame stampBox) {
        this.stampBox = stampBox;
    }

    private StampTreeNode getSelectedNode() {
        return (StampTreeNode)this.getLastSelectedPathComponent();
    }

    private StampTreeNode getNode(Point p) {
        TreePath path = this.getPathForLocation(p.x, p.y);
        return path != null ? (StampTreeNode)path.getLastPathComponent() : null;
    }

    public void enter() {
    }

    public boolean addStamp(ModuleModel droppedStamp, StampTreeNode selected) throws SQLException {
        if (droppedStamp != null) {
            IStampInfo droppedInfo = droppedStamp.getModuleInfo();
            String extent = "";
            StampModel stampModel = new StampModel();
            String stampId = GUIDGenerator.generate(stampModel);
            stampModel.initialize(stampId, GlobalVariables.getUserModel().getId(), droppedInfo.getEntity(), this.getXMLBytes(droppedStamp.getModel()));
            ModuleInfoBean info = new ModuleInfoBean();
            info.initialize(stampId, droppedInfo.getStampName() + extent, this.constractToolTip(droppedStamp), droppedInfo.getEntity(), droppedInfo.getStampRole());
            RemoteStampDelegater stampDelegater = new RemoteStampDelegater();
            String result = stampDelegater.putStamp(stampModel);
            if (!stampDelegater.isError() && result.equals(stampId)) {
                this.addInfoToTree(info, selected);
            }
            return true;
        }
        return false;
    }

    private StampTreeNode findNode(StampTreeNode root, String name) {
        int childCount = root.getChildCount();
        for (int index = 0; index < childCount; ++index) {
            StampTreeNode currentNode = (StampTreeNode)root.getChildAt(index);
            if (!currentNode.isLeaf() || !name.equals(currentNode.getStampInfo().getStampName())) continue;
            return currentNode;
        }
        return null;
    }

    private String createAlternateName(String name, int index) {
        return name + '(' + Integer.toString(index) + ')';
    }

    private void setAlternateName(StampTreeNode root, StampTreeNode node) {
        String initialNodeName;
        int nameExtent = 0;
        String nodeName = initialNodeName = ((ModuleInfoBean)node.getUserObject()).getStampName();
        while (this.findNode(root, nodeName) != null) {
            nodeName = this.createAlternateName(initialNodeName, ++nameExtent);
            ((ModuleInfoBean)node.getUserObject()).setStampName(nodeName);
        }
        return;
    }

    private void addInfoToTree(ModuleInfoBean info, StampTreeNode selected) {
        StampTreeNode node = new StampTreeNode(info);
        if (selected != null && selected.isLeaf()) {
            StampTreeNode newParent = (StampTreeNode)selected.getParent();
            int index = newParent.getIndex(selected);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            StampTreeNode root = (StampTreeNode)model.getRoot();
            this.setAlternateName(root, node);
            model.insertNodeInto(node, newParent, index);
            Object[] path = model.getPathToRoot(node);
            this.setSelectionPath(new TreePath(path));
        } else if (selected != null && !selected.isLeaf()) {
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            StampTreeNode root = (StampTreeNode)model.getRoot();
            this.setAlternateName(root, node);
            model.insertNodeInto(node, selected, selected.getChildCount());
            Object[] path = model.getPathToRoot(node);
            this.setSelectionPath(new TreePath(path));
        } else {
            StampTree another = this.stampBox.getStampTree(info.getEntity());
            boolean myTree = another == this;
            final String treeName = another.getTreeName();
            DefaultTreeModel model = (DefaultTreeModel)another.getModel();
            StampTreeNode root = (StampTreeNode)model.getRoot();
            this.setAlternateName(root, node);
            root.add(node);
            model.reload(root);
            Object[] path = model.getPathToRoot(node);
            this.setSelectionPath(new TreePath(path));
            if (!myTree) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder buf = new StringBuilder();
                        buf.append("\u30b9\u30bf\u30f3\u30d7\u306f\u500b\u4eba\u7528\u306e ");
                        buf.append(treeName);
                        buf.append(" \u306b\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
                        JOptionPane.showMessageDialog(StampTree.this, buf.toString(), GlobalConstants.getFrameTitle(StampTree.STAMP_SAVE_TASK_NAME), 1);
                    }
                });
            }
        }
    }

    public boolean addDiagnosis(RegisteredDiagnosisModel rd, StampTreeNode selected) throws SQLException {
        if (rd != null) {
            rd.setId(0L);
            rd.setKarte(null);
            rd.setCreator(null);
            rd.setDiagnosisCategoryModel(null);
            rd.setDiagnosisOutcomeModel(null);
            rd.setFirstEncounterDate(null);
            rd.setStartDate(null);
            rd.setEndDate(null);
            rd.setRelatedHealthInsurance(null);
            rd.setFirstConfirmDate(null);
            rd.setConfirmDate(null);
            rd.setStatus(null);
            rd.setPatientLiteModel(null);
            rd.setUserLiteModel(null);
            RegisteredDiagnosisModel add = new RegisteredDiagnosisModel();
            add.setDiagnosis(rd.getDiagnosis());
            add.setDiagnosisCode(rd.getDiagnosisCode());
            add.setDiagnosisCodeSystem(rd.getDiagnosisCodeSystem());
            ModuleModel stamp = new ModuleModel();
            stamp.setModel(add);
            StampModel addStamp = new StampModel();
            String stampId = GUIDGenerator.generate(addStamp);
            addStamp.initialize(stampId, GlobalVariables.getUserModel().getId(), "diagnosis", this.getXMLBytes(stamp.getModel()));
            ModuleInfoBean info = new ModuleInfoBean();
            info.initialize(stampId, add.getDiagnosis(), null, "diagnosis", "diagnosis");
            StringBuilder buf = new StringBuilder();
            buf.append(add.getDiagnosis());
            String cd = add.getDiagnosisCode();
            if (cd != null) {
                buf.append("(");
                buf.append(cd);
                buf.append(")");
            }
            info.setStampMemo(buf.toString());
            RemoteStampDelegater sdl = new RemoteStampDelegater();
            String result = sdl.putStamp(addStamp);
            if (!sdl.isError() && result.equals(stampId)) {
                this.addInfoToTree(info, selected);
            }
            return true;
        }
        return false;
    }

    public void addDiagnosis(List<RegisteredDiagnosisModel> list) throws SQLException {
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<StampModel> stampList = new ArrayList<StampModel>();
        ArrayList<ModuleInfoBean> infoList = new ArrayList<ModuleInfoBean>();
        for (RegisteredDiagnosisModel rd : list) {
            rd.clear();
            RegisteredDiagnosisModel diagnosisModel = new RegisteredDiagnosisModel(rd);
            ModuleModel stamp = new ModuleModel(diagnosisModel);
            StampModel addStamp = new StampModel();
            String stampId = GUIDGenerator.generate(addStamp);
            addStamp.initialize(stampId, GlobalVariables.getUserModel().getId(), "diagnosis", this.getXMLBytes(stamp.getModel()));
            stampList.add(addStamp);
            ModuleInfoBean info = new ModuleInfoBean();
            info.initialize(stampId, diagnosisModel.getDiagnosis(), null, "diagnosis", "diagnosis");
            StringBuilder buf = new StringBuilder();
            buf.append(diagnosisModel.getDiagnosis());
            String cd = diagnosisModel.getDiagnosisCode();
            if (cd != null) {
                buf.append("(");
                buf.append(cd);
                buf.append(")");
            }
            info.setStampMemo(buf.toString());
            infoList.add(info);
        }
        RemoteStampDelegater sdl = new RemoteStampDelegater();
        sdl.putStamp(stampList);
        if (!sdl.isError()) {
            for (ModuleInfoBean info : infoList) {
                this.addInfoToTree(info, null);
            }
        }
    }

    public boolean addTextStamp(String text, StampTreeNode selected) throws SQLException {
        if (text == null || text.length() == 0 || text.equals("")) {
            return false;
        }
        TextStampModel stamp = new TextStampModel();
        stamp.initialize(text);
        StampModel newStamp = new StampModel();
        String stampId = GUIDGenerator.generate(newStamp);
        newStamp.initialize(stampId, GlobalVariables.getUserModel().getId(), "text", this.getXMLBytes(stamp));
        ModuleInfoBean info = new ModuleInfoBean();
        int len = text.length() > 16 ? 16 : text.length();
        String name = text.substring(0, len);
        len = name.indexOf("\n");
        if (len > 0) {
            name = name.substring(0, len);
        }
        info.initialize(stampId, name, text, "text", "text");
        RemoteStampDelegater delegater = new RemoteStampDelegater();
        String result = delegater.putStamp(newStamp);
        if (!delegater.isError() && result.equals(stampId)) {
            this.addInfoToTree(info, selected);
        }
        return true;
    }

    protected String constractToolTip(ModuleModel stamp) {
        String result = null;
        try {
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader(new StringReader(stamp.getModel().toString()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                if (buf.length() >= 35) break;
                buf.append(",");
            }
            reader.close();
            if (buf.length() > 35) {
                buf.setLength(35);
            }
            buf.append("...");
            result = buf.toString();
        }
        catch (IOException e) {
            e.toString();
        }
        return result;
    }

    private void warning(String message) {
        JOptionPane.showMessageDialog(this, message, GlobalConstants.getFrameTitle("\u30b9\u30bf\u30f3\u30d7"), 2);
    }

    public void renameNode() {
        if (this.isUserTree()) {
            StampTreeNode node = this.getSelectedNode();
            if (node == null) {
                return;
            }
            Object[] nodes = node.getPath();
            TreePath path = new TreePath(nodes);
            this.setEditable(true);
            this.startEditingAtPath(path);
        }
    }

    public void deleteNode() {
        if (this.isUserTree()) {
            StampTreeNode theNode = this.getSelectedNode();
            if (theNode == null) {
                return;
            }
            Enumeration<TreeNode> e = theNode.preorderEnumeration();
            ArrayList<String> deleteList = new ArrayList<String>();
            boolean hasEditor = false;
            while (e.hasMoreElements()) {
                StampTreeNode node = (StampTreeNode)e.nextElement();
                if (!node.isLeaf()) continue;
                ModuleInfoBean info = (ModuleInfoBean)node.getUserObject();
                String stampId = info.getStampId();
                if (info.getStampName().equals("\u30a8\u30c7\u30a3\u30bf\u304b\u3089\u767a\u884c") && !info.isSerialized()) {
                    hasEditor = true;
                    break;
                }
                if (stampId == null) continue;
                deleteList.add(stampId);
            }
            if (hasEditor) {
                String msg0 = "\u30a8\u30c7\u30a3\u30bf\u304b\u3089\u767a\u884c\u306f\u6d88\u53bb\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a9\u30eb\u30c0\u306b\u542b\u307e\u308c\u3066\u3044\u308b";
                String msg1 = "\u5834\u5408\u306f Drag & Drop \u3067\u79fb\u52d5\u5f8c\u3001\u518d\u5ea6\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
                String taskTitle = "\u30b9\u30bf\u30f3\u30d7";
                JOptionPane.showMessageDialog(null, new Object[]{msg0, msg1}, GlobalConstants.getFrameTitle(taskTitle), 1);
                return;
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.removeNodeFromParent(theNode);
        }
    }

    public void createNewFolder() {
        if (this.isUserTree()) {
            StampTreeNode folder = new StampTreeNode(NEW_FOLDER_NAME);
            StampTreeNode selected = this.getSelectedNode();
            if (selected != null && selected.isLeaf()) {
                StampTreeNode newParent = (StampTreeNode)selected.getParent();
                int index = newParent.getIndex(selected);
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.insertNodeInto(folder, newParent, index);
            } else if (selected != null && !selected.isLeaf()) {
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                model.insertNodeInto(folder, selected, selected.getChildCount());
            }
        }
    }

    private void moveTo(StampTreeNode parentNode, StampTreeNode sourceNode, StampTreeNode targetNode) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (parentNode != null && sourceNode != null && targetNode != null && sourceNode.isMoveable() && targetNode.isMoveable()) {
            int index = parentNode.getIndex(targetNode);
            model.removeNodeFromParent(sourceNode);
            model.insertNodeInto(sourceNode, parentNode, index);
        }
    }

    public void moveUp() {
        if (this.isUserTree()) {
            StampTreeNode selectedNode = this.getSelectedNode();
            StampTreeNode parentNode = (StampTreeNode)selectedNode.getParent();
            StampTreeNode prevNode = (StampTreeNode)parentNode.getChildBefore(selectedNode);
            this.moveTo(parentNode, selectedNode, prevNode);
        }
    }

    public void moveDown() {
        if (this.isUserTree()) {
            StampTreeNode selectedNode = this.getSelectedNode();
            StampTreeNode parentNode = (StampTreeNode)selectedNode.getParent();
            StampTreeNode nextNode = (StampTreeNode)parentNode.getChildAfter(selectedNode);
            this.moveTo(parentNode, selectedNode, nextNode);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.setEditable(false);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    private byte[] getXMLBytes(Object bean) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(bo));
        e.writeObject(bean);
        e.close();
        return bo.toByteArray();
    }

    public void saveStampTree() {
        RemoteStampDelegater sdl = new RemoteStampDelegater();
        IStampTreeModel _treeModel = this.stampBox.getUserStampBox().getStampTreeModel();
        _treeModel.setTreeXml(this.stampBox.getStampTree());
        sdl.putTree(_treeModel);
        if (sdl.isError()) {
            LogWriter.error(this.getClass(), sdl.getErrorMessage());
        }
    }
}

