/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.editor.treatment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import open.dolphin.client.MasterRenderer;
import open.dolphin.client.TaskTimerMonitor;
import open.dolphin.dao.SqlDaoFactory;
import open.dolphin.dao.SqlMasterDao;
import open.dolphin.infomodel.MasterItem;
import open.dolphin.infomodel.TreatmentEntry;
import open.dolphin.log.LogWriter;
import open.dolphin.order.AbstractMasterPanel;
import open.dolphin.project.GlobalConstants;
import open.dolphin.table.ObjectTableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;

public class TreatmentMasterPanel
extends AbstractMasterPanel {
    private static final long serialVersionUID = -4833490720433639368L;
    private static final String[] treatmentColumns = new String[]{"\u30b3\u30fc\u30c9", "\u540d  \u79f0", "\u6b63\u5f0f\u540d\u79f0", "\u70b9\u6570\u8b58\u5225", "\u70b9\u6570/\u91d1\u984d", "\u5165\u5916", "\u793e\u8001", "\u75c5\u8a3a", "\u958b\u59cb\u5e74\u6708\u65e5", "\u7d42\u4e86\u5e74\u6708\u65e5"};
    private static final String[] treatmentCostFlags = new String[]{"\u5ec3", "\u91d1", "", "+\u70b9", "\u90fd", "%\u52a0", "%\u6e1b", "\u6e1b", "-\u70b9"};
    private static final String[] inOutFlags = new String[]{"\u5165\u5916", "\u5165", "\u5916"};
    private static final String[] hospClinicFlags = new String[]{"\u75c5\u8a3a", "\u75c5", "\u8a3a"};
    private static final String[] oldFlags = new String[]{"\u793e\u8001", "\u793e", "\u8001"};
    private static final String[] sortColumnNames = new String[]{"srycd", "name", "formalname", "tensikibetu", "ten", "nyugaitekkbn", "routekkbn", "srysyukbn", "yukostymd", "yukoedymd"};
    private JButton categoryButton;
    private JButton radLOcationButton;
    private JPanel category;
    private JPanel key;
    private JScrollPane scroller;
    private JTable table;
    private JPanel top;

    public TreatmentMasterPanel(String master) {
        super(master);
    }

    @Override
    protected void initialize() {
        this.initComponents();
        this.categoryButton = new JButton("\u5168\u691c\u7d22");
        this.categoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreatmentMasterPanel.this.getByClaimClass();
            }
        });
        this.radLOcationButton = new JButton("\u753b\u50cf\u8a3a\u65ad\u90e8\u4f4d");
        this.radLOcationButton.setEnabled(false);
        this.radLOcationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreatmentMasterPanel.this.getRadLocation();
            }
        });
        this.tableModel = new ObjectTableModel(treatmentColumns, 20){
            private static final long serialVersionUID = 8084360322119845887L;

            public Class getColumnClass(int col) {
                return TreatmentEntry.class;
            }
        };
        this.table.setModel(this.tableModel);
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreatmentMasterPanel.this.doSort(e);
            }
        });
        TableColumn column = null;
        int[] width = new int[]{50, 150, 150, 30, 50, 30, 30, 30, 50};
        int len = width.length;
        for (int i = 0; i < len; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(width[i]);
        }
        TreatmentMasterRenderer tr = new TreatmentMasterRenderer();
        tr.setBeforStartColor(masterColors[0]);
        tr.setInUseColor(masterColors[1]);
        tr.setAfterEndColor(masterColors[2]);
        tr.setCostFlag(treatmentCostFlags);
        tr.setInOutFlag(inOutFlags);
        tr.setOldFlag(oldFlags);
        tr.setHospitalClinicFlag(hospClinicFlags);
        this.table.setDefaultRenderer(TreatmentEntry.class, tr);
        this.key.setLayout(new FlowLayout(0, 5, 5));
        this.key.add(this.findLabel);
        this.key.add(new JLabel(masterTabNames[4] + ":"));
        this.key.add(this.keywordField);
        this.key.add(this.isForwordCheckBox);
        this.key.setBorder(BorderFactory.createTitledBorder("\u30ad\u30fc\u30ef\u30fc\u30c9\u691c\u7d22"));
        this.category.setLayout(new BoxLayout(this.category, 0));
        this.category.add(this.categoryButton);
        this.category.add(Box.createHorizontalStrut(5));
        this.category.add(this.radLOcationButton);
        this.category.setBorder(BorderFactory.createTitledBorder("\u30ab\u30c6\u30b4\u30ea"));
        this.top.setLayout(new BoxLayout(this.top, 0));
        this.top.add(Box.createHorizontalStrut(7));
        this.setLayout(new BorderLayout(0, 11));
        this.add((Component)this.top, "North");
        this.add((Component)this.scroller, "Center");
    }

    @Override
    public void setSearchClass(String searchClass) {
        this.searchClass = searchClass;
        if (this.searchClass == null) {
            this.categoryButton.setEnabled(false);
        } else {
            this.categoryButton.setEnabled(true);
        }
    }

    public void setRadLocationEnabled(boolean enabled) {
        this.radLOcationButton.setEnabled(enabled);
    }

    private void getByClaimClass() {
        final SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        Task<List<TreatmentEntry>, Void> task = new Task<List<TreatmentEntry>, Void>(app){

            protected List<TreatmentEntry> doInBackground() throws Exception {
                List<TreatmentEntry> result = dao.getByClaimClassFromOrca(TreatmentMasterPanel.this.master, TreatmentMasterPanel.this.searchClass, TreatmentMasterPanel.this.sortBy, TreatmentMasterPanel.this.order);
                return result;
            }

            protected void succeeded(List<TreatmentEntry> result) {
                TreatmentMasterPanel.this.processResult(dao.isNoError(), result, dao.getErrorMessage());
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        String message = "\u8a3a\u7642\u884c\u70ba\u691c\u7d22";
        String note = this.searchClass + "\u3092\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...";
        Window c = SwingUtilities.getWindowAncestor(this);
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, note, 200, 60000);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        appCtx.getTaskService().execute((Task)task);
    }

    private void getRadLocation() {
        final SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
        ApplicationContext appCtx = GlobalConstants.getApplicationContext();
        Application app = appCtx.getApplication();
        Task<List<TreatmentEntry>, Void> task = new Task<List<TreatmentEntry>, Void>(app){

            protected List<TreatmentEntry> doInBackground() throws Exception {
                List<TreatmentEntry> result = dao.getRadLocationFromOrca(TreatmentMasterPanel.this.master, TreatmentMasterPanel.this.sortBy, TreatmentMasterPanel.this.order);
                return result;
            }

            protected void succeeded(List<TreatmentEntry> result) {
                TreatmentMasterPanel.this.processResult(dao.isNoError(), result, dao.getErrorMessage());
            }

            protected void cancelled() {
            }

            protected void failed(Throwable cause) {
            }

            protected void interrupted(InterruptedException e) {
            }
        };
        TaskMonitor taskMonitor = appCtx.getTaskMonitor();
        String message = "\u753b\u50cf\u8a3a\u65ad\u90e8\u4f4d\u691c\u7d22";
        String note = this.searchClass + "\u691c\u7d22\u3057\u3066\u3044\u307e\u3059...";
        Window c = SwingUtilities.getWindowAncestor(this);
        TaskTimerMonitor w = new TaskTimerMonitor((Task)task, taskMonitor, c, message, note, 200, 60000);
        taskMonitor.addPropertyChangeListener((PropertyChangeListener)w);
        appCtx.getTaskService().execute((Task)task);
    }

    private void doSort(MouseEvent e) {
        int viewColumn = this.table.getTableHeader().columnAtPoint(e.getPoint());
        int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
        this.setSortBy(sortColumnNames[modelColumn]);
        String _key = this.keywordField.getText().trim();
        this.search(_key, !this.isForwordCheckBox.isSelected());
    }

    private void initComponents() {
        this.scroller = new JScrollPane();
        this.table = new JTable();
        this.top = new JPanel();
        this.category = new JPanel();
        this.key = new JPanel();
        this.scroller.setName("scroller");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setName("table");
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TreatmentMasterPanel.this.tableMouseClicked(evt);
            }
        });
        this.scroller.setViewportView(this.table);
        this.top.setName("top");
        this.category.setName("category");
        GroupLayout categoryLayout = new GroupLayout(this.category);
        this.category.setLayout(categoryLayout);
        categoryLayout.setHorizontalGroup(categoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 174, Short.MAX_VALUE));
        categoryLayout.setVerticalGroup(categoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 34, Short.MAX_VALUE));
        this.key.setName("key");
        GroupLayout keyLayout = new GroupLayout(this.key);
        this.key.setLayout(keyLayout);
        keyLayout.setHorizontalGroup(keyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 297, Short.MAX_VALUE));
        keyLayout.setVerticalGroup(keyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 34, Short.MAX_VALUE));
        GroupLayout topLayout = new GroupLayout(this.top);
        this.top.setLayout(topLayout);
        topLayout.setHorizontalGroup(topLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, topLayout.createSequentialGroup().addContainerGap().addComponent(this.key, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.category, -2, -1, -2).addContainerGap()));
        topLayout.setVerticalGroup(topLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topLayout.createSequentialGroup().addContainerGap().addGroup(topLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.key, -2, -1, -2).addComponent(this.category, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.top, -1, -1, Short.MAX_VALUE).addComponent(this.scroller, -1, 502, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.top, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroller, -1, 154, Short.MAX_VALUE)));
    }

    private void tableMouseClicked(MouseEvent evt) {
        int row;
        TreatmentEntry o;
        if (evt.getClickCount() == 2 && (o = (TreatmentEntry)this.tableModel.getObject(row = this.table.getSelectedRow())) != null && o.useState(new GregorianCalendar()) != 2) {
            MasterItem mItem = new MasterItem(0, o);
            mItem.setClaimClassCode(o.getClaimClassCode());
            mItem.setSstKijunCdSet(o.getSstKijunCdSet());
            SqlMasterDao dao = (SqlMasterDao)SqlDaoFactory.create("dao.master");
            switch (dao.IsAutoCulcFromOrca(mItem.getCode())) {
                case NORMAL: {
                    this.setSelectedItem(mItem);
                    break;
                }
                case KENSA: {
                    this.setSelectedItem(mItem);
                    break;
                }
                case AUTO: {
                    if (JOptionPane.showConfirmDialog(null, "\u81ea\u52d5\u7b97\u5b9a\u9805\u76ee\u3067\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) != 0) break;
                    this.setSelectedItem(mItem);
                    break;
                }
                default: {
                    this.setSelectedItem(mItem);
                }
            }
        }
    }

    protected final class TreatmentMasterRenderer
    extends MasterRenderer {
        private static final long serialVersionUID = -23933027994436326L;
        private final int CODE_COLUMN = 0;
        private final int NAME_COLUMN = 1;
        private final int KANA_COLUMN = 2;
        private final int COST_FLAG_COLUMN = 3;
        private final int COST_COLUMN = 4;
        private final int INOUT_COLUMN = 5;
        private final int OLD_COLUMN = 6;
        private final int HOSP_CLINIC_COLUMN = 7;
        private final int START_COLUMN = 8;
        private final int END_COLUMN = 9;
        private String[] costFlags;
        private String[] inOutFlags;
        private String[] oldFlags;
        private String[] hospitalClinicFlags;

        public String[] getCostFlag() {
            return this.costFlags;
        }

        public void setCostFlag(String[] val) {
            this.costFlags = val;
        }

        public String[] getInOutFlag() {
            return this.inOutFlags;
        }

        public void setInOutFlag(String[] val) {
            this.inOutFlags = val;
        }

        public String[] getOldFlag() {
            return this.oldFlags;
        }

        public void setOldFlag(String[] val) {
            this.oldFlags = val;
        }

        public String[] getHospitalClinicFlag() {
            return this.hospitalClinicFlags;
        }

        public void setHospitalClinicFlag(String[] val) {
            this.hospitalClinicFlags = val;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, col);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            JLabel label = (JLabel)c;
            if (value != null && value instanceof TreatmentEntry) {
                TreatmentEntry entry = (TreatmentEntry)value;
                String startDate = entry.getStartDate();
                String endDate = entry.getEndDate();
                this.setColor(label, startDate, endDate);
                String tmp = null;
                switch (col) {
                    case 0: {
                        label.setText(entry.getCode());
                        break;
                    }
                    case 1: {
                        label.setText(entry.getName());
                        break;
                    }
                    case 2: {
                        label.setText(entry.getKana());
                        break;
                    }
                    case 3: {
                        tmp = entry.getCostFlag();
                        if (tmp != null) {
                            try {
                                int index = Integer.parseInt(tmp);
                                label.setText(this.costFlags[index]);
                            }
                            catch (Exception e) {
                                LogWriter.error(this.getClass(), "", (Throwable)e);
                                label.setText("");
                            }
                            break;
                        }
                        label.setText("");
                        break;
                    }
                    case 4: {
                        label.setText(entry.getCost());
                        break;
                    }
                    case 5: {
                        tmp = entry.getInOutFlag();
                        if (tmp != null) {
                            try {
                                int index = Integer.parseInt(tmp);
                                label.setText(this.inOutFlags[index]);
                            }
                            catch (Exception e) {
                                label.setText("");
                                LogWriter.error(this.getClass(), "", (Throwable)e);
                            }
                            break;
                        }
                        label.setText("");
                        break;
                    }
                    case 6: {
                        tmp = entry.getOldFlag();
                        if (tmp != null) {
                            try {
                                int index = Integer.parseInt(tmp);
                                label.setText(this.oldFlags[index]);
                            }
                            catch (Exception e) {
                                label.setText("");
                                LogWriter.error(this.getClass(), "", (Throwable)e);
                            }
                            break;
                        }
                        label.setText("");
                        break;
                    }
                    case 7: {
                        tmp = entry.getHospitalClinicFlag();
                        if (tmp != null) {
                            try {
                                int index = Integer.parseInt(tmp);
                                label.setText(this.hospitalClinicFlags[index]);
                            }
                            catch (Exception e) {
                                label.setText("");
                                LogWriter.error(this.getClass(), "", (Throwable)e);
                            }
                            break;
                        }
                        label.setText("");
                        break;
                    }
                    case 8: {
                        if (startDate.startsWith("0")) {
                            label.setText("");
                            break;
                        }
                        label.setText(startDate);
                        break;
                    }
                    case 9: {
                        if (endDate.startsWith("9")) {
                            label.setText("");
                            break;
                        }
                        label.setText(endDate);
                        break;
                    }
                    default: {
                        LogWriter.fatal(this.getClass(), "case default");
                        break;
                    }
                }
            } else {
                label.setText(value == null ? "" : value.toString());
            }
            return c;
        }
    }
}

