/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte.template;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import open.dolphin.client.karte.template.Template;
import open.dolphin.client.karte.template.TemplateHeader;
import open.dolphin.client.karte.template.error.CantWriteTemplateException;
import open.dolphin.log.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TemplateBuilder {
    private Document root;

    public TemplateBuilder() {
        this.createNewDocument();
        this.buildTemplateAsXml();
    }

    public void setBody(String templateBody) {
        Element body = this.getElementByTagName("body");
        this.clearBody(body);
        this.setDocumentToBody(body, templateBody);
    }

    public String getBody() {
        Element body = this.getElementByTagName("body");
        return body.getTextContent();
    }

    public void setHeader(TemplateHeader templateHeader) {
        Element header = this.getElementByTagName("header");
        this.clearHeader(header);
        this.setNameToHeader(header, templateHeader.getName());
        this.setCreatorToHeader(header, templateHeader.getCreator());
    }

    public TemplateHeader getHeader() {
        TemplateHeader header = new TemplateHeader();
        Element templateHeader = this.getElementByTagName("header");
        header.setName(this.getNameFromHeader(templateHeader));
        header.setCreator(this.getCreatorFromHeader(templateHeader));
        return header;
    }

    public Document getRoot() {
        if (this.root == null) {
            this.createNewDocument();
        }
        return this.root;
    }

    public void setRoot(Document root) {
        this.root = root;
    }

    public String getString() throws CantWriteTemplateException {
        StringWriter writer = new StringWriter();
        StreamResult streamResult = this.outputDocumentTo(writer);
        return streamResult.getWriter().toString();
    }

    public StreamResult outputDocumentTo(Writer writer) throws CantWriteTemplateException {
        File xslPath = new File(this.getClass().getResource("/open/dolphin/resources/style.xsl").getPath());
        StreamSource xslSource = new StreamSource(xslPath);
        StreamResult streamResult = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer former = factory.newTransformer(xslSource);
            former.transform(new DOMSource(this.getRoot().getDocumentElement()), streamResult);
        }
        catch (TransformerConfigurationException e) {
            throw new CantWriteTemplateException(e);
        }
        catch (TransformerException e) {
            throw new CantWriteTemplateException(e);
        }
        return streamResult;
    }

    private Element getElementByTagName(String name) {
        return (Element)this.getRoot().getElementsByTagName(name).item(0);
    }

    private Element getTemplateElement() {
        return this.getElementByTagName("template");
    }

    private void clearHeader(Element header) {
        if (header.hasChildNodes()) {
            this.removeChild(header, "name");
            this.removeChild(header, "creator");
        }
    }

    private void clearBody(Element body) {
        if (body.hasChildNodes()) {
            this.getTemplateElement().removeChild(body);
            this.addBodyToXml();
        }
    }

    private void removeChild(Element target, String name) {
        Element element = this.getElementByTagName(name);
        if (element != null) {
            target.removeChild(element);
        }
    }

    private void setDocumentToBody(Element body, String data) {
        body.appendChild(this.getRoot().createCDATASection(data));
    }

    private Element createTextChild(String nodeName, String text) {
        Element element = this.getRoot().createElement(nodeName);
        element.appendChild(this.getRoot().createTextNode(text));
        return element;
    }

    private String getNameFromHeader(Element header) {
        return this.getElementByTagName("name").getTextContent();
    }

    private void setNameToHeader(Element header, String name) {
        header.appendChild(this.createTextChild("name", name));
    }

    private String getCreatorFromHeader(Element header) {
        return this.getElementByTagName("creator").getTextContent();
    }

    private void setCreatorToHeader(Element header, String creator) {
        header.appendChild(this.createTextChild("creator", creator));
    }

    private void addBodyToXml() {
        this.getTemplateElement().appendChild(this.getRoot().createElement("body"));
    }

    private void addHeaderToXml() {
        this.getTemplateElement().appendChild(this.getRoot().createElement("header"));
    }

    private void buildTemplateAsXml() {
        Element template = this.getRoot().createElement("template");
        template.setAttribute("version", Template.VERSION);
        this.getRoot().appendChild(template);
        this.addHeaderToXml();
        this.addBodyToXml();
    }

    private void createNewDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LogWriter.error(this.getClass(), ex);
        }
        this.setRoot(builder.newDocument());
    }
}

