/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.karte.template;

import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import open.dolphin.client.karte.template.TemplateBuilder;
import open.dolphin.client.karte.template.TemplateHeader;
import open.dolphin.client.karte.template.TemplateWritable;
import open.dolphin.client.karte.template.error.CantWriteTemplateException;
import open.dolphin.infomodel.DocumentModel;
import open.dolphin.log.LogWriter;

public class TemplateWriter
implements TemplateWritable {
    private TemplateBuilder builder;
    private File path;
    private boolean session;

    @Override
    public void writeHeader(TemplateHeader header) throws CantWriteTemplateException {
        this.sessionGuard();
        this.getBuilder().setHeader(header);
    }

    @Override
    public void writeBody(DocumentModel document) throws CantWriteTemplateException {
        this.sessionGuard();
        this.getBuilder().setBody(this.serializeDocument(document));
    }

    @Override
    public void beginSession(File path) {
        this.path = path;
        this.session = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endSession() throws CantWriteTemplateException {
        try {
            this.save();
        }
        finally {
            this.clearSessionState();
        }
    }

    private void save() throws CantWriteTemplateException {
        FileOutputStream foStream = null;
        OutputStreamWriter writer = null;
        try {
            foStream = new FileOutputStream(this.path);
            writer = new OutputStreamWriter((OutputStream)foStream, "UTF-8");
            this.getBuilder().outputDocumentTo(writer);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CantWriteTemplateException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new CantWriteTemplateException(ex);
        }
        catch (IOException ex) {
            throw new CantWriteTemplateException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), "", (Throwable)ex);
            }
        }
    }

    private void clearSessionState() {
        this.path = null;
        this.session = false;
    }

    private boolean isInSession() {
        return this.session;
    }

    private void sessionGuard() throws CantWriteTemplateException {
        if (this.isInSession()) {
            return;
        }
        throw new CantWriteTemplateException("\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u958b\u304b\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    private TemplateBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new TemplateBuilder();
        }
        return this.builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeDocument(DocumentModel document) throws CantWriteTemplateException {
        String serialized = null;
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
            try {
                stream = new ObjectOutputStream(baoStream);
                stream.writeObject(document);
            }
            finally {
                stream.close();
            }
            byte[] bytes = BASE64EncoderStream.encode((byte[])baoStream.toByteArray());
            serialized = new String(bytes);
        }
        catch (IOException ex) {
            throw new CantWriteTemplateException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ex) {
                LogWriter.error(this.getClass(), "", (Throwable)ex);
            }
        }
        return serialized;
    }
}

