/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.labotestimporter;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import open.dolphin.client.labotestimporter.LaboModuleBuilder;
import open.dolphin.client.labotestimporter.LaboTestImporter;
import open.dolphin.delegater.remote.RemoteLaboDelegater;
import open.dolphin.infomodel.LaboImportSummary;
import open.dolphin.log.LogWriter;
import open.dolphin.table.ObjectReflectTableModel;

class LaboTestFileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 2942768324728994019L;
    private DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private LaboTestImporter context;
    private LinkedList<List<File>> queue;
    private ImportThread importThread;

    public LaboTestFileTransferHandler(LaboTestImporter context) {
        this.context = context;
        this.queue = new LinkedList();
        this.importThread = new ImportThread();
        this.importThread.start();
    }

    @Override
    public boolean importData(JComponent component, Transferable transfer) {
        if (this.canImport(component, transfer.getTransferDataFlavors())) {
            try {
                this.importFiles((List)transfer.getTransferData(this.fileFlavor));
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                LogWriter.error(this.getClass(), ufe);
            }
            catch (IOException ieo) {
                LogWriter.error(this.getClass(), ieo);
            }
        }
        return false;
    }

    private void importFiles(List<File> files) {
        ArrayList<File> xmlFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            if (!this.isLaboTestFile(file)) continue;
            xmlFiles.add(file);
        }
        this.addFiles(xmlFiles);
    }

    private boolean isLaboTestFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".txt");
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized void addFiles(List<File> xmlFiles) {
        if (xmlFiles != null && xmlFiles.size() > 0) {
            this.queue.addLast(xmlFiles);
            this.notify();
        }
    }

    public synchronized List<File> getFiles() {
        while (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.queue.removeFirst();
    }

    class ImportThread
    extends Thread {
        ImportThread() {
        }

        @Override
        public void run() {
            while (!ImportThread.interrupted()) {
                try {
                    List<File> files = LaboTestFileTransferHandler.this.getFiles();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaboTestFileTransferHandler.this.context.getProgressBar().setIndeterminate(true);
                        }
                    });
                    LaboModuleBuilder builder = new LaboModuleBuilder();
                    builder.setLaboDelegater(new RemoteLaboDelegater());
                    final List<LaboImportSummary> result = builder.build(files);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LaboTestFileTransferHandler.this.context.getProgressBar().setIndeterminate(false);
                            LaboTestFileTransferHandler.this.context.getProgressBar().setValue(0);
                            ((ObjectReflectTableModel)LaboTestFileTransferHandler.this.context.getLaboListTable().getModel()).addRows(result);
                            LaboTestFileTransferHandler.this.context.updateCount();
                        }
                    });
                }
                catch (Exception e) {
                    LogWriter.error(this.getClass(), e);
                }
            }
        }
    }
}

