/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.client.schemaeditor;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import open.dolphin.client.schemaeditor.IDrawingHolder;

public class Line2DHolder
implements IDrawingHolder {
    private Line2D.Double line2D;
    private Stroke stroke;
    private Paint paint;
    private AlphaComposite ac;
    private boolean p1;
    private boolean p2;

    public Line2DHolder(Line2D.Double line2D, Stroke stroke, Paint paint, AlphaComposite ac) {
        this.line2D = line2D;
        this.stroke = stroke;
        this.paint = paint;
        this.ac = ac;
    }

    @Override
    public boolean contains(Point p) {
        this.p1 = false;
        this.p2 = false;
        Rectangle2D r = this.getRectangle2D(p);
        if (this.isAtP1(r)) {
            this.p1 = true;
            return true;
        }
        if (this.isAtP2(r)) {
            this.p2 = true;
            return true;
        }
        return this.line2D.intersects(r);
    }

    @Override
    public void draw(Graphics2D g2d) {
        Stroke saveStroke = g2d.getStroke();
        Paint savePaint = g2d.getPaint();
        Composite saveComposite = g2d.getComposite();
        g2d.setStroke(this.stroke);
        g2d.setPaint(this.paint);
        g2d.setComposite(this.ac);
        g2d.draw(this.line2D);
        g2d.setStroke(saveStroke);
        g2d.setPaint(savePaint);
        g2d.setComposite(saveComposite);
    }

    @Override
    public void translate(double x, double y) {
        double x1 = this.line2D.getX1();
        double y1 = this.line2D.getY1();
        double x2 = this.line2D.getX2();
        double y2 = this.line2D.getY2();
        if (this.p1) {
            x1 = this.line2D.getX1() + x;
            y1 = this.line2D.getY1() + y;
        } else if (this.p2) {
            x2 = this.line2D.getX2() + x;
            y2 = this.line2D.getY2() + y;
        } else {
            x1 = this.line2D.getX1() + x;
            y1 = this.line2D.getY1() + y;
            x2 = this.line2D.getX2() + x;
            y2 = this.line2D.getY2() + y;
        }
        this.line2D.setLine(x1, y1, x2, y2);
    }

    private boolean isAtP1(Rectangle2D r) {
        return r.contains(this.line2D.getP1());
    }

    private boolean isAtP2(Rectangle2D r) {
        return r.contains(this.line2D.getP2());
    }

    private Rectangle2D getRectangle2D(Point p) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(p.getX() - 3.0, p.getY() - 3.0, p.getX() + 3.0, p.getY() + 3.0);
        return r;
    }
}

