/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.prefs.Preferences;
import open.dolphin.project.GlobalConstants;

public class ComponentMemory
implements ComponentListener {
    private Component target;
    private Point defaultLocation;
    private Dimension defaultSise;
    private Preferences prefs;
    private String name;
    private boolean report = true;

    public ComponentMemory(Component target, Point loc, Dimension size, Object object) {
        this.target = target;
        this.defaultLocation = loc;
        this.defaultSise = size;
        if (object != null) {
            this.prefs = Preferences.userNodeForPackage(object.getClass());
            this.name = object.getClass().getName();
        }
        target.setLocation(this.defaultLocation);
        target.setSize(this.defaultSise);
        target.addComponentListener(this);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setToPreferenceBounds() {
        if (this.prefs != null) {
            int x = this.prefs.getInt(this.name + "_x", this.defaultLocation.x);
            int y = this.prefs.getInt(this.name + "_y", this.defaultLocation.y);
            int width = this.prefs.getInt(this.name + "_width", this.defaultSise.width);
            int height = this.prefs.getInt(this.name + "_height", this.defaultSise.height);
            this.target.setBounds(x, y, width, height);
        }
    }

    public void putCenter() {
        if (GlobalConstants.isMac()) {
            this.putCenter(3);
        } else {
            this.putCenter(2);
        }
    }

    public void putCenter(int n) {
        n = n != 0 ? n : 2;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.target.getSize();
        int x = (screenSize.width - size.width) / 2;
        int y = (screenSize.height - size.height) / n;
        this.target.setBounds(x, y, size.width, size.height);
    }
}

