/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper.FixedLengthFormat;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import open.dolphin.helper.FixedLengthFormat.IFormat;
import open.dolphin.helper.FixedLengthFormat.Param;

public class Writer {
    private static final byte DEFAULT_PADDING = 32;
    private static final String DEFAULT_SEPARATOR = System.getProperty("line.separator");
    private byte padding;
    private String separator;
    private OutputStream out;
    private String encoding;

    public Writer(OutputStream st, String encoding) throws UnsupportedEncodingException {
        this.init(st, encoding);
    }

    public Writer(String path, String encoding) throws UnsupportedEncodingException, IOException {
        File file = new File(path);
        file.createNewFile();
        this.init(new FileOutputStream(file, true), encoding);
    }

    private void init(OutputStream st, String encoding) throws UnsupportedEncodingException {
        this.out = st;
        this.encoding = encoding;
        this.padding = (byte)32;
        this.separator = DEFAULT_SEPARATOR;
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    private void writeInternal(IFormat format) throws UnsupportedEncodingException, IOException {
        List<Param> params = format.getParam();
        for (Param p : params) {
            byte[] bytes = this.makeBytes(p);
            this.out.write(bytes);
        }
        this.out.write(this.separator.getBytes(this.encoding));
    }

    public void write(IFormat format) throws UnsupportedEncodingException, IOException {
        this.writeInternal(format);
        this.out.flush();
    }

    public void write(List<IFormat> list) throws UnsupportedEncodingException, IOException {
        for (IFormat format : list) {
            this.writeInternal(format);
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    private byte[] makeBytes(Param p) throws UnsupportedEncodingException, IOException {
        int i;
        int size = p.getSize();
        byte[] ret = new byte[size];
        String value = p.getValue();
        if (value != null) {
            byte[] val = value.getBytes(this.encoding);
            if (val.length > size) {
                throw new IOException("value exceeds of size " + size + ": " + value);
            }
            for (i = 0; i < val.length; ++i) {
                ret[i] = val[i];
            }
        }
        while (i < ret.length) {
            ret[i] = this.padding;
            ++i;
        }
        return ret;
    }
}

