/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper.FutureNetII;

import java.util.ArrayList;
import java.util.List;
import open.dolphin.helper.FixedLengthFormat.IFormat;
import open.dolphin.helper.FixedLengthFormat.Param;
import open.dolphin.infomodel.PatientModel;

public class Patient
implements IFormat {
    private static final int SIZE_PATIENT_ID = 12;
    private static final int SIZE_NAME_KANA = 40;
    private static final int SIZE_NAME_KANJI = 20;
    private static final int SIZE_SEX = 1;
    private static final int SIZE_BIRTHDAY = 8;
    private static final int SIZE_ZIP = 8;
    private static final int SIZE_ADDRESS = 40;
    private static final int SIZE_TEL = 12;
    private static final int SIZE_RESERVED = 371;
    private Param patientId;
    private Param nameKana;
    private Param nameKanji;
    private Param sex;
    private Param birthday;
    private Param zip;
    private Param address;
    private Param tel;
    private Param reserved;

    public Patient() {
        this.initialize();
    }

    public Patient(PatientModel patientModel) {
        this.initialize();
        this.setPatientId(patientModel.getPatientId());
        this.setNameKana(patientModel.getKanaName());
        this.setNameKanji(patientModel.getFullName());
        this.setSex(patientModel.getGender().substring(0, 1).toUpperCase());
        this.setBirthday(patientModel.getBirthday().replaceAll("-", ""));
        this.setZip(patientModel.contactZipCode());
        this.setAddress(patientModel.contactAddress());
        this.setTel(patientModel.getTelephone());
    }

    private void initialize() {
        this.patientId = new Param(12);
        this.nameKana = new Param(40);
        this.nameKanji = new Param(20);
        this.sex = new Param(1);
        this.birthday = new Param(8);
        this.zip = new Param(8);
        this.address = new Param(40);
        this.tel = new Param(12);
        this.reserved = new Param(371);
    }

    public String getPatientId() {
        return this.patientId.getValue();
    }

    public void setPatientId(String patientId) {
        int len = patientId.length();
        int rest = 12 - len;
        String value = rest == 0 ? patientId : (rest > 0 ? String.format("%0" + rest + "d", 0) + patientId : patientId.substring(-rest, len));
        this.patientId.setValue(value);
    }

    public String getNameKana() {
        return this.nameKana.getValue();
    }

    public void setNameKana(String nameKana) {
        this.nameKana.setValue(nameKana);
    }

    public String getNameKanji() {
        return this.nameKanji.getValue();
    }

    public void setNameKanji(String nameKanji) {
        this.nameKanji.setValue(nameKanji);
    }

    public String getSex() {
        return this.sex.getValue();
    }

    public void setSex(String sex) {
        this.sex.setValue(sex);
    }

    public String getBirthday() {
        return this.birthday.getValue();
    }

    public void setBirthday(String birthday) {
        this.birthday.setValue(birthday);
    }

    public String getZip() {
        return this.zip.getValue();
    }

    public void setZip(String zip) {
        this.zip.setValue(zip);
    }

    public String getAddress() {
        return this.address.getValue();
    }

    public void setAddress(String address) {
        this.address.setValue(address);
    }

    public String getTel() {
        return this.tel.getValue();
    }

    public void setTel(String tel) {
        this.tel.setValue(tel);
    }

    public String getReserved() {
        return this.reserved.getValue();
    }

    public List getParam() {
        ArrayList<Param> arr = new ArrayList<Param>();
        arr.add(this.patientId);
        arr.add(this.nameKana);
        arr.add(this.nameKanji);
        arr.add(this.sex);
        arr.add(this.birthday);
        arr.add(this.zip);
        arr.add(this.address);
        arr.add(this.tel);
        arr.add(this.reserved);
        return arr;
    }
}

