/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import open.dolphin.project.GlobalConstants;

public class WindowSupport
implements MenuListener {
    private static List<WindowSupport> allWindows = new ArrayList<WindowSupport>();
    private static final String WINDOW_MWNU_NAME = "\u30a6\u30a4\u30f3\u30c9\u30a6";
    private JFrame frame;
    private JMenuBar menuBar;
    private JMenu windowMenu;
    private Action windowAction;

    public static WindowSupport create(final JFrame frame, String title) {
        frame.setTitle(title);
        ImageIcon icon = GlobalConstants.getImageIcon("web_32.gif");
        frame.setIconImage(icon.getImage());
        JMenuBar menuBar = new JMenuBar();
        JMenu windowMenu = new JMenu(WINDOW_MWNU_NAME);
        menuBar.add(windowMenu);
        frame.setJMenuBar(menuBar);
        AbstractAction windowAction = new AbstractAction(title){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.toFront();
            }
        };
        final WindowSupport ret = new WindowSupport(frame, menuBar, windowMenu, windowAction);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                WindowSupport.windowOpened(ret);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                WindowSupport.windowClosed(ret);
            }
        });
        windowMenu.addMenuListener(ret);
        return ret;
    }

    public static void windowOpened(WindowSupport opened) {
        allWindows.add(opened);
    }

    public static void windowClosed(WindowSupport closed) {
        allWindows.remove(closed);
        closed = null;
    }

    public static boolean contains(WindowSupport toCheck) {
        return allWindows.contains(toCheck);
    }

    private WindowSupport(JFrame frame, JMenuBar menuBar, JMenu windowMenu, Action windowAction) {
        this.frame = frame;
        this.menuBar = menuBar;
        this.windowMenu = windowMenu;
        this.windowAction = windowAction;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }

    public Action getWindowAction() {
        return this.windowAction;
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu wm = (JMenu)e.getSource();
        wm.removeAll();
        for (WindowSupport ws : allWindows) {
            Action action = ws.getWindowAction();
            wm.add(action);
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

