/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import open.dolphin.infomodel.IStampInfo;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.ModelUtils;
import open.dolphin.queries.DolphinQuery;
import open.dolphin.utils.CombinedStringParser;

@Embeddable
public class ModuleInfoBean
extends InfoModel
implements IStampInfo,
Comparable,
Serializable {
    @Column(nullable=false)
    private String stampName;
    @Column(nullable=false)
    private String stampRole;
    @Column(nullable=false)
    private int stampNumber;
    @Column(nullable=false)
    private String entity;
    @Transient
    private boolean editable = true;
    @Transient
    private boolean asp;
    @Transient
    private String stampId;
    @Transient
    private String memo;
    @Transient
    private boolean turnIn;

    public ModuleInfoBean() {
        if (this.stampRole == null) {
            CombinedStringParser line = new CombinedStringParser('|', "");
            line.limit(2);
            line.set(0, "");
            line.set(1, "");
            this.stampRole = line.toCombinedString();
        } else {
            CombinedStringParser line = new CombinedStringParser('|', this.stampRole);
            line.limit(2);
            line.set(1, "");
            this.stampRole = line.toCombinedString();
        }
    }

    @Override
    public boolean search(DolphinQuery query) {
        return this.stampName != null && this.stampName.indexOf(query.what("keyword")) != -1;
    }

    @Override
    public void initialize(String stampId, String name, String text, String entity, String _role) {
        this.setStampId(stampId);
        this.setStampName(name);
        this.setStampMemo(text);
        this.setEntity(entity);
        this.setStampRole(_role);
    }

    @Override
    public String getStampName() {
        return this.stampName;
    }

    @Override
    public void setStampName(String text) {
        this.stampName = text;
    }

    @Override
    public String getStampRole() {
        CombinedStringParser line = new CombinedStringParser('|', this.stampRole);
        line.limit(2);
        return line.get(0);
    }

    @Override
    public void setStampRole(String _role) {
        CombinedStringParser line = new CombinedStringParser('|', this.stampRole);
        line.limit(2);
        line.set(0, _role);
        this.stampRole = line.toCombinedString();
    }

    @Override
    public String getStampStatus() {
        CombinedStringParser line = new CombinedStringParser('|', this.stampRole);
        line.limit(2);
        return line.get(1);
    }

    @Override
    public void setStampStatus(String status) {
        CombinedStringParser line = new CombinedStringParser('|', this.stampRole);
        line.limit(2);
        line.set(1, status);
        this.stampRole = line.toCombinedString();
    }

    @Override
    public String getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(String entity) {
        this.entity = entity;
    }

    @Override
    public boolean isSerialized() {
        return this.stampId != null;
    }

    @Override
    public boolean isASP() {
        return this.asp;
    }

    @Override
    public void setASP(boolean asp) {
        this.asp = asp;
    }

    @Override
    public String getStampId() {
        return this.stampId;
    }

    @Override
    public void setStampId(String id) {
        this.stampId = id;
    }

    @Override
    public String getStampMemo() {
        return this.memo;
    }

    @Override
    public void setStampMemo(String memo) {
        this.memo = memo;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setTurnIn(boolean turnIn) {
        this.turnIn = turnIn;
    }

    @Override
    public boolean isTurnIn() {
        return this.turnIn;
    }

    @Override
    public String toString() {
        if (this.entity.equals("diagnosis")) {
            String alias = ModelUtils.getDiagnosisAlias(this.stampName);
            return alias != null ? alias : this.stampName;
        }
        return this.stampName;
    }

    @Override
    public void setStampNumber(int stampNumber) {
        this.stampNumber = stampNumber;
    }

    @Override
    public int getStampNumber() {
        return this.stampNumber;
    }

    @Override
    public int compareTo(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            int result = this.getStampNumber() - ((ModuleInfoBean)other).getStampNumber();
            return result;
        }
        return -1;
    }

    private String nullToString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<ModuleInfoBean name='" + this.nullToString(this.stampName) + "' role='" + this.nullToString(this.stampRole) + "' stampNumber='" + Integer.toString(this.stampNumber) + "' entity='" + this.nullToString(this.entity) + "' />" + System.getProperty("line.separator"));
    }
}

