/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.List;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.queries.DolphinQuery;

public class SimpleDate
extends InfoModel
implements Comparable {
    private static final long serialVersionUID = 2137848922359964710L;
    private int year;
    private int month;
    private int day;
    private List timeFrames;
    private String eventCode;

    public SimpleDate() {
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public static SimpleDate today() {
        return new SimpleDate(new GregorianCalendar());
    }

    public static SimpleDate mmlDateToSimpleDate(String mmlDate) {
        int year = Integer.parseInt(mmlDate.substring(0, 4));
        int month = Integer.parseInt(mmlDate.substring(5, 7)) - 1;
        int date = Integer.parseInt(mmlDate.substring(8, 10));
        return new SimpleDate(year, month, date);
    }

    public static String simpleDateToMmldate(SimpleDate sd) {
        StringBuffer buf = new StringBuffer();
        buf.append(sd.getYear());
        buf.append("-");
        int month = sd.getMonth() + 1;
        if (month < 10) {
            buf.append("0");
        }
        buf.append(month);
        buf.append("-");
        int day = sd.getDay();
        if (day < 10) {
            buf.append("0");
        }
        buf.append(day);
        return buf.toString();
    }

    public SimpleDate(int year, int month, int day) {
        this();
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public SimpleDate(int[] spec) {
        this();
        this.setYear(spec[0]);
        this.setMonth(spec[1]);
        this.setDay(spec[2]);
    }

    public SimpleDate(GregorianCalendar gc) {
        this();
        this.setYear(gc.get(1));
        this.setMonth(gc.get(2));
        this.setDay(gc.get(5));
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getDay() {
        return this.day;
    }

    public boolean equalDate(int year, int month, int day) {
        return year == this.year && month == this.month && day == this.day;
    }

    public String toString() {
        return String.valueOf(this.day);
    }

    public void setEventCode(String c) {
        this.eventCode = c;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public int compareTo(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            SimpleDate other = (SimpleDate)o;
            int oYear = other.getYear();
            int oMonth = other.getMonth();
            int oDay = other.getDay();
            if (this.year != oYear) {
                return this.year < oYear ? -1 : 1;
            }
            if (this.month != oMonth) {
                return this.month < oMonth ? -1 : 1;
            }
            if (this.day != oDay) {
                return this.day < oDay ? -1 : 1;
            }
            return 0;
        }
        return -1;
    }

    public int compareMonthDayTo(Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            SimpleDate other = (SimpleDate)o;
            int oMonth = other.getMonth();
            int oDay = other.getDay();
            if (this.month != oMonth) {
                return this.month < oMonth ? -1 : 1;
            }
            if (this.day != oDay) {
                return this.day < oDay ? -1 : 1;
            }
            return 0;
        }
        return -1;
    }

    public void setTimeFrames(List timeFrames) {
        this.timeFrames = timeFrames;
    }

    public List getTimeFrames() {
        return this.timeFrames;
    }

    public void serialize(Writer result) throws IOException {
    }

    public void deserialize(Writer result) throws IOException {
    }
}

