/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.infomodel;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import open.dolphin.infomodel.IStampTreeModel;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.infomodel.UserModel;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;

public class StampTreeModel
extends InfoModel
implements IStampTreeModel {
    private long id;
    private UserModel user;
    private String name;
    private String publishType;
    private String category;
    private String partyName;
    private String url;
    private String description;
    private Date publishedDate;
    private Date lastUpdated;
    private String published;
    private byte[] treeBytes;
    private Blob treeBlob;

    public void initialize(UserModel user, String name, String description, String partyName, String url, String xml) {
        this.setUser(user);
        this.setName(name);
        this.setDescription(description);
        this.setPartyName(partyName);
        this.setUrl(url);
        this.setTreeXml(xml);
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public UserModel getUser() {
        return this.user;
    }

    public void setUser(UserModel DUsers) {
        this.user = DUsers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String treeName) {
        this.name = treeName;
    }

    @Override
    public String getPublishType() {
        return this.publishType;
    }

    @Override
    public void setPublishType(String publishType) {
        this.publishType = publishType;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getPartyName() {
        return this.partyName;
    }

    public void setPartyName(String partyName) {
        this.partyName = partyName;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Date publisheddate) {
        this.publishedDate = publisheddate;
    }

    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public void setLastUpdated(Date lastupdated) {
        this.lastUpdated = lastupdated;
    }

    public String getPublished() {
        return this.published;
    }

    public void setPublished(String published) {
        this.published = published;
    }

    @Override
    public byte[] getTreeBytes() {
        return this.treeBytes;
    }

    public void setTreeBytes(byte[] treeBytes) {
        if (treeBytes != null) {
            this.treeBytes = treeBytes;
            this.treeBlob = new BlobImpl(treeBytes);
        }
    }

    public Blob getTreeBlob() {
        return this.treeBlob;
    }

    public void setTreeBlob(Blob treeBlob) throws SQLException {
        if (treeBlob != null) {
            this.treeBlob = treeBlob;
            this.treeBytes = treeBlob.getBytes(1L, (int)treeBlob.length());
        }
    }

    @Override
    public String getTreeXml() {
        if (this.treeBytes != null) {
            try {
                return new String(this.treeBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LogWriter.error(this.getClass(), null, (Throwable)ex);
            }
        }
        return "";
    }

    @Override
    public void setTreeXml(String treeXml) {
        if (treeXml != null) {
            try {
                this.treeBytes = treeXml.getBytes("UTF-8");
                this.treeBlob = this.treeBytes == null ? null : new BlobImpl(this.treeBytes);
            }
            catch (UnsupportedEncodingException ex) {
                LogWriter.error(this.getClass(), null, (Throwable)ex);
            }
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StampTreeModel other = (StampTreeModel)obj;
        return this.getId() == other.getId();
    }
}

